/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.gemini.atom.api.GeminiTemplateAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTemplateAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplateDetailsAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplateListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplatePageQryAtomRspBO;
import com.tydic.gemini.dao.GeminiTemplateMapper;
import com.tydic.gemini.dao.GeminiVariableMapper;
import com.tydic.gemini.dao.po.GeminiTemplatePO;
import com.tydic.gemini.dao.po.GeminiVariablePO;
import com.tydic.gemini.utils.GeminiTranslationUtil;
import com.tydic.gemini.web.api.bo.GeminiTemplateDataBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="geminiTemplateAtomService")
public class GeminiTemplateAtomServiceImpl
implements GeminiTemplateAtomService {
    private final GeminiTemplateMapper geminiTemplateMapper;
    private final GeminiVariableMapper geminiVariableMapper;

    public GeminiTemplateAtomServiceImpl(GeminiTemplateMapper geminiTemplateMapper, GeminiVariableMapper geminiVariableMapper) {
        this.geminiTemplateMapper = geminiTemplateMapper;
        this.geminiVariableMapper = geminiVariableMapper;
    }

    @Override
    public int qryTemplateNum(GeminiTemplateAtomReqBO atomReqBO) {
        GeminiTemplatePO geminiTemplatePo = new GeminiTemplatePO();
        BeanUtils.copyProperties((Object)((Object)atomReqBO), (Object)geminiTemplatePo);
        return this.geminiTemplateMapper.getCheckBy(geminiTemplatePo);
    }

    @Override
    public GeminiTemplateDetailsAtomRspBO qryTemplateDetails(GeminiTemplateAtomReqBO atomReqBO) {
        GeminiTemplateDetailsAtomRspBO atomRspBO = new GeminiTemplateDetailsAtomRspBO();
        GeminiTemplatePO templatePo = new GeminiTemplatePO();
        BeanUtils.copyProperties((Object)((Object)atomReqBO), (Object)templatePo);
        if (this.geminiTemplateMapper.getCheckBy(templatePo) < 1) {
            atomRspBO.setRespCode("5001");
            atomRspBO.setRespDesc("\u67e5\u8be2\u5931\u8d25\uff1a\u6a21\u677fId:" + atomReqBO.getTemplateId() + " \u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6a21\u677f");
            return atomRspBO;
        }
        GeminiTemplatePO templateDetailsPo = this.geminiTemplateMapper.getModelBy(templatePo);
        BeanUtils.copyProperties((Object)templateDetailsPo, (Object)((Object)atomRspBO));
        return atomRspBO;
    }

    @Override
    public GeminiTemplateListQryAtomRspBO qryTemplateList(GeminiTemplateAtomReqBO atomReqBO) {
        GeminiTemplateListQryAtomRspBO atomRspBO = new GeminiTemplateListQryAtomRspBO();
        GeminiTemplatePO templateReqPo = new GeminiTemplatePO();
        BeanUtils.copyProperties((Object)((Object)atomReqBO), (Object)templateReqPo);
        templateReqPo.setOrderBy("STATUS desc,CREATE_TIME desc");
        List<GeminiTemplatePO> templateRspPoList = this.geminiTemplateMapper.getList(templateReqPo);
        atomRspBO.setTemplateDataList(JSON.parseArray((String)JSON.toJSONString(templateRspPoList), GeminiTemplateDataBO.class));
        return atomRspBO;
    }

    @Override
    public GeminiTemplatePageQryAtomRspBO qryTemplatePageList(GeminiTemplateAtomReqBO atomReqBO, Page<GeminiTemplatePO> page) {
        GeminiTemplatePageQryAtomRspBO atomRspBO = new GeminiTemplatePageQryAtomRspBO();
        GeminiTemplatePO templateReqPo = new GeminiTemplatePO();
        BeanUtils.copyProperties((Object)((Object)atomReqBO), (Object)templateReqPo);
        templateReqPo.setOrderBy("STATUS desc,CREATE_TIME desc");
        List<GeminiTemplatePO> templatePoList = this.geminiTemplateMapper.getListPage(templateReqPo, page);
        atomRspBO.setTemplateDataBoList(JSON.parseArray((String)JSON.toJSONString(templatePoList), GeminiTemplateDataBO.class));
        return atomRspBO;
    }

    @Override
    public GeminiTemplateListQryAtomRspBO qryTemplateListByIds(GeminiTemplateAtomReqBO atomReqBO) {
        GeminiTemplateListQryAtomRspBO retBo = new GeminiTemplateListQryAtomRspBO();
        List<GeminiTemplatePO> templatePoList = this.geminiTemplateMapper.getListByIds(atomReqBO.getTemplateIds());
        List<GeminiVariablePO> geminiVariablePOS = this.geminiVariableMapper.getRelVariableByTemplateIds(templatePoList.stream().map(item -> item.getTemplateId()).collect(Collectors.toList()));
        Map<String, String> variableMap = geminiVariablePOS.stream().collect(Collectors.toMap(item -> item.getVariableId().toString(), item -> item.getVariableName()));
        ArrayList<GeminiTemplateDataBO> templateDataBOList = new ArrayList<GeminiTemplateDataBO>();
        for (GeminiTemplatePO item2 : templatePoList) {
            GeminiTemplateDataBO dataBO = new GeminiTemplateDataBO();
            BeanUtils.copyProperties((Object)item2, (Object)dataBO);
            dataBO.setMessageContent(GeminiTranslationUtil.codeReplacementId((String)dataBO.getMessageContent(), variableMap));
            templateDataBOList.add(dataBO);
        }
        retBo.setTemplateDataList(templateDataBOList);
        return retBo;
    }
}

