/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.gemini.atom.api.GeminiVariableQryAtomService;
import com.tydic.gemini.atom.api.bo.GeminiVariableDetailQryAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiVariableDetailQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiVariablePageQryAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiVariablePageQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.VariableBO;
import com.tydic.gemini.base.GeminiRspPageBaseBO;
import com.tydic.gemini.busi.api.GeminiDictionaryBusiService;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiRspBO;
import com.tydic.gemini.dao.GeminiVariableMapper;
import com.tydic.gemini.dao.po.GeminiVariablePO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="geminiVariableQryAtomService")
public class GeminiVariableQryAtomServiceImpl
implements GeminiVariableQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(GeminiVariableQryAtomServiceImpl.class);
    private GeminiVariableMapper geminiVariableMapper;
    private GeminiDictionaryBusiService geminiDictionaryBusiService;
    private static final String DEFAULT_ORDER_BY = "status desc, create_time desc";

    public GeminiVariableQryAtomServiceImpl(GeminiVariableMapper geminiVariableMapper, GeminiDictionaryBusiService geminiDictionaryBusiService) {
        this.geminiVariableMapper = geminiVariableMapper;
        this.geminiDictionaryBusiService = geminiDictionaryBusiService;
    }

    @Override
    public GeminiVariablePageQryAtomRspBO getPageList(GeminiVariablePageQryAtomReqBO reqBO) {
        List<GeminiVariablePO> listPage;
        log.info("\u8fdb\u5165\u53d8\u91cf\u67e5\u8be2atom\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c \u5f53\u524d\u65b9\u6cd5\uff1agetPage\uff08\uff09, \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        GeminiVariablePageQryAtomRspBO rspBO = new GeminiVariablePageQryAtomRspBO();
        GeminiRspPageBaseBO data = new GeminiRspPageBaseBO();
        rspBO.setData(data);
        ArrayList<VariableBO> rows = new ArrayList<VariableBO>();
        data.setRows(rows);
        Page<GeminiVariablePO> page = this.getPage(reqBO);
        GeminiVariablePO queryPo = new GeminiVariablePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryPo);
        if (StringUtils.isEmpty((Object)reqBO.getOrderBy())) {
            queryPo.setOrderBy(DEFAULT_ORDER_BY);
        }
        if (!CollectionUtils.isEmpty(listPage = this.geminiVariableMapper.getListPage(queryPo, page))) {
            Map<String, Map<String, String>> dicMap = this.getDicMap();
            for (GeminiVariablePO variablePo : listPage) {
                VariableBO variableBO = new VariableBO();
                BeanUtils.copyProperties((Object)variablePo, (Object)variableBO);
                variableBO.setStatus(dicMap.get("VARIABLE_STATUS").get(variablePo.getStatus().toString()));
                rows.add(variableBO);
            }
        }
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }

    @Override
    public GeminiVariableDetailQryAtomRspBO getDetail(GeminiVariableDetailQryAtomReqBO reqBO) {
        log.info("\u8fdb\u5165\u53d8\u91cf\u67e5\u8be2atom\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c \u5f53\u524d\u65b9\u6cd5\uff1agetDetail(), \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        GeminiVariableDetailQryAtomRspBO atomRspBO = new GeminiVariableDetailQryAtomRspBO();
        GeminiVariablePO variablePo = new GeminiVariablePO();
        variablePo.setVariableId(reqBO.getVariableId());
        GeminiVariablePO variable = this.geminiVariableMapper.getModelBy(variablePo);
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        BeanUtils.copyProperties((Object)variable, (Object)((Object)atomRspBO));
        atomRspBO.setStatus(dicMap.get("VARIABLE_STATUS").get(variable.getStatus().toString()));
        return atomRspBO;
    }

    private Page<GeminiVariablePO> getPage(GeminiVariablePageQryAtomReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private Map<String, Map<String, String>> getDicMap() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("VARIABLE_STATUS");
        GeminiDictionaryBusiReqBO dictionaryBusiReqBO = new GeminiDictionaryBusiReqBO();
        dictionaryBusiReqBO.setPCodes(pCodes);
        GeminiDictionaryBusiRspBO dicMap = this.geminiDictionaryBusiService.getDicMap(dictionaryBusiReqBO);
        return dicMap.getDicMaps();
    }
}

