/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.gemini.busi.api.GeminiDealInnerMessageBusiService;
import com.tydic.gemini.busi.api.bo.GeminiInnerMessageAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiInnerMessageAddBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiInnerMessageMapper;
import com.tydic.gemini.dao.po.GeminiInnerMessagePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="geminiDealInnerMessageBusiService")
public class GeminiDealInnerMessageBusiServiceImpl
implements GeminiDealInnerMessageBusiService {
    private static final Logger log = LoggerFactory.getLogger(GeminiDealInnerMessageBusiServiceImpl.class);
    private GeminiInnerMessageMapper geminiInnerMessageMapper;
    private static final String SEND_ID = "0";
    private static final String SEND_NAME = "\u65e0\u8bb0\u5f55";

    public GeminiDealInnerMessageBusiServiceImpl(GeminiInnerMessageMapper geminiInnerMessageMapper) {
        this.geminiInnerMessageMapper = geminiInnerMessageMapper;
    }

    @Override
    public GeminiInnerMessageAddBusiRspBO addInnerMessage(GeminiInnerMessageAddBusiReqBO busiReqBO) {
        GeminiInnerMessageAddBusiRspBO busiRspBO = new GeminiInnerMessageAddBusiRspBO();
        Date nowTime = this.geminiInnerMessageMapper.getBaseDate();
        List innerMessagePoList = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getGeminiInnerMessageDataBOList()), GeminiInnerMessagePO.class);
        innerMessagePoList.forEach(innerMessagePo -> {
            innerMessagePo.setCreateTime(nowTime);
            innerMessagePo.setUpdateTime(nowTime);
            innerMessagePo.setStatus(GeminiConstants.StatusConstants.MESSAGE_UNREAD_STATUS);
            if (StringUtils.isEmpty((Object)innerMessagePo.getSendId())) {
                innerMessagePo.setSendId(SEND_ID);
            }
            if (StringUtils.isEmpty((Object)innerMessagePo.getSendName())) {
                innerMessagePo.setSendName(SEND_NAME);
            }
        });
        int quantity = this.geminiInnerMessageMapper.insertBatch(innerMessagePoList);
        if (quantity < 1) {
            throw new GeminiBusinessException("6011", "\u7ad9\u5185\u4fe1\u4fe1\u606f\u65b0\u589e\u5f02\u5e38");
        }
        log.info("*** \u7ad9\u5185\u4fe1\u65b0\u589e\u5b8c\u6bd5 ***");
        return busiRspBO;
    }
}

