/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.gemini.busi.api.GeminiDealTaskBusiService;
import com.tydic.gemini.busi.api.GeminiDealTemplateBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTaskAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskAddBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditStatusBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditStatusBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateAddBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiRelTemplateMapper;
import com.tydic.gemini.dao.GeminiTaskConditionMapper;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.GeminiTaskReceiverMapper;
import com.tydic.gemini.dao.GeminiTypeMapper;
import com.tydic.gemini.dao.po.GeminiRelTemplatePO;
import com.tydic.gemini.dao.po.GeminiTaskConditionPO;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.dao.po.GeminiTaskReceiverPO;
import com.tydic.gemini.dao.po.GeminiTypePO;
import com.tydic.gemini.enums.GeminiEnums;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.web.api.bo.GeminiConditionDataBO;
import com.tydic.gemini.web.api.bo.GeminiTaskReceiverDataBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="geminiDealTaskBusiService")
public class GeminiDealTaskBusiServiceImpl
implements GeminiDealTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(GeminiDealTaskBusiServiceImpl.class);
    private final GeminiTaskMapper geminiTaskMapper;
    private final GeminiTaskConditionMapper geminiTaskConditionMapper;
    private final GeminiTaskReceiverMapper geminiTaskReceiverMapper;
    private final GeminiDealTemplateBusiService geminiDealTemplateBusiService;
    private final GeminiRelTemplateMapper geminiRelTemplateMapper;
    private final GeminiTypeMapper geminiTypeMapper;

    public GeminiDealTaskBusiServiceImpl(GeminiTaskMapper geminiTaskMapper, GeminiTaskConditionMapper geminiTaskConditionMapper, GeminiTaskReceiverMapper geminiTaskReceiverMapper, GeminiDealTemplateBusiService geminiDealTemplateBusiService, GeminiRelTemplateMapper geminiRelTemplateMapper, GeminiTypeMapper geminiTypeMapper) {
        this.geminiTaskMapper = geminiTaskMapper;
        this.geminiTaskConditionMapper = geminiTaskConditionMapper;
        this.geminiTaskReceiverMapper = geminiTaskReceiverMapper;
        this.geminiDealTemplateBusiService = geminiDealTemplateBusiService;
        this.geminiRelTemplateMapper = geminiRelTemplateMapper;
        this.geminiTypeMapper = geminiTypeMapper;
    }

    @Override
    public GeminiTaskAddBusiRspBO addTaskInfo(GeminiTaskAddBusiReqBO busiReqBO) {
        GeminiTaskAddBusiRspBO busiRspBO = new GeminiTaskAddBusiRspBO();
        GeminiTaskPO taskInsertPo = new GeminiTaskPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)taskInsertPo);
        Date createTime = this.geminiTaskMapper.getBaseDate();
        String createOperName = "";
        if (!StringUtils.isEmpty((Object)busiReqBO.getUserName())) {
            createOperName = busiReqBO.getUserName();
        }
        taskInsertPo.setCreateTime(createTime);
        taskInsertPo.setUpdateTime(createTime);
        taskInsertPo.setCreateOperName(createOperName);
        taskInsertPo.setUpdateOperName(createOperName);
        this.insertTaskCode(taskInsertPo);
        int quantity = this.geminiTaskMapper.insert(taskInsertPo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6001", "\u901a\u77e5\u4efb\u52a1\u8868\u65b0\u589e\u5f02\u5e38");
        }
        Long taskId = taskInsertPo.getTaskId();
        log.info("\u8fd4\u56de\u7684\u901a\u77e5\u4efb\u52a1Id\uff1a{}", (Object)taskId);
        if (!CollectionUtils.isEmpty(busiReqBO.getTaskConditionList())) {
            this.insertTaskCondition(busiReqBO.getTaskConditionList(), taskId);
        }
        this.insertReceiver(busiReqBO.getTaskReceiverList(), taskId);
        GeminiTemplateAddBusiReqBO templateAddReqBO = new GeminiTemplateAddBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)((Object)templateAddReqBO));
        Long templateId = this.updateTemplateId(templateAddReqBO, taskId);
        if (!StringUtils.isEmpty((Object)busiReqBO.getThirdpartyTemplateId())) {
            GeminiRelTemplatePO relTemplateModelReqPo = new GeminiRelTemplatePO();
            relTemplateModelReqPo.setTemplateId(templateId);
            relTemplateModelReqPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
            GeminiRelTemplatePO relTemplateModelRspPo = this.geminiRelTemplateMapper.getModelBy(relTemplateModelReqPo);
            if (!StringUtils.isEmpty((Object)relTemplateModelRspPo) && !relTemplateModelRspPo.getThirdTemplateCode().equals(busiReqBO.getThirdpartyTemplateId())) {
                throw new GeminiBusinessException("6001", "\u4f20\u5165\u7684\u7b2c\u4e09\u65b9\u6a21\u677fId\u4e0e\u8be5\u6a21\u677f\u5bf9\u5e94\u7684\u7b2c\u4e09\u65b9\u6a21\u677fId\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5");
            }
            this.insertRelTemplate(taskId, templateId, busiReqBO.getThirdpartyTemplateId(), busiReqBO.getSendType());
        }
        return busiRspBO;
    }

    @Override
    public GeminiTaskEditStatusBusiRspBO editTaskStatus(GeminiTaskEditStatusBusiReqBO busiReqBO) {
        GeminiTaskEditStatusBusiRspBO busiRspBO = new GeminiTaskEditStatusBusiRspBO();
        GeminiTaskPO taskPo = new GeminiTaskPO();
        taskPo.setTaskId(busiReqBO.getTaskId());
        taskPo.setStatus(busiReqBO.getStatus());
        int quantity = this.geminiTaskMapper.updateById(taskPo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6007", "\u901a\u77e5\u4efb\u52a1\u72b6\u6001\u4fee\u6539\u5931\u8d25");
        }
        return busiRspBO;
    }

    @Override
    public GeminiTaskEditBusiRspBO editTaskInfo(GeminiTaskEditBusiReqBO busiReqBO) {
        GeminiTaskEditBusiRspBO busiRspBO = new GeminiTaskEditBusiRspBO();
        GeminiTaskPO taskUpdatePo = new GeminiTaskPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)taskUpdatePo);
        Date updateTime = this.geminiTaskMapper.getBaseDate();
        String updateOperName = "";
        if (!StringUtils.isEmpty((Object)busiReqBO.getUserName())) {
            updateOperName = busiReqBO.getUserName();
        }
        taskUpdatePo.setUpdateTime(updateTime);
        taskUpdatePo.setUpdateOperName(updateOperName);
        this.insertTaskCode(taskUpdatePo);
        int quantity = this.geminiTaskMapper.updateById(taskUpdatePo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6006", "\u901a\u77e5\u4efb\u52a1\u4fee\u6539\u5931\u8d25");
        }
        GeminiTaskConditionPO taskConditionUpdatePo = new GeminiTaskConditionPO();
        taskConditionUpdatePo.setTaskId(busiReqBO.getTaskId());
        this.geminiTaskConditionMapper.deleteBy(taskConditionUpdatePo);
        if (!CollectionUtils.isEmpty(busiReqBO.getTaskConditionList())) {
            this.insertTaskCondition(busiReqBO.getTaskConditionList(), busiReqBO.getTaskId());
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getTaskReceiverList())) {
            this.insertReceiver(busiReqBO.getTaskReceiverList(), busiReqBO.getTaskId());
        }
        GeminiTemplateAddBusiReqBO templateAddReqBO = new GeminiTemplateAddBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)((Object)templateAddReqBO));
        Long templateId = this.updateTemplateId(templateAddReqBO, busiReqBO.getTaskId());
        if (!StringUtils.isEmpty((Object)busiReqBO.getThirdpartyTemplateId())) {
            this.insertRelTemplate(busiReqBO.getTaskId(), templateId, busiReqBO.getThirdpartyTemplateId(), busiReqBO.getSendType());
        } else {
            GeminiRelTemplatePO relTemplatePo = new GeminiRelTemplatePO();
            relTemplatePo.setTemplateId(templateId);
            this.geminiRelTemplateMapper.deleteBy(relTemplatePo);
        }
        return busiRspBO;
    }

    public Long updateTemplateId(GeminiTemplateAddBusiReqBO templateAddReqBO, Long taskId) {
        Long templateId;
        log.info("------- \u5f00\u59cb\u8bb0\u5f55\u6a21\u677f\u4fe1\u606f\u8868\uff08\u5224\u65ad\u6a21\u677f\u662f\u5426\u4e3a\u65b0\u5efa -------");
        if (templateAddReqBO.getTemplateId() == null) {
            templateAddReqBO.setCreateWay(GeminiConstants.JudgmentWayConstants.SYSTEM_CREATE_WAY);
            templateAddReqBO.setTemplateName(templateAddReqBO.getMessageTitle() + Sequence.getInstance().nextId());
            templateAddReqBO.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
            GeminiTemplateAddBusiRspBO templateAddRspBO = this.geminiDealTemplateBusiService.addTemplateInfo(templateAddReqBO);
            if (!"0000".equals(templateAddRspBO.getRespCode())) {
                throw new GeminiBusinessException(templateAddRspBO.getRespCode(), templateAddRspBO.getRespDesc());
            }
            templateId = templateAddRspBO.getTemplateId();
        } else {
            templateId = templateAddReqBO.getTemplateId();
        }
        GeminiTaskPO taskUpdateTemplateIdPo = new GeminiTaskPO();
        taskUpdateTemplateIdPo.setTaskId(taskId);
        taskUpdateTemplateIdPo.setTemplateId(templateId);
        this.geminiTaskMapper.updateById(taskUpdateTemplateIdPo);
        return templateId;
    }

    public void insertTaskCondition(List<GeminiConditionDataBO> taskConditionList, Long taskId) {
        log.info("------- \u5f00\u59cb\u8bb0\u5f55\u4efb\u52a1\u6761\u4ef6\u4fe1\u606f\u8868 -------");
        ArrayList<GeminiTaskConditionPO> taskConditionPoList = new ArrayList<GeminiTaskConditionPO>();
        for (GeminiConditionDataBO conditionDataBO : taskConditionList) {
            GeminiTaskConditionPO taskConditionPo = new GeminiTaskConditionPO();
            BeanUtils.copyProperties((Object)conditionDataBO, (Object)taskConditionPo);
            taskConditionPo.setTaskId(taskId);
            taskConditionPo.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
            taskConditionPo.setConditionCodeList(JSON.toJSONString((Object)conditionDataBO.getConditionCodeList()));
            taskConditionPoList.add(taskConditionPo);
        }
        int quantity = this.geminiTaskConditionMapper.insertBatch(taskConditionPoList);
        if (quantity < 1) {
            throw new GeminiBusinessException("6001", "\u4efb\u52a1\u6761\u4ef6\u4fe1\u606f\u8868\u65b0\u589e\u5f02\u5e38");
        }
    }

    public void insertReceiver(List<GeminiTaskReceiverDataBO> taskReceiverList, Long taskId) {
        log.info("------- \u5f00\u59cb\u8bb0\u5f55\u4efb\u52a1\u63a5\u6536\u5bf9\u8c61 -------");
        List taskReceiverPoList = JSON.parseArray((String)JSON.toJSONString(taskReceiverList), GeminiTaskReceiverPO.class);
        GeminiTaskReceiverPO taskReceiverDeletePo = new GeminiTaskReceiverPO();
        taskReceiverDeletePo.setTaskId(taskId);
        this.geminiTaskReceiverMapper.deleteBy(taskReceiverDeletePo);
        taskReceiverPoList.forEach(taskReceiverPo -> {
            taskReceiverPo.setRelId(null);
            taskReceiverPo.setTaskId(taskId);
            taskReceiverPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        });
        int quantity = this.geminiTaskReceiverMapper.insertBatch(taskReceiverPoList);
        if (quantity < 1) {
            throw new GeminiBusinessException("6001", "\u4efb\u52a1\u63a5\u6536\u5bf9\u8c61\u8868\u65b0\u589e\u5f02\u5e38");
        }
    }

    public void insertRelTemplate(Long taskId, Long templateId, String thirdTemplateCode, String sendTypeListStr) {
        int quantity;
        log.info("------- \u5f00\u59cb\u8bb0\u5f55\u7b2c\u4e09\u65b9\u6a21\u677f\u4fe1\u606f\u8868 -------");
        GeminiRelTemplatePO relTemplatePo = new GeminiRelTemplatePO();
        relTemplatePo.setTemplateId(templateId);
        this.geminiRelTemplateMapper.deleteBy(relTemplatePo);
        relTemplatePo.setRelId(Sequence.getInstance().nextId());
        relTemplatePo.setTaskId(taskId);
        relTemplatePo.setThirdTemplateCode(thirdTemplateCode);
        relTemplatePo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        for (String sendType : JSON.parseArray((String)sendTypeListStr, String.class)) {
            if (!GeminiEnums.MessageAble.ALIBABA_MESSAGE.getAbleId().equals(Long.valueOf(sendType)) && !GeminiEnums.MessageAble.TENCENT_MESSAGE.getAbleId().equals(Long.valueOf(sendType))) continue;
            relTemplatePo.setSendType(sendType);
            break;
        }
        if ((quantity = this.geminiRelTemplateMapper.insert(relTemplatePo)) < 1) {
            throw new GeminiBusinessException("6001", "\u7b2c\u4e09\u65b9\u6a21\u677f\u5173\u7cfb\u65b0\u589e\u5931\u8d25\u3002");
        }
    }

    public void insertTaskCode(GeminiTaskPO taskInsertPo) {
        log.info("------- \u5f00\u59cb\u8bb0\u5f55\u4efb\u52a1code -------");
        GeminiTypePO typeReqPo = new GeminiTypePO();
        typeReqPo.setTypeId(taskInsertPo.getTypeId());
        GeminiTypePO typeRspPo = this.geminiTypeMapper.getModelBy(typeReqPo);
        if (!StringUtils.isEmpty((Object)typeRspPo)) {
            taskInsertPo.setTaskCode(typeRspPo.getTypeCode());
        }
    }
}

