/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.tydic.gemini.busi.api.GeminiDealTemplateBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTemplateAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateAddBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateEditBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateEditBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateEditStatusBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateEditStatusBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiTemplateMapper;
import com.tydic.gemini.dao.RelTemplateVariableMapper;
import com.tydic.gemini.dao.po.GeminiTemplatePO;
import com.tydic.gemini.dao.po.RelTemplateVariablePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="geminiDealTemplateBusiService")
public class GeminiDealTemplateBusiServiceImpl
implements GeminiDealTemplateBusiService {
    private GeminiTemplateMapper geminiTemplateMapper;
    private RelTemplateVariableMapper relTemplateVariableMapper;

    public GeminiDealTemplateBusiServiceImpl(GeminiTemplateMapper geminiTemplateMapper, RelTemplateVariableMapper relTemplateVariableMapper) {
        this.geminiTemplateMapper = geminiTemplateMapper;
        this.relTemplateVariableMapper = relTemplateVariableMapper;
    }

    @Override
    public GeminiTemplateAddBusiRspBO addTemplateInfo(GeminiTemplateAddBusiReqBO busiReqBO) {
        GeminiTemplateAddBusiRspBO busiRspBO = new GeminiTemplateAddBusiRspBO();
        Date nowTime = this.geminiTemplateMapper.getBaseDate();
        String createName = "";
        if (!StringUtils.isEmpty((Object)busiReqBO.getUserName())) {
            createName = busiReqBO.getUserName();
        }
        GeminiTemplatePO geminiTemplatePo = new GeminiTemplatePO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)geminiTemplatePo);
        geminiTemplatePo.setCreateTime(nowTime);
        geminiTemplatePo.setUpdateTime(nowTime);
        geminiTemplatePo.setCreateOperName(createName);
        geminiTemplatePo.setUpdateOperName(createName);
        int quantity = this.geminiTemplateMapper.insert(geminiTemplatePo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6002", "\u901a\u77e5\u6a21\u677f\u8868\u65b0\u589e\u5931\u8d25");
        }
        Long templateId = geminiTemplatePo.getTemplateId();
        if (!CollectionUtils.isEmpty(busiReqBO.getVariableIdList())) {
            this.addRelTemplateVariable(busiReqBO.getVariableIdList(), templateId, nowTime, createName);
        }
        busiRspBO.setTemplateId(templateId);
        return busiRspBO;
    }

    @Override
    public GeminiTemplateEditStatusBusiRspBO editTemplateStatus(GeminiTemplateEditStatusBusiReqBO busiReqBO) {
        GeminiTemplateEditStatusBusiRspBO busiRspBO = new GeminiTemplateEditStatusBusiRspBO();
        GeminiTemplatePO templatePo = new GeminiTemplatePO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)templatePo);
        if (!StringUtils.isEmpty((Object)busiReqBO.getUserName())) {
            templatePo.setUpdateOperName(busiReqBO.getUserName());
        }
        Date nowTime = this.geminiTemplateMapper.getBaseDate();
        templatePo.setUpdateTime(nowTime);
        int quantity = this.geminiTemplateMapper.updateById(templatePo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6010", "\u901a\u77e5\u6a21\u677f\u72b6\u6001\u4fee\u6539\u5931\u8d25");
        }
        return busiRspBO;
    }

    @Override
    public GeminiTemplateEditBusiRspBO editTemplateInfo(GeminiTemplateEditBusiReqBO busiReqBO) {
        GeminiTemplateEditBusiRspBO busiRspBO = new GeminiTemplateEditBusiRspBO();
        Date nowTime = this.geminiTemplateMapper.getBaseDate();
        String updateName = "\u65e0\u8bb0\u5f55";
        if (!StringUtils.isEmpty((Object)busiReqBO.getUserName())) {
            updateName = busiReqBO.getUserName();
        }
        GeminiTemplatePO geminiTemplatePo = new GeminiTemplatePO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)geminiTemplatePo);
        geminiTemplatePo.setUpdateTime(nowTime);
        geminiTemplatePo.setUpdateOperName(updateName);
        int quantity = this.geminiTemplateMapper.updateById(geminiTemplatePo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6010", "\u901a\u77e5\u6a21\u677f\u8868\u4fee\u6539\u5931\u8d25");
        }
        Long templateId = busiReqBO.getTemplateId();
        RelTemplateVariablePO originalRelationReqPo = new RelTemplateVariablePO();
        originalRelationReqPo.setTemplateId(templateId);
        originalRelationReqPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        List<Long> originalVariableIdList = this.relTemplateVariableMapper.getVariableIdList(originalRelationReqPo);
        if (!CollectionUtils.isEmpty(originalVariableIdList)) {
            if (CollectionUtils.isEmpty(busiReqBO.getVariableIdList()) && (quantity = this.relTemplateVariableMapper.updateInvalid(originalRelationReqPo)) < 1) {
                throw new GeminiBusinessException("6010", "\u901a\u77e5\u6a21\u677f\u5173\u7cfb\u8868\u4fee\u6539\u5931\u8d25");
            }
            if (!CollectionUtils.isEmpty(busiReqBO.getVariableIdList())) {
                ArrayList<Long> nowVariableIdList = new ArrayList<Long>(busiReqBO.getVariableIdList());
                if (originalVariableIdList.size() == nowVariableIdList.size()) {
                    nowVariableIdList.removeAll(originalVariableIdList);
                    if (!CollectionUtils.isEmpty(nowVariableIdList)) {
                        quantity = this.relTemplateVariableMapper.updateInvalid(originalRelationReqPo);
                        if (quantity < 1) {
                            throw new GeminiBusinessException("6010", "\u901a\u77e5\u6a21\u677f\u5173\u7cfb\u8868\u4fee\u6539\u5931\u8d25");
                        }
                        this.addRelTemplateVariable(busiReqBO.getVariableIdList(), templateId, nowTime, updateName);
                    }
                } else {
                    quantity = this.relTemplateVariableMapper.updateInvalid(originalRelationReqPo);
                    if (quantity < 1) {
                        throw new GeminiBusinessException("6010", "\u901a\u77e5\u6a21\u677f\u5173\u7cfb\u8868\u4fee\u6539\u5931\u8d25");
                    }
                    this.addRelTemplateVariable(busiReqBO.getVariableIdList(), templateId, nowTime, updateName);
                }
            }
        }
        if (CollectionUtils.isEmpty(originalVariableIdList) && !CollectionUtils.isEmpty(busiReqBO.getVariableIdList())) {
            this.addRelTemplateVariable(busiReqBO.getVariableIdList(), templateId, nowTime, updateName);
        }
        return busiRspBO;
    }

    public void addRelTemplateVariable(List<Long> variableIdList, Long templateId, Date nowTime, String createName) {
        ArrayList<RelTemplateVariablePO> relTemplateVariablePoList = new ArrayList<RelTemplateVariablePO>();
        for (Long variableId : variableIdList) {
            RelTemplateVariablePO relTemplateVariablePo = new RelTemplateVariablePO();
            relTemplateVariablePo.setTemplateId(templateId);
            relTemplateVariablePo.setVariableId(variableId);
            relTemplateVariablePo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
            relTemplateVariablePo.setCreateTime(nowTime);
            relTemplateVariablePo.setUpdateTime(nowTime);
            relTemplateVariablePo.setCreateOperName(createName);
            relTemplateVariablePo.setUpdateOperName(createName);
            relTemplateVariablePoList.add(relTemplateVariablePo);
        }
        this.relTemplateVariableMapper.insertBatch(relTemplateVariablePoList);
    }
}

