/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.tydic.gemini.busi.api.GeminiDealVariableBusiService;
import com.tydic.gemini.busi.api.bo.GeminiVariableAddBusiRepBO;
import com.tydic.gemini.busi.api.bo.GeminiVariableAddBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiVariableDeleteBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiVariableDeleteBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiVariableEditBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiVariableEditBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiTaskConditionMapper;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.GeminiVariableMapper;
import com.tydic.gemini.dao.RelTemplateVariableMapper;
import com.tydic.gemini.dao.po.GeminiVariablePO;
import com.tydic.gemini.dao.po.RelTemplateVariablePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="geminiDealVariableBusiService")
public class GeminiDealVariableBusiServiceImpl
implements GeminiDealVariableBusiService {
    private static final Logger log = LoggerFactory.getLogger(GeminiDealVariableBusiServiceImpl.class);
    private final GeminiVariableMapper geminiVariableMapper;
    private final RelTemplateVariableMapper relTemplateVariableMapper;
    private GeminiTaskConditionMapper geminiTaskConditionMapper;
    private final GeminiTaskMapper geminiTaskMapper;

    public GeminiDealVariableBusiServiceImpl(GeminiVariableMapper geminiVariableMapper, RelTemplateVariableMapper relTemplateVariableMapper, GeminiTaskConditionMapper geminiTaskConditionMapper, GeminiTaskMapper geminiTaskMapper) {
        this.geminiVariableMapper = geminiVariableMapper;
        this.relTemplateVariableMapper = relTemplateVariableMapper;
        this.geminiTaskConditionMapper = geminiTaskConditionMapper;
        this.geminiTaskMapper = geminiTaskMapper;
    }

    @Override
    public GeminiVariableAddBusiRspBO addVariable(GeminiVariableAddBusiRepBO repBO) {
        int quantity;
        GeminiVariableAddBusiRspBO rspBO = new GeminiVariableAddBusiRspBO();
        String checkAddResult = this.checkAdd(repBO);
        if (!StringUtils.isEmpty((Object)checkAddResult)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(checkAddResult);
            return rspBO;
        }
        GeminiVariablePO checkPo = new GeminiVariablePO();
        BeanUtils.copyProperties((Object)((Object)repBO), (Object)checkPo);
        String checkParamsValueResult = this.checkParamsValue(checkPo);
        if (!StringUtils.isEmpty((Object)checkParamsValueResult)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(checkParamsValueResult);
            return rspBO;
        }
        GeminiVariablePO variablePo = new GeminiVariablePO();
        BeanUtils.copyProperties((Object)((Object)repBO), (Object)variablePo);
        Date nowTime = this.geminiVariableMapper.getDbDate();
        variablePo.setCreateTime(nowTime);
        variablePo.setUpdateTime(nowTime);
        if (!StringUtils.isEmpty((Object)repBO.getUserName())) {
            variablePo.setCreateOperName(repBO.getUserName());
            variablePo.setUpdateOperName(repBO.getUserName());
        }
        if ((quantity = this.geminiVariableMapper.insert(variablePo)) < 1) {
            throw new GeminiBusinessException("6012", "\u53d8\u91cf\u65b0\u589e\u5f02\u5e38");
        }
        return rspBO;
    }

    @Override
    public GeminiVariableDeleteBusiRspBO deleteVariable(GeminiVariableDeleteBusiReqBO reqBO) {
        GeminiVariableDeleteBusiRspBO rspBO = new GeminiVariableDeleteBusiRspBO();
        String checkDeleteResult = this.checkEdit(reqBO.getVariableId());
        if (!StringUtils.isEmpty((Object)checkDeleteResult)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(checkDeleteResult);
            return rspBO;
        }
        GeminiVariablePO variablePo = new GeminiVariablePO();
        variablePo.setVariableId(reqBO.getVariableId());
        variablePo.setStatus(GeminiConstants.StatusConstants.VARIABLE_DELETE_STATUS);
        int quantity = this.geminiVariableMapper.updateById(variablePo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6014", "\u53d8\u91cf\u5220\u9664\u5931\u8d25");
        }
        return rspBO;
    }

    @Override
    public GeminiVariableEditBusiRspBO edit(GeminiVariableEditBusiReqBO reqBO) {
        int quantity;
        GeminiVariableEditBusiRspBO rspBO = new GeminiVariableEditBusiRspBO();
        GeminiVariablePO checkPo = new GeminiVariablePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)checkPo);
        String checkParamsValue = this.checkParamsValue(checkPo);
        if (!StringUtils.isEmpty((Object)checkParamsValue)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(checkParamsValue);
            return rspBO;
        }
        String checkDeleteResult = this.checkEdit(reqBO.getVariableId());
        if (!StringUtils.isEmpty((Object)checkDeleteResult)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(checkDeleteResult);
            return rspBO;
        }
        GeminiVariablePO where = new GeminiVariablePO();
        where.setVariableId(reqBO.getVariableId());
        GeminiVariablePO set = new GeminiVariablePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)set);
        set.setUpdateTime(this.geminiVariableMapper.getDbDate());
        if (!StringUtils.isEmpty((Object)reqBO.getUserName())) {
            set.setUpdateOperName(reqBO.getUserName());
        }
        if ((quantity = this.geminiVariableMapper.updateBy(set, where)) < 1) {
            throw new GeminiBusinessException("6016", "\u66f4\u65b0\u5931\u8d25");
        }
        return rspBO;
    }

    private String checkAdd(GeminiVariableAddBusiRepBO repBO) {
        GeminiVariablePO variablePo = new GeminiVariablePO();
        variablePo.setModuleCode(repBO.getModuleCode());
        variablePo.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
        variablePo.setVariableCode(repBO.getVariableCode());
        int quantity = this.geminiVariableMapper.getCheckBy(variablePo);
        if (quantity > 0) {
            return "\u3010" + repBO.getModuleName() + "\u3011\u6a21\u5757\u4e0b\u53d8\u91cf\u7f16\u7801\u3010" + repBO.getVariableCode() + "\u3011\u5df2\u5b58\u5728";
        }
        variablePo.setVariableCode(null);
        variablePo.setVariableName(repBO.getVariableName());
        quantity = this.geminiVariableMapper.getCheckBy(variablePo);
        if (quantity > 0) {
            return "\u3010" + repBO.getModuleName() + "\u3011\u6a21\u5757\u4e0b\u53d8\u91cf\u540d\u79f0\u3010" + repBO.getVariableName() + "\u3011\u5df2\u5b58\u5728";
        }
        return null;
    }

    private String checkParamsValue(GeminiVariablePO repBO) {
        String codeMatches = "[0-9A-Za-z_]{1,150}";
        String nameMatches = "^.{1,30}$";
        String remarkMatches = "^.{1,150}$";
        if (!StringUtils.isEmpty((Object)repBO.getVariableCode()) && !repBO.getVariableCode().matches("[0-9A-Za-z_]{1,150}")) {
            return "\u53d8\u91cf\u7f16\u7801\u8bf7\u8f93\u51651~150\u4e2a\u6570\u5b57\u3001\u5b57\u6bcd\u6216 _ \u7684\u7ec4\u5408";
        }
        if (!StringUtils.isEmpty((Object)repBO.getVariableName()) && !repBO.getVariableName().matches("^.{1,30}$")) {
            return "\u53d8\u91cf\u540d\u79f0\u8bf7\u8f93\u51651~30\u4e2a\u5b57\u7b26";
        }
        if (!StringUtils.isEmpty((Object)repBO.getRemark()) && !repBO.getRemark().matches("^.{1,150}$")) {
            return "\u5907\u6ce8\u8bf7\u8f93\u51651~150\u4e2a\u5b57\u7b26";
        }
        return null;
    }

    private String checkEdit(Long variableId) {
        GeminiVariablePO variablePo = new GeminiVariablePO();
        variablePo.setVariableId(variableId);
        int quantity = this.geminiVariableMapper.getCheckBy(variablePo);
        if (quantity < 1) {
            return "\u5f53\u524d\u53d8\u91cf\u4e0d\u5b58\u5728";
        }
        RelTemplateVariablePO relTemplateVariableReqPo = new RelTemplateVariablePO();
        relTemplateVariableReqPo.setVariableId(variableId);
        relTemplateVariableReqPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        List<RelTemplateVariablePO> relTemplateVariablePoList = this.relTemplateVariableMapper.getList(relTemplateVariableReqPo);
        ArrayList<Long> templateIdList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(relTemplateVariablePoList)) {
            for (RelTemplateVariablePO relTemplateVariablePo : relTemplateVariablePoList) {
                templateIdList.add(relTemplateVariablePo.getTemplateId());
            }
            quantity = this.geminiTaskMapper.getCheckByTemplateIdList(templateIdList);
            if (quantity > 1) {
                return "\u5f53\u524d\u53d8\u91cf\u6240\u5c5e\u6a21\u677f\u88ab\u6709\u6548\u4efb\u52a1\u5360\u7528\uff0c\u65e0\u6cd5\u64cd\u4f5c";
            }
        }
        return null;
    }
}

