/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.tydic.gemini.busi.api.GeminiDictionaryBusiService;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiRspBO;
import com.tydic.gemini.constants.GeminiDicValue;
import com.tydic.gemini.dao.SysDicDictionaryMapper;
import com.tydic.gemini.dao.po.SysDicDictionaryPO;
import com.tydic.gemini.exception.GeminiBusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="geminiDictionaryBusiService")
public class GeminiDictionaryBusiServiceImpl
implements GeminiDictionaryBusiService {
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    public GeminiDictionaryBusiServiceImpl(SysDicDictionaryMapper sysDicDictionaryMapper) {
        this.sysDicDictionaryMapper = sysDicDictionaryMapper;
    }

    @Override
    public GeminiDictionaryBusiRspBO getDicMap(GeminiDictionaryBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getPCodes())) {
            throw new GeminiBusinessException("1002", "\u83b7\u53d6\u5b57\u5178pCodes\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GeminiDictionaryBusiRspBO retBO = new GeminiDictionaryBusiRspBO();
        HashMap<String, Map<String, String>> dicMaps = new HashMap<String, Map<String, String>>(16);
        retBO.setDicMaps(dicMaps);
        SysDicDictionaryPO queryPO = new SysDicDictionaryPO();
        for (String pCode : reqBO.getPCodes()) {
            queryPO.setPCode(pCode);
            queryPO.setDelFlag(GeminiDicValue.DICTIONARY_DELETE_FLAG_VALID);
            List<SysDicDictionaryPO> dicPOs = this.sysDicDictionaryMapper.getList(queryPO);
            if (CollectionUtils.isEmpty(dicPOs)) continue;
            Map<String, String> dicMap = dicPOs.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getTitle));
            dicMaps.put(pCode, dicMap);
        }
        return retBO;
    }
}

