/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.gemini.able.MessageAble;
import com.tydic.gemini.able.MessageAbleManager;
import com.tydic.gemini.able.bo.MessageReceiverBO;
import com.tydic.gemini.able.bo.MessageSendReqBO;
import com.tydic.gemini.able.bo.MessageSendRspBO;
import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiRecordMapper;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.GeminiTaskReceiverMapper;
import com.tydic.gemini.dao.po.GeminiRecordPO;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.enums.GeminiEnums;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class GeminiTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(GeminiTaskExecutor.class);
    private GeminiRecordMapper geminiRecordMapper;
    private GeminiTaskReceiverMapper geminiTaskReceiverMapper;
    private MessageAbleManager messageAbleManager;
    private GeminiTaskMapper geminiTaskMapper;

    public GeminiTaskExecutor(GeminiRecordMapper geminiRecordMapper, MessageAbleManager messageAbleManager, GeminiTaskReceiverMapper geminiTaskReceiverMapper, GeminiTaskMapper geminiTaskMapper) {
        this.geminiRecordMapper = geminiRecordMapper;
        this.messageAbleManager = messageAbleManager;
        this.geminiTaskReceiverMapper = geminiTaskReceiverMapper;
        this.geminiTaskMapper = geminiTaskMapper;
    }

    @Async(value="geminiAsyncExecutor")
    public void execute(TaskBO taskBo) {
        log.info("\u5f00\u59cb\u6267\u884c\u6d88\u606f\u53d1\u9001\u4efb\u52a1");
        this.updateTaskStatusToPushing(taskBo);
        MessageSendReqBO ableReqBo = new MessageSendReqBO();
        BeanUtils.copyProperties((Object)((Object)taskBo), (Object)ableReqBo);
        List receivers = JSON.parseArray((String)JSON.toJSONString(taskBo.getReceivers()), MessageReceiverBO.class);
        ableReqBo.setReceivers(receivers);
        StringBuilder failMessage = new StringBuilder();
        log.info("#\u53d1\u9001\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)JSON.toJSONString(taskBo.getSendType()));
        for (String item : taskBo.getSendType()) {
            MessageSendRspBO ableRetBo;
            try {
                MessageAble messageAble = this.messageAbleManager.getAbleByAbleId(Long.valueOf(item));
                ableRetBo = messageAble.sendMessage(ableReqBo);
            }
            catch (Exception e) {
                failMessage.append("\u6d88\u606f\u80fd\u529b\u3010" + GeminiEnums.MessageAble.getMessageAble((Long)Long.valueOf(item)).getAbleName() + "\u3011\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage() + ";");
                continue;
            }
            if ("0000".equals(ableRetBo.getRespCode())) continue;
            failMessage.append("\u6d88\u606f\u80fd\u529b\u3010" + GeminiEnums.MessageAble.getMessageAble((Long)Long.valueOf(item)).getAbleName() + "\u3011\u53d1\u9001\u5931\u8d25\uff1a" + ableRetBo.getRespDesc() + ";");
        }
        if (StringUtils.isEmpty((Object)failMessage.toString())) {
            this.updateTaskInfo(taskBo);
            return;
        }
        this.writeRecordInfo(taskBo, GeminiConstants.RecordStatus.FAIL, failMessage.toString());
    }

    private void updateTaskStatusToPushing(TaskBO taskBo) {
        if (GeminiConstants.JudgmentWayConstants.MANUAL_EXECUTION.equals(taskBo.getExecuteWay()) && GeminiConstants.JudgmentWayConstants.IS_SINGLE.equals(taskBo.getIsSingle())) {
            GeminiTaskPO taskPo = new GeminiTaskPO();
            taskPo.setTaskId(taskBo.getTaskId());
            taskPo.setStatus(GeminiConstants.StatusConstants.TASK_PUSH_STATUS);
            int result = this.geminiTaskMapper.updateById(taskPo);
            if (result < 1) {
                log.error("\u66f4\u65b0\u624b\u52a8\u89e6\u53d1\u3001\u5355\u6b21\u6267\u884c\u7c7b\u578b\u4efb\u52a1\u72b6\u6001\u4e3a\u63a8\u9001\u4e2d\u5931\u8d25");
            }
        }
    }

    private void updateTaskInfo(TaskBO taskBo) {
        String desc = "\u6210\u529f";
        if (GeminiConstants.JudgmentWayConstants.MANUAL_EXECUTION.equals(taskBo.getExecuteWay()) && GeminiConstants.JudgmentWayConstants.IS_SINGLE.equals(taskBo.getIsSingle())) {
            GeminiTaskPO taskPo = new GeminiTaskPO();
            taskPo.setTaskId(taskBo.getTaskId());
            taskPo.setStatus(GeminiConstants.StatusConstants.TASK_COMPLETE_STATUS);
            int result = this.geminiTaskMapper.updateById(taskPo);
            if (result < 1) {
                desc = "\u6d88\u606f\u53d1\u9001\u5b8c\u6210\uff0c\u66f4\u65b0\u624b\u52a8\u89e6\u53d1\u3001\u5355\u6b21\u6267\u884c\u7c7b\u578b\u4efb\u52a1\u72b6\u6001\u5931\u8d25";
            }
        }
        this.writeRecordInfo(taskBo, GeminiConstants.RecordStatus.SUCCESS, desc);
    }

    private void writeRecordInfo(TaskBO taskBo, Integer sendStatus, String sendStatusDesc) {
        GeminiRecordPO geminiRecordPo = new GeminiRecordPO();
        geminiRecordPo.setRecordId(taskBo.getRecordId());
        geminiRecordPo.setResultDesc(sendStatusDesc);
        geminiRecordPo.setSendStatus(sendStatus);
        this.geminiRecordMapper.updateStatus(geminiRecordPo);
    }
}

