/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.base.GeminiRspBaseBO;
import com.tydic.gemini.filter.bo.GeminiFilterRspBO;
import com.tydic.gemini.filter.impl.IntervalSmsFilter;
import com.tydic.gemini.filter.impl.ModuleMessageFilter;
import com.tydic.gemini.filter.impl.TaskConditionFilter;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class GeminiTaskFilter {
    private static final Logger log = LoggerFactory.getLogger(GeminiTaskFilter.class);
    @Value(value="${platform.enable.cache.key:PES_DIC_platform_enable_setting}")
    private String dictionaryKeyPrefix;
    private CacheClient cacheClient;
    private ModuleMessageFilter moduleFilters;
    private IntervalSmsFilter intervalFilter;

    public GeminiTaskFilter(CacheClient cacheClient, IntervalSmsFilter intervalFilter) {
        this.cacheClient = cacheClient;
        this.intervalFilter = intervalFilter;
    }

    @PostConstruct
    public void init() {
        this.moduleFilters = new ModuleMessageFilter(this.cacheClient, this.dictionaryKeyPrefix);
    }

    public GeminiRspBaseBO doFilter(TaskBO taskBo) {
        TaskConditionFilter conditionFilter;
        log.info("\u4efb\u52a1\u8fc7\u6ee4\u5668\u89e6\u53d1\uff1aTASK=[{}]", (Object)JSON.toJSONString((Object)((Object)taskBo)));
        GeminiRspBaseBO retBo = new GeminiRspBaseBO();
        retBo.setRespCode("8888");
        if (!this.moduleFilters.doFilter(taskBo).getPass().booleanValue()) {
            log.info("\u6839\u636e\u6a21\u5757\u542f\u7528\u72b6\u6001\u8fc7\u6ee4\u5931\u8d25");
            retBo.setRespDesc("\u6a21\u5757\u672a\u542f\u7528");
            return retBo;
        }
        GeminiFilterRspBO filterRspBo = this.intervalFilter.doFilter(taskBo);
        if (!filterRspBo.getPass().booleanValue()) {
            log.info("\u65f6\u95f4\u95f4\u9694\u8fc7\u6ee4\u5931\u8d25\uff1a{}", (Object)filterRspBo.getDesc());
            retBo.setRespDesc(filterRspBo.getDesc());
            return retBo;
        }
        if (!CollectionUtils.isEmpty(taskBo.getTaskConditionList()) && !(filterRspBo = (conditionFilter = new TaskConditionFilter()).doFilter(taskBo)).getPass().booleanValue()) {
            log.info("\u4efb\u52a1\u81ea\u5b9a\u4e49\u6761\u4ef6\u8fc7\u6ee4\u5931\u8d25");
            retBo.setRespDesc(filterRspBo.getDesc());
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (!StringUtils.isEmpty((Object)filterRspBo.getDesc())) {
            retBo.setRespDesc(filterRspBo.getDesc());
        }
        log.debug("\u4efb\u52a1\u8fc7\u6ee4\u901a\u8fc7");
        return retBo;
    }
}

