/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.gemini.api.bo.GeminiReceiverBO;
import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.base.GeminiRspBaseBO;
import com.tydic.gemini.busi.api.GeminiRecordBusiService;
import com.tydic.gemini.busi.api.bo.GeminiRecordBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiRecordBusiRspBO;
import com.tydic.gemini.busi.impl.GeminiTaskExecutor;
import com.tydic.gemini.busi.impl.GeminiTaskFilter;
import com.tydic.gemini.comb.api.GeminiSendCombService;
import com.tydic.gemini.comb.api.bo.GeminiSendCombServiceReqBO;
import com.tydic.gemini.comb.api.bo.GeminiSendCombServiceRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiTaskConditionMapper;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.GeminiTemplateMapper;
import com.tydic.gemini.dao.GeminiVariableMapper;
import com.tydic.gemini.dao.po.GeminiTaskConditionPO;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.dao.po.GeminiTemplatePO;
import com.tydic.gemini.dao.po.GeminiVariablePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.utils.GeminiTranslationUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@EnableAsync
@Service(value="geminiSendCombService")
public class GeminiSendCombServiceImpl
implements GeminiSendCombService {
    private static final Logger log = LoggerFactory.getLogger(GeminiSendCombServiceImpl.class);
    private final GeminiTaskConditionMapper geminiTaskConditionMapper;
    private final GeminiTaskFilter geminiTaskFilter;
    private final GeminiTaskExecutor geminiTaskExecutor;
    private final GeminiRecordBusiService geminiRecordBusiService;
    private final GeminiTaskMapper geminiTaskMapper;
    private final GeminiTemplateMapper geminiTemplateMapper;
    private final GeminiVariableMapper geminiVariableMapper;

    public GeminiSendCombServiceImpl(GeminiTaskConditionMapper geminiTaskConditionMapper, GeminiTaskFilter geminiTaskFilter, GeminiTaskExecutor geminiTaskExecutor, GeminiTaskMapper geminiTaskMapper, GeminiRecordBusiService geminiRecordBusiService, GeminiTemplateMapper geminiTemplateMapper, GeminiVariableMapper geminiVariableMapper) {
        this.geminiTaskConditionMapper = geminiTaskConditionMapper;
        this.geminiTaskFilter = geminiTaskFilter;
        this.geminiTaskExecutor = geminiTaskExecutor;
        this.geminiRecordBusiService = geminiRecordBusiService;
        this.geminiTemplateMapper = geminiTemplateMapper;
        this.geminiVariableMapper = geminiVariableMapper;
        this.geminiTaskMapper = geminiTaskMapper;
    }

    @Override
    public GeminiSendCombServiceRspBO sendMessage(GeminiSendCombServiceReqBO reqBO) {
        GeminiSendCombServiceRspBO rspBO = new GeminiSendCombServiceRspBO();
        TaskBO taskBO = new TaskBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)taskBO));
        GeminiTaskConditionPO taskConditionReqPo = new GeminiTaskConditionPO();
        taskConditionReqPo.setTaskId(reqBO.getTaskId());
        taskConditionReqPo.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
        List<GeminiTaskConditionPO> taskConditionPoList = this.geminiTaskConditionMapper.getList(taskConditionReqPo);
        taskBO.setTaskConditionList(taskConditionPoList);
        GeminiRspBaseBO filterRetBo = this.geminiTaskFilter.doFilter(taskBO);
        if (!"0000".equals(filterRetBo.getRespCode())) {
            BeanUtils.copyProperties((Object)filterRetBo, (Object)((Object)rspBO));
            rspBO.setRespDesc("\u4efb\u52a1\u8fc7\u6ee4\u5931\u8d25\uff1a" + rspBO.getRespDesc());
            return rspBO;
        }
        BeanUtils.copyProperties((Object)filterRetBo, (Object)((Object)rspBO));
        this.generateMessageInfo(taskBO);
        GeminiRecordBusiRspBO recordBusiRspBo = this.addRecord(taskBO);
        if (!"0000".equals(recordBusiRspBo.getRespCode())) {
            log.info("\u65b0\u589e\u53d1\u9001\u8bb0\u5f55\u5931\u8d25");
            BeanUtils.copyProperties((Object)((Object)recordBusiRspBo), (Object)((Object)rspBO));
            rspBO.setRespDesc("\u65b0\u589e\u53d1\u9001\u8bb0\u5f55\u5931\u8d25");
            return rspBO;
        }
        this.geminiTaskExecutor.execute(taskBO);
        return rspBO;
    }

    private GeminiRecordBusiRspBO addRecord(TaskBO taskBO) {
        GeminiRecordBusiReqBO recordBusiReqBo = new GeminiRecordBusiReqBO();
        taskBO.setRecordId(Sequence.getInstance().nextId());
        BeanUtils.copyProperties((Object)((Object)taskBO), (Object)((Object)recordBusiReqBo));
        recordBusiReqBo.setSendStatus(GeminiConstants.RecordStatus.SENDING);
        recordBusiReqBo.setResultDesc("\u53d1\u9001\u4e2d");
        Map<String, String> receiverMap = taskBO.getReceivers().stream().collect(Collectors.toMap(GeminiReceiverBO::getReceiverId, GeminiReceiverBO::getReceiverName));
        ArrayList<String> mobileNumberList = new ArrayList<String>();
        ArrayList<String> eMailList = new ArrayList<String>();
        ArrayList<String> toUserList = new ArrayList<String>();
        for (GeminiReceiverBO receiverBO : taskBO.getReceivers()) {
            if (!StringUtils.isEmpty((Object)receiverBO.getMobileNumber())) {
                mobileNumberList.add(receiverBO.getMobileNumber());
            }
            if (!StringUtils.isEmpty((Object)receiverBO.getEMail())) {
                eMailList.add(receiverBO.getEMail());
            }
            if (StringUtils.isEmpty((Object)receiverBO.getOpenId())) continue;
            toUserList.add(receiverBO.getOpenId());
        }
        recordBusiReqBo.setMessageId(new MD5().digestHex(taskBO.getMessageContent(), StandardCharsets.UTF_8));
        recordBusiReqBo.setReceiver(receiverMap.keySet().toString());
        recordBusiReqBo.setReceiverName(receiverMap.values().toString());
        recordBusiReqBo.setMobileNumber(JSON.toJSONString(mobileNumberList));
        recordBusiReqBo.setEmail(JSON.toJSONString(eMailList));
        recordBusiReqBo.setTouser(JSON.toJSONString(toUserList));
        recordBusiReqBo.setSendTime(this.geminiTaskMapper.getBaseDate());
        GeminiRecordBusiRspBO recordBusiRspBo = this.geminiRecordBusiService.addRecord(recordBusiReqBo);
        return recordBusiRspBo;
    }

    private void generateMessageInfo(TaskBO taskBo) {
        GeminiTaskPO taskPo = new GeminiTaskPO();
        taskPo.setTaskId(taskBo.getTaskId());
        taskPo = this.geminiTaskMapper.getModelBy(taskPo);
        GeminiTemplatePO templatePo = new GeminiTemplatePO();
        templatePo.setTemplateId(taskPo.getTemplateId());
        templatePo = this.geminiTemplateMapper.getModelBy(templatePo);
        if (ObjectUtil.isEmpty((Object)templatePo) || !GeminiConstants.StatusConstants.ENABLE_STATUS.equals(templatePo.getStatus())) {
            log.info("\u672a\u83b7\u53d6\u5230\u4efb\u52a1\uff1a[{}]\u6709\u6548\u7684\u6a21\u677f", (Object)taskPo.getTaskId());
            throw new GeminiBusinessException("1005", "\u672a\u83b7\u53d6\u5230\u4efb\u52a1\uff1a[" + taskPo.getTaskId() + "]\u6709\u6548\u7684\u6a21\u677f");
        }
        List<GeminiVariablePO> variableList = this.geminiVariableMapper.getRelVariable(templatePo.getTemplateId());
        Map<String, String> variableMap = variableList.stream().collect(Collectors.toMap(item -> item.getVariableId().toString(), GeminiVariablePO::getVariableCode));
        String messageContent = GeminiTranslationUtil.valueReplacementId((String)templatePo.getMessageContent(), variableMap, taskBo.getValueMap());
        log.info("\u6839\u636e\u6a21\u677f\u548c\u5165\u53c2\u503c\u5f97\u5230\u7684\u6d88\u606f\u5185\u5bb9messageContent\uff1a{}", (Object)messageContent);
        String messageContentHtml = GeminiTranslationUtil.valueReplacementId((String)templatePo.getMessageContentHtml(), variableMap, taskBo.getValueMap());
        log.info("\u6839\u636e\u6a21\u677f\u548c\u5165\u53c2\u503c\u5f97\u5230\u7684\u6d88\u606f\u5185\u5bb9messageContentHtml\uff1a{}", (Object)messageContentHtml);
        String title = GeminiTranslationUtil.valueReplacementId((String)templatePo.getMessageTitle(), variableMap, taskBo.getValueMap());
        log.info("\u6839\u636e\u6a21\u677f\u548c\u5165\u53c2\u503c\u5f97\u5230\u7684\u6d88\u606f\u6807\u9898messageTitle\uff1a{}", (Object)title);
        taskBo.setMessageTitle(title);
        taskBo.setMessageContent(messageContent);
        taskBo.setMessageContentHtml(messageContentHtml);
        if (StringUtils.isEmpty((Object)taskBo.getTitle())) {
            taskBo.setTitle(title);
        }
    }
}

