/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.filter.impl;

import com.tydic.gemini.api.bo.GeminiReceiverBO;
import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiFrequencyConfigMapper;
import com.tydic.gemini.dao.GeminiRecordMapper;
import com.tydic.gemini.dao.po.GeminiFrequencyConfigPO;
import com.tydic.gemini.dao.po.GeminiRecordPO;
import com.tydic.gemini.enums.GeminiEnums;
import com.tydic.gemini.filter.MessageFilter;
import com.tydic.gemini.filter.bo.GeminiFilterRspBO;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class IntervalSmsFilter
implements MessageFilter {
    private static final Logger log = LoggerFactory.getLogger(IntervalSmsFilter.class);
    private GeminiRecordMapper geminiRecordMapper;
    private GeminiFrequencyConfigMapper geminiFrequencyConfigMapper;

    public IntervalSmsFilter(GeminiRecordMapper geminiRecordMapper, GeminiFrequencyConfigMapper geminiFrequencyConfigMapper) {
        this.geminiRecordMapper = geminiRecordMapper;
        this.geminiFrequencyConfigMapper = geminiFrequencyConfigMapper;
    }

    @Override
    public GeminiFilterRspBO doFilter(TaskBO taskBo) {
        GeminiFilterRspBO retBo = new GeminiFilterRspBO();
        retBo.setPass(true);
        List smsList = taskBo.getSendType().stream().filter(GeminiEnums.SmsEnum::contain).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(smsList)) {
            return retBo;
        }
        GeminiFrequencyConfigPO configPo = new GeminiFrequencyConfigPO();
        configPo.setSendType(Integer.valueOf(GeminiEnums.SmsEnum.SMS_CODE.getSmsCode()));
        configPo = this.geminiFrequencyConfigMapper.getModelBy(configPo);
        if (ObjectUtils.isEmpty((Object)configPo)) {
            return retBo;
        }
        DateTime nowTime = new DateTime((Object)this.geminiRecordMapper.getBaseDate());
        StringBuilder descBuilder = new StringBuilder();
        descBuilder.append("\u77ed\u4fe1\u53d1\u9001\u9891\u7387\u63a7\u5236\uff1a").append(configPo.getTimeInterval()).append("\u5206\u949f\u5185\uff0c\u53ea\u80fd\u53d1\u9001").append(configPo.getCount()).append("\u6761\u3002");
        descBuilder.append("\u4ee5\u4e0b\u624b\u673a\u53f7\u7801\u5df2\u88ab\u62e6\u622a\uff1a");
        GeminiRecordPO recordPo = new GeminiRecordPO();
        recordPo.setSendStatus(GeminiConstants.RecordStatus.SUCCESS);
        recordPo.setSendTime(nowTime.minus((long)configPo.getTimeInterval().intValue()).toDate());
        recordPo.setSendTypeList(GeminiEnums.SmsEnum.allSmsCode());
        boolean flag = false;
        for (GeminiReceiverBO item : taskBo.getReceivers()) {
            if (StringUtils.isEmpty((Object)item.getMobileNumber())) continue;
            recordPo.setMobileNumber(item.getMobileNumber());
            if (configPo.getCount() > this.geminiRecordMapper.getSmsCount(recordPo)) continue;
            flag = true;
            descBuilder.append(item.getMobileNumber()).append(",");
            item.setMobileNumber(null);
        }
        if (flag) {
            retBo.setDesc(descBuilder.substring(0, descBuilder.lastIndexOf(",")));
        }
        return retBo;
    }
}

