/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.filter.impl;

import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.dao.po.GeminiTaskConditionPO;
import com.tydic.gemini.filter.MessageFilter;
import com.tydic.gemini.filter.bo.GeminiFilterRspBO;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class TaskConditionFilter
implements MessageFilter {
    private static final Logger log = LoggerFactory.getLogger(TaskConditionFilter.class);

    @Override
    public GeminiFilterRspBO doFilter(TaskBO taskBo) {
        GeminiFilterRspBO retBo = new GeminiFilterRspBO();
        retBo.setPass(false);
        if (CollectionUtils.isEmpty(taskBo.getValueMap())) {
            return retBo;
        }
        Map<String, String> valueMap = taskBo.getValueMap();
        ScriptEngine engine = this.getScriptEngine(valueMap);
        try {
            for (GeminiTaskConditionPO taskConditionPo : taskBo.getTaskConditionList()) {
                if (StringUtils.isEmpty((Object)taskConditionPo.getConditionFormula()) || ((Boolean)engine.eval(taskConditionPo.getConditionFormula())).booleanValue()) continue;
                return retBo;
            }
        }
        catch (Exception e) {
            log.error("\u811a\u672c\u5f15\u64ce\u8ba1\u7b97\u6761\u4ef6\u8fc7\u6ee4\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            retBo.setDesc("\u811a\u672c\u5f15\u64ce\u8ba1\u7b97\u6761\u4ef6\u8fc7\u6ee4\u5f02\u5e38,\u8bf7\u68c0\u67e5\u6570\u636e\u96c6\u662f\u5426\u5305\u542b\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u7684\u5b57\u6bb5\u3002");
            return retBo;
        }
        retBo.setPass(true);
        return retBo;
    }

    private ScriptEngine getScriptEngine(Map<String, String> valueMap) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        for (Map.Entry<String, String> entry : valueMap.entrySet()) {
            engine.put(entry.getKey(), entry.getValue());
        }
        return engine;
    }
}

