/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    private static final String UNKNOWN = "unknown";
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final int LENGTH = 15;
    private static final String SEPARATOR = ",";

    public static String getIpAddress(HttpServletRequest request) {
        String ipAddress;
        try {
            ipAddress = request.getHeader("x-forwarded-for");
            ipAddress = IpUtils.getIpAddressFromPci(request, ipAddress);
            if (ipAddress == null || ipAddress.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((ipAddress == null || ipAddress.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddress)) && LOCAL_HOST.equals(ipAddress = request.getRemoteAddr())) {
                InetAddress inet = null;
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                ipAddress = inet.getHostAddress();
            }
            if (ipAddress != null && 15 < ipAddress.length() && ipAddress.indexOf(SEPARATOR) >= 1) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(SEPARATOR));
            }
        }
        catch (Exception e) {
            ipAddress = "";
        }
        return ipAddress;
    }

    public static String getIpAddressFromPci(HttpServletRequest request, String ipAddress) {
        if (ipAddress == null || ipAddress.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            return request.getHeader("Proxy-Client-IP");
        }
        return ipAddress;
    }
}

