/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.ohaotian.plugin.cache.CacheClient;
import com.taobao.api.TaobaoRequest;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.web.api.GeminiAccessTokenQryService;
import com.tydic.gemini.web.api.bo.GeminiAccessTokenQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiAccessTokenQryRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GeminiAccessTokenQryServiceImpl
implements GeminiAccessTokenQryService {
    private static final Logger log = LoggerFactory.getLogger(GeminiAccessTokenQryServiceImpl.class);
    @Value(value="${dingtalk.appkey:1}")
    private String appkey;
    @Value(value="${dingtalk.appsecret:1}")
    private String appsecret;
    private final CacheClient cacheClient;
    private static final String DINGTALK_TOKEN_STR = "https://oapi.dingtalk.com/gettoken";

    public GeminiAccessTokenQryServiceImpl(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public GeminiAccessTokenQryRspBO qryAccessToken(GeminiAccessTokenQryReqBO reqBO) {
        GeminiAccessTokenQryRspBO rspBO = new GeminiAccessTokenQryRspBO();
        DefaultDingTalkClient client = new DefaultDingTalkClient(DINGTALK_TOKEN_STR);
        OapiGettokenRequest request = new OapiGettokenRequest();
        if (!StringUtils.isEmpty((Object)reqBO.getAppkey()) && !StringUtils.isEmpty((Object)reqBO.getAppsecret())) {
            request.setAppkey(reqBO.getAppkey());
            request.setAppsecret(reqBO.getAppsecret());
        } else {
            request.setAppkey(this.appkey);
            request.setAppsecret(this.appsecret);
        }
        request.setHttpMethod("GET");
        OapiGettokenResponse response = new OapiGettokenResponse();
        try {
            response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
            log.info("\u8c03\u7528\u9489\u9489\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)response);
        }
        catch (Exception e) {
            throw new GeminiBusinessException("8002", e.toString());
        }
        if (!StringUtils.isEmpty((Object)response) && !StringUtils.isEmpty((Object)response.getAccessToken())) {
            log.info("\u5b58\u5165\u7f13\u5b58\u7684access_token\uff1a{}", (Object)response.getAccessToken());
            this.cacheClient.set("GEMINI_DINGTALK_ACCESS_TOKEN_CACHE_KEY", (Object)response.getAccessToken());
            BeanUtils.copyProperties((Object)response, (Object)rspBO);
        }
        return rspBO;
    }
}

