/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.gemini.busi.api.GeminiDictionaryBusiService;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiRspBO;
import com.tydic.gemini.web.api.GeminiDictionaryQryService;
import com.tydic.gemini.web.api.bo.GeminiDictionaryDataBO;
import com.tydic.gemini.web.api.bo.GeminiDictionaryQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiDictionaryQryRspBO;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GeminiDictionaryQryServiceImpl
implements GeminiDictionaryQryService {
    private static final Logger log = LoggerFactory.getLogger(GeminiDictionaryQryServiceImpl.class);
    private GeminiDictionaryBusiService geminiDictionaryBusiService;

    public GeminiDictionaryQryServiceImpl(GeminiDictionaryBusiService geminiDictionaryBusiService) {
        this.geminiDictionaryBusiService = geminiDictionaryBusiService;
    }

    public GeminiDictionaryQryRspBO getDic(GeminiDictionaryQryReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u5b57\u5178ability\u670d\u52a1\uff0c \u5f53\u524d\u65b9\u6cd5 getDic(), \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        String validateArg = ArgValidator.validateArg((Object)reqBO);
        GeminiDictionaryQryRspBO rspBO = new GeminiDictionaryQryRspBO();
        if (!StringUtils.isEmpty((Object)validateArg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(validateArg);
            return rspBO;
        }
        GeminiDictionaryBusiReqBO busiReqBO = new GeminiDictionaryBusiReqBO();
        ArrayList<String> reqList = new ArrayList<String>();
        reqList.add(reqBO.getPCode());
        busiReqBO.setPCodes(reqList);
        GeminiDictionaryBusiRspBO dicMap = this.geminiDictionaryBusiService.getDicMap(busiReqBO);
        Map<String, String> map = dicMap.getDicMaps().get(reqBO.getPCode());
        List<GeminiDictionaryDataBO> dataBOList = this.map2List(map);
        rspBO.setRows(dataBOList);
        return rspBO;
    }

    private List<GeminiDictionaryDataBO> map2List(Map<String, String> map) {
        ArrayList<GeminiDictionaryDataBO> rspList = new ArrayList<GeminiDictionaryDataBO>();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            GeminiDictionaryDataBO dataBO = new GeminiDictionaryDataBO();
            dataBO.setCode(entry.getKey());
            dataBO.setTitle(entry.getValue());
            rspList.add(dataBO);
        }
        return rspList;
    }
}

