/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.gemini.constants.GeminiDicValue;
import com.tydic.gemini.dao.GeminiInterceptConfigMapper;
import com.tydic.gemini.dao.po.GeminiInterceptConfigPO;
import com.tydic.gemini.web.api.GeminiInterceptQryService;
import com.tydic.gemini.web.api.bo.GeminiInterceptDataBO;
import com.tydic.gemini.web.api.bo.GeminiInterceptQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiInterceptQryRspBO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class GeminiInterceptQryServiceImpl
implements GeminiInterceptQryService {
    private GeminiInterceptConfigMapper geminiInterceptConfigMapper;
    private CacheClient cacheClient;

    public GeminiInterceptQryServiceImpl(GeminiInterceptConfigMapper geminiInterceptConfigMapper, CacheClient cacheClient) {
        this.geminiInterceptConfigMapper = geminiInterceptConfigMapper;
        this.cacheClient = cacheClient;
    }

    public GeminiInterceptQryRspBO qryIntercept(GeminiInterceptQryReqBO reqBO) {
        GeminiInterceptQryRspBO retBo = new GeminiInterceptQryRspBO();
        ArrayList<GeminiInterceptDataBO> interceptList = new ArrayList<GeminiInterceptDataBO>();
        retBo.setInterceptList(interceptList);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        GeminiInterceptConfigPO configPo = new GeminiInterceptConfigPO();
        configPo.setStatus(GeminiDicValue.GEMINI_TYPE_STATUS_ENABLE);
        List<GeminiInterceptConfigPO> configList = this.geminiInterceptConfigMapper.getList(configPo);
        for (GeminiInterceptConfigPO item : configList) {
            GeminiInterceptDataBO dataBo = new GeminiInterceptDataBO();
            BeanUtils.copyProperties((Object)item, (Object)dataBo);
            interceptList.add(dataBo);
        }
        if (!CollectionUtils.isEmpty(interceptList)) {
            this.cacheClient.set("GEMINI_INTERCEPT_CACHE_KEY", (Object)JSON.toJSONString(interceptList), 3600);
        }
        return retBo;
    }
}

