/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.web.api.GeminiModuleQryService;
import com.tydic.gemini.web.api.bo.GeminiModuleDataBO;
import com.tydic.gemini.web.api.bo.GeminiModuleQryRspBO;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GeminiModuleQryServiceImpl
implements GeminiModuleQryService {
    private static final Logger log = LoggerFactory.getLogger(GeminiModuleQryServiceImpl.class);
    private final CacheClient cacheClient;
    @Value(value="${platform.enable.cache.key:PES_DIC_platform_enable_setting}")
    private String dictionaryKeyPrefix;

    public GeminiModuleQryServiceImpl(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public GeminiModuleQryRspBO qryModuleByCache() {
        GeminiModuleQryRspBO rspBO = new GeminiModuleQryRspBO();
        ArrayList<GeminiModuleDataBO> moduleDataBOList = new ArrayList<GeminiModuleDataBO>();
        try {
            String moduleStr = (String)this.cacheClient.get(this.dictionaryKeyPrefix);
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u7684\u6570\u636e\uff1a{}", (Object)moduleStr);
            Map moduleMap = (Map)JSON.parseObject((String)moduleStr, HashedMap.class);
            int juedeOpen = GeminiConstants.StatusConstants.DISABLE_STATUS;
            if (StringUtils.isEmpty((Object)moduleStr)) {
                throw new GeminiBusinessException("5002", "\u7f13\u5b58\u5185\u5bb9\u4e3a\u7a7a\uff01");
            }
            for (Map.Entry entry : moduleMap.entrySet()) {
                GeminiModuleDataBO moduleDataBO = new GeminiModuleDataBO();
                moduleDataBO.setModuleCode((String)entry.getKey());
                moduleDataBO.setModuleName((String)entry.getValue());
                moduleDataBOList.add(moduleDataBO);
            }
            rspBO.setModuleDataBOList(moduleDataBOList);
        }
        catch (Exception e) {
            log.info("\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new GeminiBusinessException("5002", "\u83b7\u53d6\u7f13\u5b58\u5931\u8d25\uff01");
        }
        return rspBO;
    }
}

