/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.gemini.constants.GeminiDicValue;
import com.tydic.gemini.dao.GeminiSendTypeMapper;
import com.tydic.gemini.dao.po.GeminiSendTypePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.web.api.GeminiSendTypeQryService;
import com.tydic.gemini.web.api.bo.GeminiSendTypeDataBO;
import com.tydic.gemini.web.api.bo.GeminiSendTypeQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiSendTypeQryRspBO;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GeminiSendTypeQryServiceImpl
implements GeminiSendTypeQryService {
    private GeminiSendTypeMapper geminiSendTypeMapper;
    private CacheClient cacheClient;

    public GeminiSendTypeQryServiceImpl(GeminiSendTypeMapper geminiSendTypeMapper, CacheClient cacheClient) {
        this.geminiSendTypeMapper = geminiSendTypeMapper;
        this.cacheClient = cacheClient;
    }

    public GeminiSendTypeQryRspBO sendTypeListQry(GeminiSendTypeQryReqBO reqBO) {
        GeminiSendTypeQryRspBO rspBO = new GeminiSendTypeQryRspBO();
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiSendTypePO sendTypeReqPo = new GeminiSendTypePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)sendTypeReqPo);
        List<GeminiSendTypePO> sendTypePoList = this.geminiSendTypeMapper.getList(sendTypeReqPo);
        rspBO.setSendTypeDataBOList(JSON.parseArray((String)JSON.toJSONString(sendTypePoList), GeminiSendTypeDataBO.class));
        List sortSendTypeList = sendTypePoList.stream().filter(item -> StringUtils.isEmpty((Object)item.getGroupCode())).collect(Collectors.toList());
        sendTypePoList.removeAll(sortSendTypeList);
        sendTypePoList.addAll(sortSendTypeList);
        List sendTypeList = sendTypePoList.stream().map(item -> item.getTypeId().toString()).collect(Collectors.toList());
        if (GeminiDicValue.SIGN_BACK_END.equals(reqBO.getSign())) {
            this.cacheClient.set("GEMINI_SEND_TYPE_CACHE_KEY", (Object)JSON.toJSONString(sendTypeList), 3600);
        }
        rspBO.setSendTypeList(sendTypeList);
        return rspBO;
    }
}

