/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.gemini.atom.api.GeminiReceiverAtomService;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.bo.GeminiReceiverListQryAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiReceiverListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskDetailsAtomRspBO;
import com.tydic.gemini.busi.api.GeminiDealTaskBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTaskAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskAddBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiRelTemplateMapper;
import com.tydic.gemini.dao.po.GeminiRelTemplatePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.web.api.GeminiTaskAddService;
import com.tydic.gemini.web.api.bo.GeminiReceiverDataBO;
import com.tydic.gemini.web.api.bo.GeminiTaskAddReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskAddRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDuplicateReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDuplicateRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskReceiverDataBO;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GeminiTaskAddServiceImpl
implements GeminiTaskAddService {
    private GeminiDealTaskBusiService geminiDealTaskBusiService;
    private GeminiTaskAtomService geminiTaskAtomService;
    private GeminiReceiverAtomService geminiReceiverAtomService;
    private GeminiRelTemplateMapper geminiRelTemplateMapper;

    public GeminiTaskAddServiceImpl(GeminiDealTaskBusiService geminiDealTaskBusiService, GeminiTaskAtomService geminiTaskAtomService, GeminiReceiverAtomService geminiReceiverAtomService, GeminiRelTemplateMapper geminiRelTemplateMapper) {
        this.geminiDealTaskBusiService = geminiDealTaskBusiService;
        this.geminiTaskAtomService = geminiTaskAtomService;
        this.geminiReceiverAtomService = geminiReceiverAtomService;
        this.geminiRelTemplateMapper = geminiRelTemplateMapper;
    }

    public GeminiTaskAddRspBO addTask(GeminiTaskAddReqBO reqBO) {
        GeminiTaskAddRspBO rspBO = new GeminiTaskAddRspBO();
        String validateStr = this.validate(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTaskAddBusiReqBO busiReqBO = new GeminiTaskAddBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        GeminiTaskAddBusiRspBO busiRspBO = this.geminiDealTaskBusiService.addTaskInfo(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new GeminiBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        return rspBO;
    }

    public GeminiTaskDuplicateRspBO duplicateTask(GeminiTaskDuplicateReqBO reqBO) {
        GeminiTaskDuplicateRspBO rspBO = new GeminiTaskDuplicateRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new GeminiBusinessException("1002", "\u590d\u5236\u4efb\u52a1\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskDuplicateReqBO]\u5c5e\u6027[taskId:\u4efb\u52a1id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setTaskId(reqBO.getTaskId());
        GeminiTaskDetailsAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomReqBO);
        if (!GeminiConstants.StatusConstants.TASK_COMPLETE_STATUS.equals(taskAtomRspBO.getStatus())) {
            throw new GeminiBusinessException("1006", "\u8be5\u4efb\u52a1\u72b6\u6001\u4e0b\u4e0d\u53ef\u6267\u884c\u590d\u5236\u64cd\u4f5c\uff01");
        }
        GeminiTaskAddReqBO geminiTaskAddReqBO = new GeminiTaskAddReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)geminiTaskAddReqBO);
        geminiTaskAddReqBO.setTaskName(reqBO.getTaskName() + Sequence.getInstance().nextId());
        geminiTaskAddReqBO.setStatus(GeminiConstants.StatusConstants.TASK_DRAFT_STATUS);
        GeminiReceiverListQryAtomReqBO receiverListQryAtomReqBO = new GeminiReceiverListQryAtomReqBO();
        GeminiReceiverDataBO receiverDataBO = new GeminiReceiverDataBO();
        receiverDataBO.setTaskId(reqBO.getTaskId());
        receiverDataBO.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        receiverListQryAtomReqBO.setReceiverData(receiverDataBO);
        GeminiReceiverListQryAtomRspBO receiverListQryAtomRspBO = this.geminiReceiverAtomService.qryReceiverList(receiverListQryAtomReqBO);
        List taskReceiverList = JSON.parseArray((String)JSON.toJSONString(receiverListQryAtomRspBO.getReceiverDetailsAtomRspBOList()), GeminiTaskReceiverDataBO.class);
        geminiTaskAddReqBO.setTaskReceiverList(taskReceiverList);
        this.qryRelTemplate(geminiTaskAddReqBO, reqBO.getTemplateId());
        this.addTask(geminiTaskAddReqBO);
        return rspBO;
    }

    public void qryRelTemplate(GeminiTaskAddReqBO geminiTaskAddReqBO, Long templateId) {
        GeminiRelTemplatePO relTemplateReqPo = new GeminiRelTemplatePO();
        relTemplateReqPo.setTemplateId(templateId);
        relTemplateReqPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        GeminiRelTemplatePO relTemplateRspPo = this.geminiRelTemplateMapper.getModelBy(relTemplateReqPo);
        if (!StringUtils.isEmpty((Object)relTemplateRspPo)) {
            geminiTaskAddReqBO.setThirdpartyTemplateId(relTemplateRspPo.getThirdTemplateCode());
        }
    }

    public String validate(GeminiTaskAddReqBO reqBO) {
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            return validateStr;
        }
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setModuleCode(reqBO.getModuleCode());
        taskAtomReqBO.setTaskName(reqBO.getTaskName());
        GeminiTaskDetailsAtomRspBO taskDetailsAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomReqBO);
        if ("0000".equals(taskDetailsAtomRspBO.getRespCode())) {
            return "\u8be5\u6a21\u5757\u4e0b\u5b58\u5728\u540c\u540d\u4efb\u52a1\uff0c\u8bf7\u66f4\u6362\u4efb\u52a1\u540d\u79f0";
        }
        if (CollectionUtils.isEmpty((Collection)JSON.parseArray((String)reqBO.getSendType(), String.class))) {
            return "\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[sendType:\u63a8\u9001\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getTemplateId())) {
            if (StringUtils.isEmpty((Object)reqBO.getMessageTitle())) {
                return "\u65b0\u5efa\u6d88\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[messageTitle:\u6a21\u677f-\u6d88\u606f\u6807\u9898]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)reqBO.getMessageContent())) {
                return "\u65b0\u5efa\u6d88\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[messageContent:\u6a21\u677f-\u6d88\u606f\u5185\u5bb9]\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (GeminiConstants.JudgmentWayConstants.MANUAL_EXECUTION.equals(reqBO.getExecuteWay()) && StringUtils.isEmpty((Object)reqBO.getIsSingle())) {
            return "\u624b\u52a8\u6267\u884c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[isSingle:\u662f\u5426\u5355\u6b21\u6267\u884c]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

