/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskDetailsAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskListQryAtomRspBO;
import com.tydic.gemini.busi.api.GeminiDealTaskBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditStatusBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditStatusBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.web.api.GeminiTaskEditService;
import com.tydic.gemini.web.api.bo.GeminiTaskEditReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskEditRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskEditStatusReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskEditStatusRspBO;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GeminiTaskEditServiceImpl
implements GeminiTaskEditService {
    private final GeminiDealTaskBusiService geminiDealTaskBusiService;
    private final GeminiTaskAtomService geminiTaskAtomService;

    public GeminiTaskEditServiceImpl(GeminiDealTaskBusiService geminiDealTaskBusiService, GeminiTaskAtomService geminiTaskAtomService) {
        this.geminiDealTaskBusiService = geminiDealTaskBusiService;
        this.geminiTaskAtomService = geminiTaskAtomService;
    }

    public GeminiTaskEditRspBO editTaskInfo(GeminiTaskEditReqBO reqBO) {
        GeminiTaskEditRspBO rspBO = new GeminiTaskEditRspBO();
        String validateStr = this.validate(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTaskEditBusiReqBO busiReqBO = new GeminiTaskEditBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        GeminiTaskEditBusiRspBO busiRspBO = this.geminiDealTaskBusiService.editTaskInfo(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new GeminiBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        return rspBO;
    }

    public GeminiTaskEditStatusRspBO editTaskStatus(GeminiTaskEditStatusReqBO reqBO) {
        GeminiTaskEditStatusRspBO rspBO = new GeminiTaskEditStatusRspBO();
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setTaskId(reqBO.getTaskId());
        GeminiTaskDetailsAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomReqBO);
        if (!"0000".equals(taskAtomRspBO.getRespCode())) {
            throw new GeminiBusinessException(taskAtomRspBO.getRespCode(), taskAtomRspBO.getRespDesc());
        }
        Integer nowStatus = taskAtomRspBO.getStatus();
        validateStr = this.validateStatus(reqBO, nowStatus, taskAtomRspBO.getTypeId());
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1006", validateStr);
        }
        GeminiTaskEditStatusBusiReqBO taskBusiReqBO = new GeminiTaskEditStatusBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)taskBusiReqBO));
        GeminiTaskEditStatusBusiRspBO taskBusiRspBO = this.geminiDealTaskBusiService.editTaskStatus(taskBusiReqBO);
        BeanUtils.copyProperties((Object)((Object)taskBusiRspBO), (Object)rspBO);
        return rspBO;
    }

    public String validate(GeminiTaskEditReqBO reqBO) {
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            return validateStr;
        }
        GeminiTaskAtomReqBO taskAtomTaskNameReqBO = new GeminiTaskAtomReqBO();
        taskAtomTaskNameReqBO.setModuleCode(reqBO.getModuleCode());
        taskAtomTaskNameReqBO.setTaskName(reqBO.getTaskName());
        GeminiTaskDetailsAtomRspBO taskAtomTaskNameRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomTaskNameReqBO);
        if ("0000".equals(taskAtomTaskNameRspBO.getRespCode()) && !taskAtomTaskNameRspBO.getTaskId().equals(reqBO.getTaskId())) {
            return "\u8be5\u6a21\u5757\u4e0b\u5b58\u5728\u540c\u540d\u4efb\u52a1\uff0c\u8bf7\u66f4\u6362\u4efb\u52a1\u540d\u79f0";
        }
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setTaskId(reqBO.getTaskId());
        GeminiTaskDetailsAtomRspBO taskDetailsAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomReqBO);
        if (!GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(taskDetailsAtomRspBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(taskDetailsAtomRspBO.getStatus())) {
            return "\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e0d\u53ef\u8fdb\u884c\u7f16\u8f91\u64cd\u4f5c\uff01";
        }
        if (CollectionUtils.isEmpty((Collection)JSON.parseArray((String)reqBO.getSendType(), String.class))) {
            return "\u5165\u53c2\u5bf9\u8c61[GeminiTaskEditReqBO]\u5c5e\u6027[sendType:\u63a8\u9001\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBO.getTemplateId())) {
            if (StringUtils.isEmpty((Object)reqBO.getMessageTitle())) {
                return "\u65b0\u5efa\u6d88\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[messageTitle:\u6a21\u677f-\u6d88\u606f\u6807\u9898]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)reqBO.getMessageContent())) {
                return "\u65b0\u5efa\u6d88\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[messageContent:\u6a21\u677f-\u6d88\u606f\u5185\u5bb9]\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (GeminiConstants.JudgmentWayConstants.MANUAL_EXECUTION.equals(reqBO.getExecuteWay()) && StringUtils.isEmpty((Object)reqBO.getIsSingle())) {
            return "\u624b\u52a8\u6267\u884c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[isSingle:\u662f\u5426\u5355\u6b21\u6267\u884c]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public String validateStatus(GeminiTaskEditStatusReqBO reqBO, Integer nowStatus, Long typeId) {
        if ("1".equals(reqBO.getCallWay()) && !GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(reqBO.getStatus())) {
            return "\u65e0\u6cd5\u8bc6\u522b\u5f53\u524d\u9700\u8981\u8f6c\u6362\u7684\u72b6\u6001\uff01";
        }
        if (GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(nowStatus)) {
            return "\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u6682\u505c\u64cd\u4f5c\uff01";
        }
        if (GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(reqBO.getStatus())) {
            if (!GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(nowStatus) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(nowStatus)) {
                return "\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u5f00\u542f\u64cd\u4f5c\uff01";
            }
            GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
            taskAtomReqBO.setTypeId(typeId);
            taskAtomReqBO.setStatus(GeminiConstants.StatusConstants.TASK_OPEN_STATUS);
            GeminiTaskListQryAtomRspBO taskListQryAtomRspBO = this.geminiTaskAtomService.qryTaskList(taskAtomReqBO);
            if (!CollectionUtils.isEmpty(taskListQryAtomRspBO.getTaskDataBOList())) {
                return "\u5f53\u524d\u4efb\u52a1\u6240\u7528\u5230\u7684\u4efb\u52a1\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\u4e00\u4e2a\u542f\u52a8\u4e2d\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u6267\u884c\u5f00\u542f\u64cd\u4f5c\uff01";
            }
        }
        if (GeminiConstants.StatusConstants.TASK_DELETE_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(nowStatus) && !GeminiConstants.StatusConstants.TASK_COMPLETE_STATUS.equals(nowStatus) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(nowStatus)) {
            return "\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u5220\u9664\u64cd\u4f5c\uff01";
        }
        return null;
    }
}

