/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.gemini.atom.api.GeminiConditionAtomService;
import com.tydic.gemini.atom.api.GeminiReceiverAtomService;
import com.tydic.gemini.atom.api.GeminiRelTemplateVariableAtomService;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.GeminiTemplateAtomService;
import com.tydic.gemini.atom.api.GeminiTypeDetailQryAtomService;
import com.tydic.gemini.atom.api.GeminiVariableAtomService;
import com.tydic.gemini.atom.api.bo.GeminiConditionDetailsAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiConditionDetailsAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiReceiverListQryAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiReceiverListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiRelTemplateVariableListAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiRelTemplateVariableListAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskDetailsAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskPageQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplateAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplateDetailsAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplateListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTypeDetailQryAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTypeDetailQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiVariableListQryReqBO;
import com.tydic.gemini.atom.api.bo.GeminiVariableListQryRspBO;
import com.tydic.gemini.base.GeminiRspPageBaseBO;
import com.tydic.gemini.busi.api.GeminiDictionaryBusiService;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiRecordMapper;
import com.tydic.gemini.dao.GeminiRelTemplateMapper;
import com.tydic.gemini.dao.GeminiSendTypeMapper;
import com.tydic.gemini.dao.SysDicDictionaryMapper;
import com.tydic.gemini.dao.po.GeminiRecordPO;
import com.tydic.gemini.dao.po.GeminiRelTemplatePO;
import com.tydic.gemini.dao.po.GeminiSendTypePO;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.dao.po.SysDicDictionaryPO;
import com.tydic.gemini.enums.GeminiEnums;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.utils.GeminiTranslationUtil;
import com.tydic.gemini.web.api.GeminiTaskQryService;
import com.tydic.gemini.web.api.bo.GeminiConditionDataBO;
import com.tydic.gemini.web.api.bo.GeminiReceiverDataBO;
import com.tydic.gemini.web.api.bo.GeminiRelTemplateVariableDataBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDataBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDetailsQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDetailsQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskPageQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskPageQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskReceiverDataBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateDataBO;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GeminiTaskQryServiceImpl
implements GeminiTaskQryService {
    private final GeminiTaskAtomService geminiTaskAtomService;
    private final GeminiConditionAtomService geminiConditionAtomService;
    private final GeminiTemplateAtomService geminiTemplateAtomService;
    private final GeminiRelTemplateVariableAtomService geminiRelTemplateVariableAtomService;
    private final GeminiVariableAtomService geminiVariableAtomService;
    private final GeminiRecordMapper geminiRecordMapper;
    private final GeminiTypeDetailQryAtomService geminiTypeDetailQryAtomService;
    private final GeminiRelTemplateMapper geminiRelTemplateMapper;
    private final GeminiReceiverAtomService geminiReceiverAtomService;
    private final GeminiSendTypeMapper geminiSendTypeMapper;
    private final GeminiDictionaryBusiService geminiDictionaryBusiService;
    private final SysDicDictionaryMapper sysDicDictionaryMapper;

    public GeminiTaskQryServiceImpl(GeminiTaskAtomService geminiTaskAtomService, GeminiConditionAtomService geminiConditionAtomService, GeminiTemplateAtomService geminiTemplateAtomService, GeminiRelTemplateVariableAtomService geminiRelTemplateVariableAtomService, GeminiVariableAtomService geminiVariableAtomService, GeminiRecordMapper geminiRecordMapper, GeminiTypeDetailQryAtomService geminiTypeDetailQryAtomService, GeminiRelTemplateMapper geminiRelTemplateMapper, GeminiReceiverAtomService geminiReceiverAtomService, GeminiSendTypeMapper geminiSendTypeMapper, GeminiDictionaryBusiService geminiDictionaryBusiService, SysDicDictionaryMapper sysDicDictionaryMapper) {
        this.geminiTaskAtomService = geminiTaskAtomService;
        this.geminiConditionAtomService = geminiConditionAtomService;
        this.geminiTemplateAtomService = geminiTemplateAtomService;
        this.geminiRelTemplateVariableAtomService = geminiRelTemplateVariableAtomService;
        this.geminiVariableAtomService = geminiVariableAtomService;
        this.geminiRecordMapper = geminiRecordMapper;
        this.geminiTypeDetailQryAtomService = geminiTypeDetailQryAtomService;
        this.geminiRelTemplateMapper = geminiRelTemplateMapper;
        this.geminiReceiverAtomService = geminiReceiverAtomService;
        this.geminiSendTypeMapper = geminiSendTypeMapper;
        this.geminiDictionaryBusiService = geminiDictionaryBusiService;
        this.sysDicDictionaryMapper = sysDicDictionaryMapper;
    }

    public GeminiTaskDetailsQryRspBO qryTaskDetails(GeminiTaskDetailsQryReqBO reqBO) {
        GeminiTaskDetailsQryRspBO rspBO = new GeminiTaskDetailsQryRspBO();
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setTaskId(reqBO.getTaskId());
        GeminiTaskDetailsAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomReqBO);
        if (!"0000".equals(taskAtomRspBO.getRespCode())) {
            throw new GeminiBusinessException(taskAtomRspBO.getRespCode(), taskAtomRspBO.getRespDesc());
        }
        BeanUtils.copyProperties((Object)((Object)taskAtomRspBO), (Object)rspBO);
        GeminiTypeDetailQryAtomReqBO typeDetailQryAtomReqBO = new GeminiTypeDetailQryAtomReqBO();
        typeDetailQryAtomReqBO.setTypeId(taskAtomRspBO.getTypeId());
        GeminiTypeDetailQryAtomRspBO typeDetailQryAtomRspBO = this.geminiTypeDetailQryAtomService.getDetail(typeDetailQryAtomReqBO);
        if (!StringUtils.isEmpty((Object)((Object)typeDetailQryAtomRspBO))) {
            rspBO.setTypeName(typeDetailQryAtomRspBO.getTypeName());
        }
        GeminiTemplateAtomReqBO templateAtomReqBO = new GeminiTemplateAtomReqBO();
        templateAtomReqBO.setTemplateId(taskAtomRspBO.getTemplateId());
        GeminiTemplateDetailsAtomRspBO templateDetailsAtomRspBO = this.geminiTemplateAtomService.qryTemplateDetails(templateAtomReqBO);
        if (!StringUtils.isEmpty((Object)((Object)templateDetailsAtomRspBO))) {
            rspBO.setMessageTitle(templateDetailsAtomRspBO.getMessageTitle());
            rspBO.setMessageContent(templateDetailsAtomRspBO.getMessageContent());
            rspBO.setMessageContentHtml(templateDetailsAtomRspBO.getMessageContentHtml());
        }
        GeminiRelTemplateVariableListAtomReqBO relTemplateVariableListAtomReqBO = new GeminiRelTemplateVariableListAtomReqBO();
        GeminiRelTemplateVariableDataBO relTemplateVariableData = new GeminiRelTemplateVariableDataBO();
        relTemplateVariableData.setTemplateId(taskAtomRspBO.getTemplateId());
        relTemplateVariableListAtomReqBO.setRelTemplateVariableData(relTemplateVariableData);
        GeminiRelTemplateVariableListAtomRspBO relTemplateVariableListAtomRspBO = this.geminiRelTemplateVariableAtomService.qryRelTemplateVariableList(relTemplateVariableListAtomReqBO);
        HashMap valueMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(relTemplateVariableListAtomRspBO.getRelTemplateVariableDataBoList())) {
            ArrayList<Long> variableIdList = new ArrayList<Long>();
            relTemplateVariableListAtomRspBO.getRelTemplateVariableDataBoList().forEach(relTemplateVariableDataBo -> variableIdList.add(relTemplateVariableDataBo.getVariableId()));
            GeminiVariableListQryReqBO variableListQryReqBO = new GeminiVariableListQryReqBO();
            variableListQryReqBO.setVariableIdList(variableIdList);
            GeminiVariableListQryRspBO variableListQryRspBO = this.geminiVariableAtomService.qryVariableList(variableListQryReqBO);
            variableListQryRspBO.getVariableDataBOList().forEach(variableDataBO -> valueMap.put(String.valueOf(variableDataBO.getVariableId()), variableDataBO.getVariableName()));
            rspBO.setMessageContent(GeminiTranslationUtil.codeReplacementId((String)rspBO.getMessageContent(), valueMap));
            rspBO.setMessageTitle(GeminiTranslationUtil.codeReplacementId((String)rspBO.getMessageTitle(), valueMap));
        }
        this.getThirdPartyTemplates(rspBO, templateDetailsAtomRspBO.getTemplateId());
        GeminiConditionDataBO conditionDataBO = new GeminiConditionDataBO();
        conditionDataBO.setTaskId(reqBO.getTaskId());
        conditionDataBO.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
        GeminiConditionDetailsAtomReqBO conditionAtomReqBO = new GeminiConditionDetailsAtomReqBO();
        conditionAtomReqBO.setConditionData(conditionDataBO);
        GeminiConditionDetailsAtomRspBO conditionAtomRspBo = this.geminiConditionAtomService.qryConditionDetails(conditionAtomReqBO);
        if (!StringUtils.isEmpty((Object)((Object)conditionAtomRspBo))) {
            rspBO.setTaskConditionData((GeminiConditionDataBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)conditionAtomRspBo)), GeminiConditionDataBO.class));
        }
        this.qryReceiver(rspBO, reqBO.getTaskId());
        this.getNoteCount(reqBO.getTaskId(), rspBO);
        GeminiRecordPO recordPo = new GeminiRecordPO();
        recordPo.setTaskId(reqBO.getTaskId());
        recordPo.setSendStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
        recordPo.setOrderBy("SEND_TIME desc");
        List<GeminiRecordPO> recordPoList = this.geminiRecordMapper.getList(recordPo);
        if (!CollectionUtils.isEmpty(recordPoList)) {
            rspBO.setUpdateTime(recordPoList.get(0).getSendTime());
        }
        this.getDictionaryMap(rspBO);
        return rspBO;
    }

    private void getDictionaryMap(GeminiTaskDetailsQryRspBO rspBO) {
        GeminiDictionaryBusiReqBO busiReqBO = new GeminiDictionaryBusiReqBO();
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("PUSH_WAY");
        pCodes.add("EXECUTE_WAY");
        pCodes.add("TASK_STATUS");
        pCodes.add("CREATE_PATTERN");
        busiReqBO.setPCodes(pCodes);
        GeminiDictionaryBusiRspBO busiRspBO = this.geminiDictionaryBusiService.getDicMap(busiReqBO);
        Map<String, Map<String, String>> dicMaps = busiRspBO.getDicMaps();
        Map<String, String> executeWayMap = dicMaps.get("EXECUTE_WAY");
        Map<String, String> taskStatusMap = dicMaps.get("TASK_STATUS");
        Map<String, String> createPatternMap = dicMaps.get("CREATE_PATTERN");
        rspBO.setMessageCreatePatternStr(createPatternMap.get(String.valueOf(rspBO.getMessageCreatePattern())));
        rspBO.setExecuteWayStr(executeWayMap.get(String.valueOf(rspBO.getExecuteWay())));
        rspBO.setStatusStr(taskStatusMap.get(String.valueOf(rspBO.getStatus())));
        Map<String, String> sendTypeMap = this.getSendType();
        List<String> sendTypeList = JSON.parseArray((String)rspBO.getSendType(), String.class);
        Set<String> validSendTypeList = sendTypeMap.keySet();
        sendTypeList = sendTypeList.stream().filter(item -> validSendTypeList.contains(item)).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        sendTypeList.forEach(item -> stringBuilder.append((String)sendTypeMap.get(item)).append("\uff0c"));
        if (ObjectUtil.isNotEmpty((Object)stringBuilder)) {
            rspBO.setSendTypeStr(stringBuilder.deleteCharAt(stringBuilder.lastIndexOf("\uff0c")).toString());
        }
        rspBO.setSendType(JSON.toJSONString(sendTypeList));
    }

    public GeminiTaskPageQryRspBO qryTaskPageList(GeminiTaskPageQryReqBO reqBO) {
        List<GeminiTaskDataBO> rows;
        GeminiTaskPageQryRspBO rspBO = new GeminiTaskPageQryRspBO();
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        GeminiRspPageBaseBO data = new GeminiRspPageBaseBO();
        rspBO.setData(data);
        Page<GeminiTaskPO> page = this.getPage(reqBO);
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)taskAtomReqBO);
        if (-1 == reqBO.getPageNo() || -1 == reqBO.getPageSize()) {
            GeminiTaskListQryAtomRspBO taskListQryAtomRspBO = this.geminiTaskAtomService.qryTaskList(taskAtomReqBO);
            rows = taskListQryAtomRspBO.getTaskDataBOList();
        } else {
            GeminiTaskPageQryAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskPageList(taskAtomReqBO, page);
            rows = taskAtomRspBO.getTaskDataBOList();
        }
        data.setRows(rows);
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        if (CollectionUtils.isEmpty(rows)) {
            return rspBO;
        }
        List<Long> templateIds = rows.stream().map(GeminiTaskDataBO::getTemplateId).collect(Collectors.toList());
        GeminiTemplateAtomReqBO templateAtomReqBo = new GeminiTemplateAtomReqBO();
        templateAtomReqBo.setTemplateIds(templateIds);
        GeminiTemplateListQryAtomRspBO templateAtomRspBo = this.geminiTemplateAtomService.qryTemplateListByIds(templateAtomReqBo);
        List<GeminiTemplateDataBO> templateDataList = templateAtomRspBo.getTemplateDataList();
        if (CollectionUtils.isEmpty(templateDataList)) {
            return rspBO;
        }
        Map<String, String> executeWayMap = this.getExecuteDic();
        Map<Long, GeminiTemplateDataBO> templateMap = templateDataList.stream().collect(Collectors.toMap(GeminiTemplateDataBO::getTemplateId, item -> item));
        rows.forEach(item -> {
            GeminiTemplateDataBO template = (GeminiTemplateDataBO)templateMap.get(item.getTemplateId());
            item.setMessageContent(template.getMessageContent());
            item.setMessageTitle(template.getMessageTitle());
            this.setSendType((GeminiTaskDataBO)item);
            if (!CollectionUtils.isEmpty((Map)executeWayMap)) {
                item.setExecuteWayDesc((String)executeWayMap.get(item.getExecuteWay().toString()));
            }
        });
        return rspBO;
    }

    private void setSendType(GeminiTaskDataBO taskDataBo) {
        Map<String, String> sendTypeMap = this.getSendType();
        List<String> sendTypeList = JSON.parseArray((String)taskDataBo.getSendType(), String.class);
        Set<String> validSendTypeList = sendTypeMap.keySet();
        sendTypeList = sendTypeList.stream().filter(validSendTypeList::contains).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        sendTypeList.forEach(item -> stringBuilder.append((String)sendTypeMap.get(item)).append("\uff0c"));
        if (ObjectUtil.isNotEmpty((Object)stringBuilder)) {
            taskDataBo.setSendTypeDesc(stringBuilder.deleteCharAt(stringBuilder.lastIndexOf("\uff0c")).toString());
        }
        taskDataBo.setSendType(JSON.toJSONString(sendTypeList));
    }

    private Map<String, String> getExecuteDic() {
        SysDicDictionaryPO sysDicDictionaryPo = new SysDicDictionaryPO();
        sysDicDictionaryPo.setPCode("EXECUTE_WAY");
        List<SysDicDictionaryPO> dicList = this.sysDicDictionaryMapper.getList(sysDicDictionaryPo);
        if (!CollectionUtils.isEmpty(dicList)) {
            return dicList.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getTitle));
        }
        return null;
    }

    private Map<String, String> getSendType() {
        GeminiSendTypePO sendTypePo = new GeminiSendTypePO();
        sendTypePo.setSign(1);
        sendTypePo.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
        List<GeminiSendTypePO> sendTypeList = this.geminiSendTypeMapper.getList(sendTypePo);
        return sendTypeList.stream().collect(Collectors.toMap(item -> item.getTypeId().toString(), GeminiSendTypePO::getTypeName));
    }

    private Page<GeminiTaskPO> getPage(GeminiTaskPageQryReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBO, (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private void getNoteCount(Long taskId, GeminiTaskDetailsQryRspBO rspBO) {
        GeminiRecordPO recordmessageReqPo = new GeminiRecordPO();
        recordmessageReqPo.setTaskId(taskId);
        recordmessageReqPo.setSendType(String.valueOf(GeminiEnums.MessageAble.ALIBABA_MESSAGE.getAbleId()));
        recordmessageReqPo.setSendStatus(GeminiConstants.StatusConstants.SEND_STATUS_SUCCESS);
        List<GeminiRecordPO> recordAliPoList = this.geminiRecordMapper.getList(recordmessageReqPo);
        int aLiMessageCount = 0;
        if (!CollectionUtils.isEmpty(recordAliPoList)) {
            for (GeminiRecordPO recordPo : recordAliPoList) {
                aLiMessageCount += recordPo.getReceiver().split(",").length;
            }
        }
        rspBO.setAliMessageCount(Integer.valueOf(aLiMessageCount));
        recordmessageReqPo.setSendType(String.valueOf(GeminiEnums.MessageAble.EMAIL.getAbleId()));
        recordmessageReqPo.setSendStatus(GeminiConstants.StatusConstants.SEND_STATUS_SUCCESS);
        List<GeminiRecordPO> recordEmailPoList = this.geminiRecordMapper.getList(recordmessageReqPo);
        int emailCount = 0;
        if (!CollectionUtils.isEmpty(recordEmailPoList)) {
            for (GeminiRecordPO recordPo : recordEmailPoList) {
                emailCount += recordPo.getReceiver().split(",").length;
            }
        }
        rspBO.setEmailCount(Integer.valueOf(emailCount));
    }

    private void getThirdPartyTemplates(GeminiTaskDetailsQryRspBO rspBO, Long templateId) {
        GeminiRelTemplatePO relTemplateReqPo = new GeminiRelTemplatePO();
        relTemplateReqPo.setTemplateId(templateId);
        relTemplateReqPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        GeminiRelTemplatePO relTemplateRspPo = this.geminiRelTemplateMapper.getModelBy(relTemplateReqPo);
        if (!StringUtils.isEmpty((Object)relTemplateRspPo)) {
            rspBO.setThirdpartyTemplateId(relTemplateRspPo.getThirdTemplateCode());
        }
    }

    private void qryReceiver(GeminiTaskDetailsQryRspBO rspBO, Long taskId) {
        GeminiReceiverDataBO receiverDataBO = new GeminiReceiverDataBO();
        receiverDataBO.setTaskId(taskId);
        receiverDataBO.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        GeminiReceiverListQryAtomReqBO receiverListQryAtomReqBO = new GeminiReceiverListQryAtomReqBO();
        receiverListQryAtomReqBO.setReceiverData(receiverDataBO);
        GeminiReceiverListQryAtomRspBO receiverListQryAtomRspBO = this.geminiReceiverAtomService.qryReceiverList(receiverListQryAtomReqBO);
        if (!StringUtils.isEmpty((Object)((Object)receiverListQryAtomRspBO)) && !StringUtils.isEmpty(receiverListQryAtomRspBO.getReceiverDetailsAtomRspBOList())) {
            rspBO.setTaskReceiverList(JSON.parseArray((String)JSON.toJSONString(receiverListQryAtomRspBO.getReceiverDetailsAtomRspBOList()), GeminiTaskReceiverDataBO.class));
        }
    }
}

