/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.gemini.atom.api.GeminiTemplateAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTemplateAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplateListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplatePageQryAtomRspBO;
import com.tydic.gemini.base.GeminiRspPageBaseBO;
import com.tydic.gemini.busi.api.GeminiDictionaryBusiService;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.po.GeminiTemplatePO;
import com.tydic.gemini.web.api.GeminiTemplateListQryService;
import com.tydic.gemini.web.api.bo.GeminiTemplateDataBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateListQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateListQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiTemplatePageQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTemplatePageQryRspBO;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class GeminiTemplateListQryServiceImpl
implements GeminiTemplateListQryService {
    private GeminiTemplateAtomService geminiTemplateAtomService;
    private GeminiDictionaryBusiService geminiDictionaryBusiService;

    public GeminiTemplateListQryServiceImpl(GeminiTemplateAtomService geminiTemplateAtomService, GeminiDictionaryBusiService geminiDictionaryBusiService) {
        this.geminiTemplateAtomService = geminiTemplateAtomService;
        this.geminiDictionaryBusiService = geminiDictionaryBusiService;
    }

    public GeminiTemplateListQryRspBO qryTemplateList(GeminiTemplateListQryReqBO reqBO) {
        GeminiTemplateListQryRspBO rspBO = new GeminiTemplateListQryRspBO();
        GeminiTemplateAtomReqBO atomReqBO = new GeminiTemplateAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)atomReqBO));
        atomReqBO.setCreateWay(GeminiConstants.JudgmentWayConstants.FRONT_DESK_MANAGEMENT_CREATE_WAY);
        GeminiTemplateListQryAtomRspBO atomRspBO = this.geminiTemplateAtomService.qryTemplateList(atomReqBO);
        rspBO.setTemplateDataList(atomRspBO.getTemplateDataList());
        return rspBO;
    }

    public GeminiTemplatePageQryRspBO qryTemplatePageList(GeminiTemplatePageQryReqBO reqBO) {
        GeminiTemplatePageQryRspBO rspBO = new GeminiTemplatePageQryRspBO();
        GeminiRspPageBaseBO data = new GeminiRspPageBaseBO();
        ArrayList rows = new ArrayList();
        data.setRows(rows);
        rspBO.setData(data);
        Page<GeminiTemplatePO> page = this.getPage(reqBO);
        GeminiTemplateAtomReqBO templateAtomReqBO = new GeminiTemplateAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)templateAtomReqBO));
        templateAtomReqBO.setCreateWay(GeminiConstants.JudgmentWayConstants.FRONT_DESK_MANAGEMENT_CREATE_WAY);
        GeminiTemplatePageQryAtomRspBO templateAtomRspBO = this.geminiTemplateAtomService.qryTemplatePageList(templateAtomReqBO, page);
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        for (GeminiTemplateDataBO templateDataBO : templateAtomRspBO.getTemplateDataBoList()) {
            templateDataBO.setStatusStr(dicMap.get("MODULE_STATUS").get(templateDataBO.getStatus().toString()));
        }
        data.setRows(templateAtomRspBO.getTemplateDataBoList());
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }

    private Map<String, Map<String, String>> getDicMap() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("MODULE_STATUS");
        GeminiDictionaryBusiReqBO dictionaryBusiReqBO = new GeminiDictionaryBusiReqBO();
        dictionaryBusiReqBO.setPCodes(pCodes);
        GeminiDictionaryBusiRspBO dictionaryBusiRspBO = this.geminiDictionaryBusiService.getDicMap(dictionaryBusiReqBO);
        return dictionaryBusiRspBO.getDicMaps();
    }

    private Page<GeminiTemplatePO> getPage(GeminiTemplatePageQryReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBO, (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

