/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.web.impl;

import com.tydic.gemini.atom.api.GeminiTypeListAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTypeListAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTypeListAtomRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.web.api.GeminiTypeListService;
import com.tydic.gemini.web.api.bo.GeminiTypeDataBO;
import com.tydic.gemini.web.api.bo.GeminiTypeListReqBO;
import com.tydic.gemini.web.api.bo.GeminiTypeListRspBO;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GeminiTypeListServiceImpl
implements GeminiTypeListService {
    private static final Logger log = LoggerFactory.getLogger(GeminiTypeListServiceImpl.class);
    private GeminiTypeListAtomService geminiTypeListAtomService;
    private GeminiTaskMapper geminiTaskMapper;

    public GeminiTypeListServiceImpl(GeminiTypeListAtomService geminiTypeListAtomService, GeminiTaskMapper geminiTaskMapper) {
        this.geminiTypeListAtomService = geminiTypeListAtomService;
        this.geminiTaskMapper = geminiTaskMapper;
    }

    public GeminiTypeListRspBO getList(GeminiTypeListReqBO reqBO) {
        String validateArg = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateArg)) {
            throw new GeminiBusinessException("1002", validateArg);
        }
        GeminiTypeListRspBO rspBO = new GeminiTypeListRspBO();
        GeminiTypeListAtomReqBO atomReqBO = new GeminiTypeListAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)atomReqBO));
        GeminiTypeListAtomRspBO atomRspBO = this.geminiTypeListAtomService.getList(atomReqBO);
        BeanUtils.copyProperties((Object)((Object)atomRspBO), (Object)rspBO);
        ArrayList<GeminiTypeDataBO> typeDataBoRspList = new ArrayList<GeminiTypeDataBO>();
        if (GeminiConstants.JudgmentWayConstants.PAGE_SIZE_MAX.equals(reqBO.getPageSize())) {
            List<Long> typeIdList = atomRspBO.getData().getRows().stream().map(GeminiTypeDataBO::getTypeId).collect(Collectors.toList());
            List<GeminiTaskPO> taskPoList = this.geminiTaskMapper.getTaskByTypeIdList(typeIdList);
            List typeIdInUseList = taskPoList.stream().map(GeminiTaskPO::getTypeId).collect(Collectors.toList());
            List typeDataBOList = atomRspBO.getData().getRows();
            for (GeminiTypeDataBO typeDataBO : typeDataBOList) {
                if (typeIdInUseList.contains(typeDataBO.getTypeId())) continue;
                typeDataBoRspList.add(typeDataBO);
            }
            rspBO.getData().setRows(typeDataBoRspList);
        }
        return rspBO;
    }
}

