/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.controller;

import com.tydic.gemini.annotation.Intercept;
import com.tydic.gemini.api.GeminiSendAbilityService;
import com.tydic.gemini.api.bo.GeminiSendAbilityReqBO;
import com.tydic.gemini.api.bo.GeminiSendAbilityRspBO;
import com.tydic.gemini.constants.GeminiDicValue;
import com.tydic.gemini.web.api.GeminiAccessTokenQryService;
import com.tydic.gemini.web.api.GeminiInterceptQryService;
import com.tydic.gemini.web.api.GeminiSendTypeQryService;
import com.tydic.gemini.web.api.bo.GeminiAccessTokenQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiAccessTokenQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiInterceptQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiInterceptQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiSendTypeQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiSendTypeQryRspBO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gemini/internal"})
public class GeminiController {
    private GeminiInterceptQryService geminiInterceptQryService;
    private GeminiSendTypeQryService geminiSendTypeQryService;
    private GeminiSendAbilityService geminiSendAbilityService;
    private GeminiAccessTokenQryService geminiAccessTokenQryService;

    public GeminiController(GeminiInterceptQryService geminiInterceptQryService, GeminiSendTypeQryService geminiSendTypeQryService, GeminiSendAbilityService geminiSendAbilityService, GeminiAccessTokenQryService geminiAccessTokenQryService) {
        this.geminiInterceptQryService = geminiInterceptQryService;
        this.geminiSendTypeQryService = geminiSendTypeQryService;
        this.geminiSendAbilityService = geminiSendAbilityService;
        this.geminiAccessTokenQryService = geminiAccessTokenQryService;
    }

    @PostMapping(value={"refreshIntercept"})
    @ResponseBody
    public GeminiInterceptQryRspBO refreshIntercept() {
        return this.geminiInterceptQryService.qryIntercept(new GeminiInterceptQryReqBO());
    }

    @PostMapping(value={"refreshSendType"})
    @ResponseBody
    public GeminiSendTypeQryRspBO refreshSendType() {
        GeminiSendTypeQryReqBO reqBo = new GeminiSendTypeQryReqBO();
        reqBo.setStatus(GeminiDicValue.GEMINI_TYPE_STATUS_ENABLE);
        reqBo.setSign(GeminiDicValue.SIGN_BACK_END);
        return this.geminiSendTypeQryService.sendTypeListQry(reqBo);
    }

    @PostMapping(value={"refreshAccessToken"})
    @ResponseBody
    public GeminiAccessTokenQryRspBO refreshAccessToken(@RequestBody GeminiAccessTokenQryReqBO reqBO) {
        return this.geminiAccessTokenQryService.qryAccessToken(reqBO);
    }

    @PostMapping(value={"/pushTaskInfo"})
    @Intercept
    public GeminiSendAbilityRspBO sendMessage(@RequestBody GeminiSendAbilityReqBO reqBo) {
        return this.geminiSendAbilityService.sendMessage(reqBo);
    }
}

