/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.controller;

import com.tydic.gemini.annotation.Intercept;
import com.tydic.gemini.api.GeminiSendAbilityService;
import com.tydic.gemini.api.bo.GeminiSendAbilityReqBO;
import com.tydic.gemini.api.bo.GeminiSendAbilityRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.web.api.GeminiTaskAddService;
import com.tydic.gemini.web.api.GeminiTaskEditService;
import com.tydic.gemini.web.api.GeminiTaskQryService;
import com.tydic.gemini.web.api.bo.GeminiTaskAddReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskAddRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDeleteReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDeleteRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDetailsQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDetailsQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDuplicateReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskDuplicateRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskEditReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskEditRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskEditStatusReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskEditStatusRspBO;
import com.tydic.gemini.web.api.bo.GeminiTaskPageQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTaskPageQryRspBO;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gemini/task"})
public class GeminiTaskController {
    private GeminiTaskAddService geminiTaskAddService;
    private GeminiTaskQryService geminiTaskQryService;
    private GeminiTaskEditService geminiTaskEditService;
    private GeminiSendAbilityService geminiSendAbilityService;

    public GeminiTaskController(GeminiTaskAddService geminiTaskAddService, GeminiTaskQryService geminiTaskQryService, GeminiTaskEditService geminiTaskEditService, GeminiSendAbilityService geminiSendAbilityService) {
        this.geminiTaskAddService = geminiTaskAddService;
        this.geminiTaskQryService = geminiTaskQryService;
        this.geminiTaskEditService = geminiTaskEditService;
        this.geminiSendAbilityService = geminiSendAbilityService;
    }

    @PostMapping(value={"/addTaskInfo"})
    public GeminiTaskAddRspBO addTaskInfo(@RequestBody GeminiTaskAddReqBO reqBO) {
        return this.geminiTaskAddService.addTask(reqBO);
    }

    @PostMapping(value={"/deleteTaskInfo"})
    public GeminiTaskDeleteRspBO deleteTaskInfo(@RequestBody GeminiTaskDeleteReqBO reqBO) {
        GeminiTaskDeleteRspBO rspBO = new GeminiTaskDeleteRspBO();
        GeminiTaskEditStatusReqBO taskEditStatusReqBO = new GeminiTaskEditStatusReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)taskEditStatusReqBO);
        taskEditStatusReqBO.setStatus(GeminiConstants.StatusConstants.TASK_DELETE_STATUS);
        taskEditStatusReqBO.setCallWay("0");
        GeminiTaskEditStatusRspBO taskEditStatusRspBO = this.geminiTaskEditService.editTaskStatus(taskEditStatusReqBO);
        BeanUtils.copyProperties((Object)taskEditStatusRspBO, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/qryTaskDetails"})
    public GeminiTaskDetailsQryRspBO qryTaskDetails(@RequestBody GeminiTaskDetailsQryReqBO reqBO) {
        return this.geminiTaskQryService.qryTaskDetails(reqBO);
    }

    @PostMapping(value={"/updateTaskInfo"})
    public GeminiTaskEditRspBO editTaskInfo(@RequestBody GeminiTaskEditReqBO reqBO) {
        return this.geminiTaskEditService.editTaskInfo(reqBO);
    }

    @PostMapping(value={"/updateTaskStatus"})
    public GeminiTaskEditStatusRspBO editTaskStatus(@RequestBody GeminiTaskEditStatusReqBO reqBO) {
        reqBO.setCallWay("1");
        return this.geminiTaskEditService.editTaskStatus(reqBO);
    }

    @PostMapping(value={"/qryTaskPageList"})
    public GeminiTaskPageQryRspBO qryTaskPageList(@RequestBody GeminiTaskPageQryReqBO reqBO) {
        return this.geminiTaskQryService.qryTaskPageList(reqBO);
    }

    @PostMapping(value={"/duplicateTaskInfo"})
    public GeminiTaskDuplicateRspBO duplicateTaskInfo(@RequestBody GeminiTaskDuplicateReqBO reqBO) {
        return this.geminiTaskAddService.duplicateTask(reqBO);
    }

    @PostMapping(value={"/pushTaskInfo"})
    @Intercept
    public GeminiSendAbilityRspBO sendMessage(@RequestBody GeminiSendAbilityReqBO reqBo) {
        return this.geminiSendAbilityService.sendMessage(reqBo);
    }
}

