/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.controller;

import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.web.api.GeminiTemplateAddService;
import com.tydic.gemini.web.api.GeminiTemplateDetailsQryService;
import com.tydic.gemini.web.api.GeminiTemplateEditService;
import com.tydic.gemini.web.api.GeminiTemplateListQryService;
import com.tydic.gemini.web.api.bo.GeminiTemplateAddReqBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateAddRspBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateDetailsQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateDetailsQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateEditReqBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateEditRspBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateEditStatusReqBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateEditStatusRspBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateListQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTemplateListQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiTemplatePageQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiTemplatePageQryRspBO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gemini/template"})
public class GeminiTemplateController {
    private GeminiTemplateAddService geminiTemplateAddService;
    private GeminiTemplateDetailsQryService geminiTemplateDetailsQryService;
    private GeminiTemplateListQryService geminiTemplateListQryService;
    private GeminiTemplateEditService geminiTemplateEditService;

    public GeminiTemplateController(GeminiTemplateAddService geminiTemplateAddService, GeminiTemplateDetailsQryService geminiTemplateDetailsQryService, GeminiTemplateListQryService geminiTemplateListQryService, GeminiTemplateEditService geminiTemplateEditService) {
        this.geminiTemplateAddService = geminiTemplateAddService;
        this.geminiTemplateDetailsQryService = geminiTemplateDetailsQryService;
        this.geminiTemplateListQryService = geminiTemplateListQryService;
        this.geminiTemplateEditService = geminiTemplateEditService;
    }

    @PostMapping(value={"/addTemplateInfo"})
    public GeminiTemplateAddRspBO addTemplateInfo(@RequestBody GeminiTemplateAddReqBO reqBO) {
        reqBO.setCreateWay(GeminiConstants.JudgmentWayConstants.FRONT_DESK_MANAGEMENT_CREATE_WAY);
        return this.geminiTemplateAddService.addTemplate(reqBO);
    }

    @PostMapping(value={"/qryTemplateDetails"})
    public GeminiTemplateDetailsQryRspBO qryTemplateDetails(@RequestBody GeminiTemplateDetailsQryReqBO reqBO) {
        return this.geminiTemplateDetailsQryService.qryTemplateDetails(reqBO);
    }

    @PostMapping(value={"/qryTemplateList"})
    public GeminiTemplateListQryRspBO qryTemplateList(@RequestBody GeminiTemplateListQryReqBO reqBO) {
        return this.geminiTemplateListQryService.qryTemplateList(reqBO);
    }

    @PostMapping(value={"/qryTemplatePageList"})
    public GeminiTemplatePageQryRspBO qryTemplatePageList(@RequestBody GeminiTemplatePageQryReqBO reqBO) {
        return this.geminiTemplateListQryService.qryTemplatePageList(reqBO);
    }

    @PostMapping(value={"/editTemplateStatus"})
    public GeminiTemplateEditStatusRspBO editTemplateStatus(@RequestBody GeminiTemplateEditStatusReqBO reqBO) {
        reqBO.setCallWay("1");
        return this.geminiTemplateEditService.editTemplateStatus(reqBO);
    }

    @PostMapping(value={"deleteTemplate"})
    public GeminiTemplateEditStatusRspBO deleteTemplate(@RequestBody GeminiTemplateEditStatusReqBO reqBO) {
        reqBO.setStatus(GeminiConstants.StatusConstants.TASK_DELETE_STATUS);
        reqBO.setCallWay("0");
        return this.geminiTemplateEditService.editTemplateStatus(reqBO);
    }

    @PostMapping(value={"editTemplateInfo"})
    public GeminiTemplateEditRspBO editTemplateInfo(@RequestBody GeminiTemplateEditReqBO reqBO) {
        reqBO.setCreateWay(GeminiConstants.JudgmentWayConstants.FRONT_DESK_MANAGEMENT_CREATE_WAY);
        return this.geminiTemplateEditService.editTemplateInfo(reqBO);
    }
}

