/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.agr.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrConfirmType;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrDealConfirmService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrDealConfirmReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrDealConfirmRspBO;
import com.tydic.dycpro.saas.agr.agreement.api.DycProSaasAgrDealConfirmService;
import com.tydic.dycpro.saas.agr.agreement.bo.DycProSaasAgrDealConfirmReqBO;
import com.tydic.dycpro.saas.agr.agreement.bo.DycProSaasAgrDealConfirmRspBO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspInfoBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.agr.agreement.api.DycProSaasAgrDealConfirmService"})
public class DycProSaasAgrDealConfirmServiceImpl
implements DycProSaasAgrDealConfirmService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasAgrDealConfirmServiceImpl.class);
    @Autowired
    private DycProAgrDealConfirmService dycProAgrDealConfirmService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${process.sysCode:DYC}")
    private String processSysCode;
    @Value(value="${agr.approve.create.switch:true}")
    private Boolean agrCreateApproveSwitch;
    @Value(value="${agr.approve.create.key:AGR_CREATE_APPROVE}")
    private String agrCreateApproveKey;
    @Value(value="${agr.approve.change.switch:true}")
    private Boolean agrChangeApproveSwitch;
    @Value(value="${agr.approve.change.key:AGR_CHANGE_APPROVE}")
    private String agrChangeApproveKey;

    @Override
    @PostMapping(value={"dealAgrConfirm"})
    public DycProSaasAgrDealConfirmRspBO dealAgrConfirm(@RequestBody DycProSaasAgrDealConfirmReqBO reqBO) {
        this.judge(reqBO);
        if (reqBO.getConfirmType().equals(Integer.parseInt(DmcAgrConfirmType.CREATE.getCode()))) {
            this.dealAgrCreate(reqBO);
        } else if (reqBO.getConfirmType().equals(Integer.parseInt(DmcAgrConfirmType.CHANGE.getCode()))) {
            this.dealAgrChange(reqBO);
        } else {
            throw new ZTBusinessException("\u672a\u77e5\u7684\u786e\u8ba4\u7c7b\u578b");
        }
        return new DycProSaasAgrDealConfirmRspBO();
    }

    private void dealAgrCreate(DycProSaasAgrDealConfirmReqBO reqBO) {
        if (this.agrCreateApproveSwitch.booleanValue() && reqBO.getOperType() == 1) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("agrObjPrimaryId", reqBO.getAgrObjPrimaryId());
            this.startApprovalFlow(reqBO, this.agrCreateApproveKey, PublicProcInstBusiType.AGR_CREATE_APPROVE.getCode(), reqBO.getAgrObjPrimaryId(), variables);
        }
        this.dealAgrConfirmCenter(reqBO, this.agrCreateApproveSwitch);
    }

    private void dealAgrChange(DycProSaasAgrDealConfirmReqBO reqBO) {
        if (this.agrChangeApproveSwitch.booleanValue() && reqBO.getOperType() == 1) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("chngApplyId", reqBO.getChngApplyId());
            this.startApprovalFlow(reqBO, this.agrChangeApproveKey, PublicProcInstBusiType.AGR_CHANGE_APPROVE.getCode(), reqBO.getChngApplyId(), variables);
        }
        this.dealAgrConfirmCenter(reqBO, this.agrChangeApproveSwitch);
    }

    private String startApprovalFlow(DycProSaasAgrDealConfirmReqBO reqBO, String procDefKey, String businessType, Long businessId, Map<String, Object> variables) {
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO;
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(procDefKey);
        ArrayList<String> businessIdList = new ArrayList<String>();
        businessIdList.add(businessId.toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(businessIdList);
        eacStartProjectAbilityReqBO.setOrgId(reqBO.getOrgId().toString());
        eacStartProjectAbilityReqBO.setOrgName(reqBO.getOrgName());
        eacStartProjectAbilityReqBO.setUserId(reqBO.getUserId().toString());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        eacStartProjectAbilityReqBO.setVariables(variables);
        variables.put("auditResult", "pass");
        try {
            log.info("\u534f\u8bae\u521b\u5efa\u5ba1\u6279\u5355\u5165\u53c2eacStartProjectAbilityReqBO :" + JSON.toJSON((Object)eacStartProjectAbilityReqBO));
            eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u534f\u8bae\u521b\u5efa\u5ba1\u6279\u5355\u51fa\u53c2eacStartProjectAbilityRspBO:" + JSON.toJSON((Object)eacStartProjectAbilityRspBO));
        }
        catch (Exception e) {
            log.error("\u534f\u8bae\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            throw new ZTBusinessException("\u534f\u8bae\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
        return ((EacStartProjectAbilityRspInfoBO)eacStartProjectAbilityRspBO.getData().get(0)).getApproveInstId();
    }

    private void dealAgrConfirmCenter(DycProSaasAgrDealConfirmReqBO reqBO, Boolean approveSwitch) {
        DycProAgrDealConfirmReqBO agrDealConfirmReqBO = (DycProAgrDealConfirmReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProAgrDealConfirmReqBO.class);
        agrDealConfirmReqBO.setApproveSwitch(approveSwitch);
        DycProAgrDealConfirmRspBO agrDealConfirmRspBO = this.dycProAgrDealConfirmService.dealAgrConfirm(agrDealConfirmReqBO);
        if (!"0000".equals(agrDealConfirmRspBO.getRespCode())) {
            throw new ZTBusinessException(agrDealConfirmRspBO.getRespDesc());
        }
    }

    private void judge(DycProSaasAgrDealConfirmReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new ZTBusinessException("\u3010\u786e\u8ba4\u7ed3\u679c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getConfirmType())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u786e\u8ba4\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrObjPrimaryId())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u5bf9\u8c61\u552f\u4e00ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getConfirmType().equals(Integer.parseInt(DmcAgrConfirmType.CHANGE.getCode())) && ObjectUtils.isEmpty((Object)reqBO.getChngApplyId())) {
            throw new ZTBusinessException("\u3010\u53d8\u66f4\u7533\u8bf7ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

