package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class DycProBaseCallEsbUtilOrderEsPreOrderSubmitRspResultBO implements Serializable {
    private static final long serialVersionUID = 932908579809268082L;
    /**
     * 京东订单号
     */
    private String jdOrderId;

    /**
     * 电商订单号，可以理解为父单号，拆单后，会出现子单号；不拆单的，即既是父单号也是子单号
     */
    private String orderId;

    /**
     * 总运费；这个是订单总运费 = 基础运费 + 总的超重偏远附加运费
     */
    private BigDecimal freight;

    /**
     * 商品总价格
     */
    private BigDecimal orderPrice;

    /**
     * 订单裸价
     */
    private BigDecimal orderNakedPrice;

    /**
     * 订单税额
     */
    private BigDecimal orderTaxPrice;

    /**
     * sku 列表
     */
    private List<DycProBaseCallEsbUtilOrderEsPreOrderSubmitRspSkuBO> sku;

}


