package com.tydic.dyc.pro.base.utils.msgPool;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;

/**
 * @Author lihulin
 * @Date 2025/07/03 14:29
 * @Description:调用消息池工具
 **/
@Slf4j
public class DycProBaseMsgPoolUtil {


    /**
     * 消息处理前置服务
     *
     * @param reqBO
     */
    public static void spoolBeforeService(DycProBaseMsgPoolBeforeServiceReqBO reqBO) {
        String spoolAbilityServiceRsp = null;
        try {
            log.info("调用电商消息前置服务地址：{}，入参：{}", reqBO.getUrl(), JSON.toJSONString(reqBO));
            spoolAbilityServiceRsp = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
            log.info("调用电商消息前置服务返回：" + spoolAbilityServiceRsp);
        } catch (Exception e) {
            log.error("调用电商消息前置服务异常" + e.getMessage());
        }

        // 如果返回结果为空，抛异常
        if (StringUtils.isEmpty(spoolAbilityServiceRsp)) {
            throw new ZTBusinessException("调用电商消息前置服务返回为空");
        }
        JSONObject resultJson = JSON.parseObject(spoolAbilityServiceRsp);
        if (!"0".equals(resultJson.getString("code"))) {
            throw new ZTBusinessException("调用电商消息前置服务返回异常: " + resultJson.getString("message"));
        }
    }


    /**
     * 消息处理后置服务
     *
     * @param reqBO
     */
    public static void spoolAfterService(DycProBaseMsgPoolAfterServiceReqBO reqBO) {
        String spoolAbilityServiceRsp = null;

        try {
            log.info("调用电商消息后置服务地址：{}，入参：{}", reqBO.getUrl(), JSON.toJSONString(reqBO));
            spoolAbilityServiceRsp = HttpUtil.post(reqBO.getUrl(), JSON.toJSONString(reqBO));
            log.info("调用电商消息后置服务返回：" + spoolAbilityServiceRsp);
        } catch (Exception e) {
            log.error("调用电商消息后置服务异常" + e.getMessage());
            throw new ZTBusinessException("调用电商消息后置服务异常" + e);
        }

        // 如果返回结果为空，抛异常
        if (StringUtils.isEmpty(spoolAbilityServiceRsp)) {
            throw new ZTBusinessException("调用电商消息后置服务返回为空");
        }
        JSONObject resultJson = JSON.parseObject(spoolAbilityServiceRsp);
        if (!"0".equals(resultJson.getString("code"))) {
            throw new ZTBusinessException("调用电商消息前置服务返回异常: " + resultJson.getString("message"));
        }
    }


}
