/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.ability.impl;

import com.tydic.cfc.ability.api.CfcPresentAddAbilityService;
import com.tydic.cfc.ability.bo.CfcPresentAddAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcPresentAddAbilityRspBO;
import com.tydic.cfc.busi.api.CfcPresentAddBusiService;
import com.tydic.cfc.busi.bo.CfcPresentAddBusiReqBO;
import com.tydic.cfc.busi.bo.CfcPresentAddBusiRspBO;
import com.tydic.cfc.exceptions.CfcBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CFC_GROUP_DEV/2.1.0/com.tydic.cfc.ability.api.CfcPresentAddAbilityService"})
public class CfcPresentAddAbilityServiceImpl
implements CfcPresentAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CfcPresentAddAbilityServiceImpl.class);
    @Autowired
    private CfcPresentAddBusiService cfcPresentAddBusiService;

    @PostMapping(value={"addPresent"})
    public CfcPresentAddAbilityRspBO addPresent(@RequestBody CfcPresentAddAbilityReqBO reqBO) {
        this.validParam(reqBO);
        CfcPresentAddBusiReqBO busiReqBO = new CfcPresentAddBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        CfcPresentAddBusiRspBO busiRspBO = this.cfcPresentAddBusiService.addPresent(busiReqBO);
        CfcPresentAddAbilityRspBO rspBO = new CfcPresentAddAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void validParam(CfcPresentAddAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new CfcBusinessException("221029", "\u8ba1\u5212\u63d0\u62a5\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPresentName())) {
            throw new CfcBusinessException("221029", "\u8ba1\u5212\u63d0\u62a5\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPresentCode())) {
            throw new CfcBusinessException("221029", "\u8ba1\u5212\u63d0\u62a5\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPresentType())) {
            throw new CfcBusinessException("221029", "\u8ba1\u5212\u63d0\u62a5\u7c7b\u578b\u4e3a\u7a7a");
        }
        if ("week".equals(reqBO.getPresentType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getPresentWeek())) {
                throw new CfcBusinessException("221029", "\u65f6\u95f4\u9650\u5236\u8303\u56f4\u6bcf\u5468\u5185\u5bb9\u4e3a\u7a7a");
            }
        } else if ("mouth".equals(reqBO.getPresentType())) {
            if (reqBO.getPresentMouthStart() == null) {
                throw new CfcBusinessException("221029", "\u65f6\u95f4\u9650\u5236\u8303\u56f4\u6bcf\u6708\u5f00\u59cb\u4e3a\u7a7a");
            }
            if (reqBO.getPresentMouthEnd() == null) {
                throw new CfcBusinessException("221029", "\u65f6\u95f4\u9650\u5236\u8303\u56f4\u6bcf\u6708\u7ed3\u675f\u4e3a\u7a7a");
            }
            if (reqBO.getPresentMouthStart() > reqBO.getPresentMouthEnd()) {
                throw new CfcBusinessException("221029", "\u65f6\u95f4\u9650\u5236\u8303\u56f4\u6bcf\u6708\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
            }
        }
    }
}

