/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.cfc.ability.api.CfcTransRollbackAbilityService;
import com.tydic.cfc.ability.bo.CfcTransRollbackReqBO;
import com.tydic.cfc.ability.bo.CfcTransRollbackRspBO;
import com.tydic.cfc.busi.api.CfcCloudProxyService;
import com.tydic.cfc.busi.api.CfcHsfProxyService;
import com.tydic.cfc.busi.bo.CfcCloudProxyServiceReqBO;
import com.tydic.cfc.busi.bo.CfcCloudProxyServiceRspBO;
import com.tydic.cfc.busi.bo.CfcHsfProxyServiceReqBO;
import com.tydic.cfc.busi.bo.CfcTransServiceDataBO;
import com.tydic.cfc.busi.bo.CfcTransactionData;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CFC_GROUP_DEV/2.1.0/com.tydic.cfc.ability.api.CfcTransRollbackAbilityService"})
public class CfcTransRollbackAbilityServiceImpl
implements CfcTransRollbackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CfcTransRollbackAbilityServiceImpl.class);
    public static final String RPC_SPRINGCLOUD = "SpringCloud";
    public static final String RPC_HSF = "HSF";
    @Value(value="${rpc.type:HSF}")
    private String rpcType;
    @Autowired
    private CfcCloudProxyService cfcCloudProxyService;
    @Autowired
    private CfcHsfProxyService cfcHsfProxyService;

    @PostMapping(value={"doRollback"})
    public CfcTransRollbackRspBO doRollback(@RequestBody CfcTransRollbackReqBO reqBO) {
        log.info("rpcType : {} ", (Object)this.rpcType);
        CfcTransRollbackRspBO rspBO = new CfcTransRollbackRspBO();
        CfcCloudProxyServiceRspBO cfcCloudProxyServiceRspBO = new CfcCloudProxyServiceRspBO();
        ArrayList<CfcTransServiceDataBO> list = new ArrayList<CfcTransServiceDataBO>();
        List cfcTransactionDataList = JSON.parseArray((String)reqBO.getTransactionInfo(), CfcTransactionData.class);
        for (CfcTransactionData bo : cfcTransactionDataList) {
            CfcTransServiceDataBO serviceDataBO = new CfcTransServiceDataBO();
            serviceDataBO.setTransId(bo.getTransactionId());
            serviceDataBO.setServiceCode(bo.getServiceCode());
            serviceDataBO.setMethodCode(bo.getMethodCode());
            serviceDataBO.setRspInfo(bo.getResponseParam());
            serviceDataBO.setRspInfo(bo.getResponseParam());
            list.add(serviceDataBO);
        }
        if (RPC_HSF.equals(this.rpcType)) {
            CfcHsfProxyServiceReqBO cfcHsfProxyServiceReqBO = new CfcHsfProxyServiceReqBO();
            cfcHsfProxyServiceReqBO.setList(list);
            this.cfcHsfProxyService.executeCallChain(cfcHsfProxyServiceReqBO);
        } else if (RPC_SPRINGCLOUD.equals(this.rpcType)) {
            CfcCloudProxyServiceReqBO cloudReqBO = new CfcCloudProxyServiceReqBO();
            cloudReqBO.setList(list);
            cfcCloudProxyServiceRspBO = this.cfcCloudProxyService.executeCallChain(cloudReqBO);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)((Object)cfcCloudProxyServiceRspBO), (Object)rspBO);
        return rspBO;
    }
}

