/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleDetailedBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSyncBO;
import com.tydic.cfc.busi.api.CfcDictionaryBusiService;
import com.tydic.cfc.busi.api.CfcEncodedRuleAddBusiService;
import com.tydic.cfc.busi.bo.CfcEncodedRuleAddBusiReqBO;
import com.tydic.cfc.busi.bo.CfcEncodedRuleAddBusiRspBO;
import com.tydic.cfc.constants.CfcCommConstant;
import com.tydic.cfc.dao.CfcEncodedGroupMapper;
import com.tydic.cfc.dao.CfcEncodedRuleDetailedMapper;
import com.tydic.cfc.dao.CfcEncodedRuleMapper;
import com.tydic.cfc.exceptions.CfcBusinessException;
import com.tydic.cfc.po.CfcEncodedGroup;
import com.tydic.cfc.po.CfcEncodedRuleDetailedPO;
import com.tydic.cfc.po.CfcEncodedRulePO;
import com.tydic.dyc.base.core.dictionary.bo.DictDataBo;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="cfcEncodedRuleAddBusiService")
public class CfcEncodedRuleAddBusiServiceImpl
implements CfcEncodedRuleAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedRuleAddBusiServiceImpl.class);
    @Autowired
    private CfcEncodedRuleMapper cfcEncodedRuleMapper;
    @Autowired
    private CfcEncodedGroupMapper cfcEncodedGroupMapper;
    @Autowired
    private CfcEncodedRuleDetailedMapper cfcEncodedRuleDetailedMapper;
    @Autowired
    private CfcDictionaryBusiService dictionaryAbilityService;

    @Override
    public CfcEncodedRuleAddBusiRspBO addEncodedRule(CfcEncodedRuleAddBusiReqBO reqBO) {
        CfcEncodedRuleBO cfcEncodedRuleBO = new CfcEncodedRuleBO();
        cfcEncodedRuleBO.setEncodedRuleCode(reqBO.getEncodedRuleCode());
        List<CfcEncodedRulePO> list = this.cfcEncodedRuleMapper.getList(cfcEncodedRuleBO);
        if (list != null && list.size() > 0) {
            throw new CfcBusinessException("223009", "\u5df2\u5b58\u5728\u5bf9\u5e94\u7f16\u7801\u89c4\u5219");
        }
        CfcEncodedGroup cfcEncodedGroup = this.cfcEncodedGroupMapper.selectByPrimaryKey(reqBO.getGroupId());
        if (cfcEncodedGroup == null) {
            throw new CfcBusinessException("223009", "\u672a\u627e\u5230\u5bf9\u5e94\u5206\u7ec4\u4fe1\u606f");
        }
        List replaceTypeList = DictFrameworkUtils.getListByCenterAndPCode((String)"UMC_PLUS", (String)"ENCODED_RULE_DETAILED_REPLACE_TYPE");
        Map<String, String> replaceType = null;
        if (!CollectionUtils.isEmpty((Collection)replaceTypeList)) {
            replaceType = replaceTypeList.stream().collect(Collectors.toMap(DictDataBo::getCode, DictDataBo::getValue));
        }
        List busiTypeList = DictFrameworkUtils.getListByCenterAndPCode((String)"UMC_PLUS", (String)"ENCODED_RULE_BUSI_TYPE");
        Map<String, String> busiTypeMap = null;
        if (!CollectionUtils.isEmpty((Collection)busiTypeList)) {
            busiTypeMap = busiTypeList.stream().collect(Collectors.toMap(DictDataBo::getCode, DictDataBo::getValue));
        }
        CfcEncodedRulePO cfcEncodedRulePO = new CfcEncodedRulePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)cfcEncodedRulePO);
        cfcEncodedRulePO.setId(Sequence.getInstance().nextId());
        cfcEncodedRulePO.setClassId(cfcEncodedGroup.getClassId());
        cfcEncodedRulePO.setClassName(cfcEncodedGroup.getClassName());
        cfcEncodedRulePO.setGroupId(cfcEncodedGroup.getId());
        cfcEncodedRulePO.setGroupName(cfcEncodedGroup.getGroupName());
        cfcEncodedRulePO.setEncodedRuleType("2");
        cfcEncodedRulePO.setOperateNo(reqBO.getMemIdIn());
        cfcEncodedRulePO.setOperateName(reqBO.getName());
        cfcEncodedRulePO.setOperateTime(new Date());
        String encodedRuleStyle = "";
        ArrayList<CfcEncodedRuleDetailedPO> cfcEncodedRuleDetailedPOS = new ArrayList<CfcEncodedRuleDetailedPO>();
        Integer encodeEffCode = CfcCommConstant.EncodeEffFlag.NONE.getCode();
        if (reqBO.getDetaileds() != null && reqBO.getDetaileds().size() > 0) {
            int orderId = 1;
            for (CfcEncodedRuleDetailedBO itemBO : reqBO.getDetaileds()) {
                CfcEncodedRuleDetailedPO cfcEncodedRuleDetailedPO = new CfcEncodedRuleDetailedPO();
                itemBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                itemBO.setEncodedRuleId(cfcEncodedRulePO.getId());
                itemBO.setOrderId(Integer.valueOf(orderId));
                ++orderId;
                if ("text".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedContent();
                } else if ("year".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + "2021";
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.YEAR.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.YEAR.getCode();
                } else if ("month".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + "01";
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.MONTH.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.MONTH.getCode();
                } else if ("day".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + "01";
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.DAY.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.DAY.getCode();
                } else if ("date".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + "20210101";
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.DATE.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.DATE.getCode();
                } else if ("replace".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedStyle();
                } else if ("serial".equals(itemBO.getDetailedType())) {
                    int serial;
                    if (StringUtils.isEmpty((Object)itemBO.getDetailedType())) {
                        itemBO.setDetailedType("4");
                    }
                    if ((serial = Integer.parseInt(itemBO.getDetailedContent())) > 0) {
                        for (int i = 1; i < serial; ++i) {
                            encodedRuleStyle = encodedRuleStyle + "0";
                        }
                        encodedRuleStyle = encodedRuleStyle + "1";
                    }
                } else if ("busiType".equals(itemBO.getDetailedType())) {
                    if (!CollectionUtils.isEmpty(busiTypeMap)) {
                        encodedRuleStyle = encodedRuleStyle + busiTypeMap.get(itemBO.getDetailedContent());
                        itemBO.setDetailedContent(busiTypeMap.get(itemBO.getDetailedType()));
                    }
                } else if (replaceType != null && replaceType.containsKey(itemBO.getDetailedType())) {
                    itemBO.setDetailedStyle(itemBO.getDetailedContent());
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedContent();
                }
                BeanUtils.copyProperties((Object)itemBO, (Object)cfcEncodedRuleDetailedPO);
                cfcEncodedRuleDetailedPOS.add(cfcEncodedRuleDetailedPO);
            }
        }
        cfcEncodedRulePO.setEffType(CfcCommConstant.EncodeEffFlag.getValueByCode((Integer)encodeEffCode));
        if (!StringUtils.isEmpty((Object)reqBO.getEncodedRuleStyle())) {
            cfcEncodedRulePO.setEncodedRuleStyle(reqBO.getEncodedRuleStyle());
        } else {
            cfcEncodedRulePO.setEncodedRuleStyle(encodedRuleStyle);
        }
        int insert = this.cfcEncodedRuleMapper.insert(cfcEncodedRulePO);
        if (insert < 1) {
            throw new CfcBusinessException("223009", "\u7f16\u7801\u89c4\u5219\u65b0\u589e\u5931\u8d25");
        }
        if (cfcEncodedRuleDetailedPOS.size() > 0 && (insert = this.cfcEncodedRuleDetailedMapper.insertBatch(cfcEncodedRuleDetailedPOS)) < 1) {
            throw new CfcBusinessException("223009", "\u7f16\u7801\u89c4\u5219\u660e\u7ec6\u65b0\u589e\u5931\u8d25");
        }
        CfcEncodedRuleSyncBO syncBO = new CfcEncodedRuleSyncBO();
        syncBO.setId(cfcEncodedRuleBO.getId());
        syncBO.setRestartFlag(cfcEncodedRuleBO.getRestartFlag());
        ArrayList<CfcEncodedRuleSyncBO> syncBOS = new ArrayList<CfcEncodedRuleSyncBO>();
        syncBOS.add(syncBO);
        CfcEncodedRuleAddBusiRspBO rspBO = new CfcEncodedRuleAddBusiRspBO();
        rspBO.setSyncBOLIst(syncBOS);
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

