/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.commodity.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckObjEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckSenceEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuInfoOnShelveWay;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrSkuCreateService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuCreateReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuCreateRspBO;
import com.tydic.dycpro.saas.commodity.skumanage.api.DycProSaasCommAgrSkuCreateService;
import com.tydic.dycpro.saas.commodity.skumanage.bo.DycProSaasCommAgrSkuCreateReqBO;
import com.tydic.dycpro.saas.commodity.skumanage.bo.DycProSaasCommAgrSkuCreateRspBO;
import com.tydic.dycpro.saas.mq.bo.DycProSaasCommDealSkuMsgForCheckParamBO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.commodity.skumanage.api.DycProSaasCommAgrSkuCreateService"})
public class DycProSaasCommAgrSkuCreateServiceImpl
implements DycProSaasCommAgrSkuCreateService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasCommAgrSkuCreateServiceImpl.class);
    @Autowired
    private DycProCommAgrSkuCreateService dycProCommAgrSkuCreateService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Value(value="${ucc.approve.onShelve.agreement.switch:true}")
    private Boolean uccApproveOnShelveAgreementSwitch;
    @Value(value="${ucc.approve.onShelve.agreement.key:}")
    private String uccApproveOnShelveAgreementKey;
    @Value(value="${is.need.image-text.check}")
    private String isNeedImageTextCheck;
    @Value(value="${comm.checkrule.topic}")
    private String commCheckRuleTopic;
    @Value(value="${comm.checkrule.tag}")
    private String commCheckRuleTag;
    @Resource(name="dycProCmmCheckRuleMqServiceProvider")
    private ProxyMessageProducer dycProCmmCheckRuleMqServiceProvider;

    @Override
    @PostMapping(value={"createAgrSku"})
    public DycProSaasCommAgrSkuCreateRspBO createAgrSku(@RequestBody DycProSaasCommAgrSkuCreateReqBO reqBO) {
        DycProCommAgrSkuCreateReqBO dycProCommAgrSkuCreateReqBO = (DycProCommAgrSkuCreateReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProCommAgrSkuCreateReqBO.class);
        dycProCommAgrSkuCreateReqBO.setUccApproveOnShelveAgreementSwitch(this.uccApproveOnShelveAgreementSwitch);
        log.info("\u534f\u8bae\u5546\u54c1\u521b\u5efa\u670d\u52a1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dycProCommAgrSkuCreateReqBO));
        DycProCommAgrSkuCreateRspBO dycProCommAgrSkuCreateRspBO = this.dycProCommAgrSkuCreateService.createAgrSku(dycProCommAgrSkuCreateReqBO);
        log.info("\u534f\u8bae\u5546\u54c1\u521b\u5efa\u670d\u52a1\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)dycProCommAgrSkuCreateRspBO));
        if (!"0000".equals(dycProCommAgrSkuCreateRspBO.getRespCode())) {
            throw new ZTBusinessException(dycProCommAgrSkuCreateRspBO.getRespDesc());
        }
        if (reqBO.getOperType() == 1) {
            if (this.uccApproveOnShelveAgreementSwitch.booleanValue() && reqBO.getCreateSkuInfo().getOnShelveWay().equals(Integer.parseInt(DmcCommSkuInfoOnShelveWay.AUTO.getCode()))) {
                this.startApprovalFlow(reqBO, dycProCommAgrSkuCreateRspBO);
            }
            this.pushSkuCheck(reqBO, dycProCommAgrSkuCreateRspBO.getSkuId());
        }
        return new DycProSaasCommAgrSkuCreateRspBO();
    }

    private void startApprovalFlow(DycProSaasCommAgrSkuCreateReqBO reqBO, DycProCommAgrSkuCreateRspBO dycProCommAgrSkuCreateRspBO) {
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO;
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(this.uccApproveOnShelveAgreementKey);
        ArrayList<String> businessIdList = new ArrayList<String>();
        businessIdList.add(dycProCommAgrSkuCreateRspBO.getAuditPackageId().toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(businessIdList);
        eacStartProjectAbilityReqBO.setOrgId(reqBO.getOrgId().toString());
        eacStartProjectAbilityReqBO.setOrgName(reqBO.getOrgName());
        eacStartProjectAbilityReqBO.setUserId(reqBO.getUserId().toString());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("auditResult", "pass");
        variables.put("auditPackageId", dycProCommAgrSkuCreateRspBO.getAuditPackageId());
        eacStartProjectAbilityReqBO.setVariables(variables);
        try {
            log.info("\u5546\u54c1\u4e0a\u67b6\u542f\u52a8\u5ba1\u6279\u6d41\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
            eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u5546\u54c1\u4e0a\u67b6\u542f\u52a8\u5ba1\u6279\u6d41\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u4e0a\u67b6\u542f\u52a8\u5ba1\u6279\u6d41\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e);
            throw new ZTBusinessException("\u5546\u54c1\u4e0a\u67b6\u542f\u52a8\u5ba1\u6279\u6d41\u5f02\u5e38");
        }
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5546\u54c1\u4e0a\u67b6\u542f\u52a8\u5ba1\u6279\u6d41\u5931\u8d25\uff0c\u8fd4\u56de\u7f16\u7801:" + eacStartProjectAbilityRspBO.getRespCode() + " , \u5931\u8d25\u539f\u56e0:" + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }

    private void pushSkuCheck(DycProSaasCommAgrSkuCreateReqBO reqBO, Long skuId) {
        if ("YES".equals(this.isNeedImageTextCheck)) {
            DycProSaasCommDealSkuMsgForCheckParamBO checkParamBO = (DycProSaasCommDealSkuMsgForCheckParamBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSaasCommDealSkuMsgForCheckParamBO.class);
            checkParamBO.setCheckObjId(skuId);
            checkParamBO.setCheckObjType(Integer.parseInt(DmcCommCheckObjEnum.AGR_GOODS.getCode()));
            checkParamBO.setCheckSceneCode(DmcCommCheckSenceEnum.ADD_GOODS.getCode());
            checkParamBO.setCheckRuleType(Integer.parseInt(DmcCommCheckRuleTypeEnum.IMAGE_CHECK.getCode()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)"addCheckRecord");
            jsonObject.put("execCheckRuleParamBO", (Object)checkParamBO);
            this.dycProCmmCheckRuleMqServiceProvider.send(new ProxyMessage(this.commCheckRuleTopic, this.commCheckRuleTag, jsonObject.toJSONString()));
        }
    }
}

