/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.commodity.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckObjEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckSenceEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrSkuUpdateService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuUpdateReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuUpdateRspBO;
import com.tydic.dycpro.saas.commodity.skumanage.api.DycProSaasCommAgrSkuUpdateService;
import com.tydic.dycpro.saas.commodity.skumanage.bo.DycProSaasCommAgrSkuUpdateReqBO;
import com.tydic.dycpro.saas.commodity.skumanage.bo.DycProSaasCommAgrSkuUpdateRspBO;
import com.tydic.dycpro.saas.mq.bo.DycProSaasCommDealSkuMsgForCheckParamBO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.commodity.skumanage.api.DycProSaasCommAgrSkuUpdateService"})
public class DycProSaasCommAgrSkuUpdateServiceImpl
implements DycProSaasCommAgrSkuUpdateService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasCommAgrSkuUpdateServiceImpl.class);
    @Autowired
    private DycProCommAgrSkuUpdateService dycProCommAgrSkuUpdateService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Value(value="${ucc.approve.onShelve.agreement.switch:true}")
    private Boolean uccApproveOnShelveAgreementSwitch;
    @Value(value="${ucc.approve.onShelve.agreement.key:}")
    private String uccApproveOnShelveAgreementKey;
    @Value(value="${ucc.approve.edit.agreement.switch:true}")
    private Boolean uccApproveEditAgreementSwitch;
    @Value(value="${ucc.approve.edit.agreement.key:}")
    private String uccApproveEditAgreementKey;
    @Value(value="${is.need.image-text.check}")
    private String isNeedImageTextCheck;
    @Value(value="${comm.checkrule.topic}")
    private String commCheckRuleTopic;
    @Value(value="${comm.checkrule.tag}")
    private String commCheckRuleTag;
    @Resource(name="dycProCmmCheckRuleMqServiceProvider")
    private ProxyMessageProducer dycProCmmCheckRuleMqServiceProvider;

    @Override
    @PostMapping(value={"updateAgrSku"})
    public DycProSaasCommAgrSkuUpdateRspBO updateAgrSku(@RequestBody DycProSaasCommAgrSkuUpdateReqBO reqBO) {
        this.judge(reqBO);
        DycProCommAgrSkuUpdateReqBO dycProCommAgrSkuUpdateReqBO = (DycProCommAgrSkuUpdateReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProCommAgrSkuUpdateReqBO.class);
        dycProCommAgrSkuUpdateReqBO.setUccApproveOnShelveAgreementSwitch(this.uccApproveOnShelveAgreementSwitch);
        dycProCommAgrSkuUpdateReqBO.setUccApproveEditAgreementSwitch(this.uccApproveEditAgreementSwitch);
        log.info("\u534f\u8bae\u5546\u54c1\u4fee\u6539\u670d\u52a1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dycProCommAgrSkuUpdateReqBO));
        DycProCommAgrSkuUpdateRspBO dycProCommAgrSkuUpdateRspBO = this.dycProCommAgrSkuUpdateService.updateAgrSku(dycProCommAgrSkuUpdateReqBO);
        log.info("\u534f\u8bae\u5546\u54c1\u4fee\u6539\u670d\u52a1\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)dycProCommAgrSkuUpdateRspBO));
        if (!"0000".equals(dycProCommAgrSkuUpdateRspBO.getRespCode())) {
            throw new ZTBusinessException(dycProCommAgrSkuUpdateRspBO.getRespDesc());
        }
        if (reqBO.getOperType() == 1) {
            if (PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode().equals(dycProCommAgrSkuUpdateRspBO.getBusiType())) {
                this.startApprovalFlow(reqBO, dycProCommAgrSkuUpdateRspBO, this.uccApproveOnShelveAgreementKey);
            } else if (PublicProcInstBusiType.AGR_SKU_EDIT_APPROVE.getCode().equals(dycProCommAgrSkuUpdateRspBO.getBusiType())) {
                this.startApprovalFlow(reqBO, dycProCommAgrSkuUpdateRspBO, this.uccApproveEditAgreementKey);
            }
            if (!PublicProcInstBusiType.AGR_SKU_EDIT_APPROVE.getCode().equals(dycProCommAgrSkuUpdateRspBO.getBusiType())) {
                this.pushSkuCheck(reqBO, reqBO.getUpdateSkuInfo().getSkuId());
            }
        }
        return new DycProSaasCommAgrSkuUpdateRspBO();
    }

    private void startApprovalFlow(DycProSaasCommAgrSkuUpdateReqBO reqBO, DycProCommAgrSkuUpdateRspBO dycProCommAgrSkuUpdateRspBO, String procDefKey) {
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO;
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(procDefKey);
        ArrayList<String> businessIdList = new ArrayList<String>();
        businessIdList.add(dycProCommAgrSkuUpdateRspBO.getAuditPackageId().toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(businessIdList);
        eacStartProjectAbilityReqBO.setOrgId(reqBO.getOrgId().toString());
        eacStartProjectAbilityReqBO.setOrgName(reqBO.getOrgName());
        eacStartProjectAbilityReqBO.setUserId(reqBO.getUserId().toString());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("auditResult", "pass");
        variables.put("auditPackageId", dycProCommAgrSkuUpdateRspBO.getAuditPackageId());
        eacStartProjectAbilityReqBO.setVariables(variables);
        try {
            log.info("\u534f\u8bae\u5546\u54c1\u542f\u52a8\u5ba1\u6279\u6d41\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
            eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u534f\u8bae\u5546\u54c1\u542f\u52a8\u5ba1\u6279\u6d41\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        }
        catch (Exception e) {
            log.error("\u534f\u8bae\u5546\u54c1\u542f\u52a8\u5ba1\u6279\u6d41\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e);
            throw new ZTBusinessException("\u534f\u8bae\u5546\u54c1\u542f\u52a8\u5ba1\u6279\u6d41\u5f02\u5e38");
        }
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u5546\u54c1\u542f\u52a8\u5ba1\u6279\u6d41\u5931\u8d25\uff0c\u8fd4\u56de\u7f16\u7801:" + eacStartProjectAbilityRspBO.getRespCode() + " , \u5931\u8d25\u539f\u56e0:" + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }

    private void pushSkuCheck(DycProSaasCommAgrSkuUpdateReqBO reqBO, Long skuId) {
        if ("YES".equals(this.isNeedImageTextCheck)) {
            DycProSaasCommDealSkuMsgForCheckParamBO checkParamBO = (DycProSaasCommDealSkuMsgForCheckParamBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSaasCommDealSkuMsgForCheckParamBO.class);
            checkParamBO.setCheckObjId(skuId);
            checkParamBO.setCheckObjType(Integer.parseInt(DmcCommCheckObjEnum.AGR_GOODS.getCode()));
            checkParamBO.setCheckSceneCode(DmcCommCheckSenceEnum.ADD_GOODS.getCode());
            checkParamBO.setCheckRuleType(Integer.parseInt(DmcCommCheckRuleTypeEnum.IMAGE_CHECK.getCode()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)"addCheckRecord");
            jsonObject.put("execCheckRuleParamBO", (Object)checkParamBO);
            this.dycProCmmCheckRuleMqServiceProvider.send(new ProxyMessage(this.commCheckRuleTopic, this.commCheckRuleTag, jsonObject.toJSONString()));
        }
    }

    private void judge(DycProSaasCommAgrSkuUpdateReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getUpdateSkuInfo())) {
            throw new ZTBusinessException("\u3010sku\u4fee\u6539\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

