/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.dictionary.enums.BooleanFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DelFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.EnableFlag;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.dao.AgrApplicationScopeMapper;
import com.tydic.dyc.pro.dmc.dao.AgrCooperationCatalogMapper;
import com.tydic.dyc.pro.dmc.dao.AgrFileInfoMapper;
import com.tydic.dyc.pro.dmc.dao.AgrItemMapper;
import com.tydic.dyc.pro.dmc.dao.AgrMainMapper;
import com.tydic.dyc.pro.dmc.dao.CommBansRecordMapper;
import com.tydic.dyc.pro.dmc.dao.CommManageCatalogInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommMaterialClassifyMapper;
import com.tydic.dyc.pro.dmc.dao.CommMaterialInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommMeasureInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.po.AgrApplicationScopePO;
import com.tydic.dyc.pro.dmc.po.AgrCooperationCatalogPO;
import com.tydic.dyc.pro.dmc.po.AgrFileInfoPO;
import com.tydic.dyc.pro.dmc.po.AgrItemPO;
import com.tydic.dyc.pro.dmc.po.AgrMainPO;
import com.tydic.dyc.pro.dmc.po.AgrMainQryPO;
import com.tydic.dyc.pro.dmc.po.CommBansRecordPO;
import com.tydic.dyc.pro.dmc.po.CommManageCatalogInfoPO;
import com.tydic.dyc.pro.dmc.po.CommMaterialClassifyPO;
import com.tydic.dyc.pro.dmc.po.CommMaterialClassifyQryAllTreePO;
import com.tydic.dyc.pro.dmc.po.CommMaterialInfoPO;
import com.tydic.dyc.pro.dmc.po.CommMeasureInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuInfoPO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrApplicationScopeDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrCooperationCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrFileInfoDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemHandleDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemImportJudgeDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainHandleDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrSkuDTO;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

@Service
public class DycProAgrRepositoryImpl
implements DycProAgrRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProAgrRepositoryImpl.class);
    @Autowired
    private AgrMainMapper agrMainMapper;
    @Autowired
    private AgrCooperationCatalogMapper agrCooperationCatalogMapper;
    @Autowired
    private AgrApplicationScopeMapper agrApplicationScopeMapper;
    @Autowired
    private AgrFileInfoMapper agrFileInfoMapper;
    @Autowired
    private AgrItemMapper agrItemMapper;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Autowired
    private CommMaterialInfoMapper materialInfoMapper;
    @Autowired
    private CommManageCatalogInfoMapper commManageCatalogInfoMapper;
    @Autowired
    private CommMaterialClassifyMapper materialClassifyMapper;
    @Autowired
    private CommMeasureInfoMapper measureInfoMapper;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;
    @Autowired
    private CommBansRecordMapper commBansRecordMapper;

    @Override
    public DycProAgrMainDTO createAgrMain(DycProAgrMainDTO dycProAgrMainDTO) {
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrSrc())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u6765\u6e90\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dycProAgrMainDTO.setAgrObjPrimaryId(Sequence.getInstance().nextId());
        dycProAgrMainDTO.setAgrId(Sequence.getInstance().nextId());
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("AGR");
        encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_RULE_CODE");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        dycProAgrMainDTO.setAgrCode((String)encode.getSerialNoList().get(0));
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrVersion())) {
            dycProAgrMainDTO.setAgrVersion(1);
        }
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrStatus())) {
            dycProAgrMainDTO.setAgrStatus(DycProAgrConstants.AgrStatus.DRAFT);
        }
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getAgrVersionFormWay())) {
            dycProAgrMainDTO.setAgrVersionFormWay(DycProAgrConstants.AgrVersionFormWay.ORIGINAL);
        }
        if (ObjectUtils.isEmpty((Object)dycProAgrMainDTO.getDelFlag())) {
            dycProAgrMainDTO.setDelFlag(DycProAgrConstants.AgrDelFlag.UN_DELETE);
        }
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProAgrMainDTO), AgrMainPO.class);
        this.agrMainMapper.insert((Object)agrMainPO);
        if (DycProAgrConstants.AgrBooleanFlag.YES.equals(dycProAgrMainDTO.getWhetherManageCatalog()) && !CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrCooperationCatalogList())) {
            for (DycProAgrCooperationCatalogDTO dycProAgrCooperationCatalogDTO : dycProAgrMainDTO.getAgrCooperationCatalogList()) {
                dycProAgrCooperationCatalogDTO.setAgrCooperationCatalogId(Sequence.getInstance().nextId());
                dycProAgrCooperationCatalogDTO.setAgrObjPrimaryId(agrMainPO.getAgrObjPrimaryId());
                dycProAgrCooperationCatalogDTO.setAgrId(agrMainPO.getAgrId());
            }
            List catalogPOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrCooperationCatalogList()), AgrCooperationCatalogPO.class);
            this.agrCooperationCatalogMapper.insertBatch((Collection)catalogPOS);
        }
        this.dealScopList(dycProAgrMainDTO, agrMainPO.getAgrObjPrimaryId(), agrMainPO.getAgrId(), agrMainPO);
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrFileInfoList())) {
            for (DycProAgrFileInfoDTO dycProAgrFileInfoDTO : dycProAgrMainDTO.getAgrFileInfoList()) {
                dycProAgrFileInfoDTO.setAgrFileId(Sequence.getInstance().nextId());
                dycProAgrFileInfoDTO.setObjId(agrMainPO.getAgrObjPrimaryId());
                dycProAgrFileInfoDTO.setObjType(DycProAgrConstants.AgrFilObjType.AGR_MAIN);
            }
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrFileInfoList()), AgrFileInfoPO.class);
            this.agrFileInfoMapper.insertBatch((Collection)fileInfoPOS);
        }
        return dycProAgrMainDTO;
    }

    private void dealScopList(DycProAgrMainDTO dycProAgrMainDTO, Long agrObjPrimaryId, Long agrId, AgrMainPO agrMainPO) {
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getPurScopeList())) {
            if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrApplicationScopeList())) {
                dycProAgrMainDTO.getAgrApplicationScopeList().addAll(dycProAgrMainDTO.getPurScopeList());
            } else {
                dycProAgrMainDTO.setAgrApplicationScopeList(dycProAgrMainDTO.getPurScopeList());
            }
        }
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getViewScopeList())) {
            if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrApplicationScopeList())) {
                dycProAgrMainDTO.getAgrApplicationScopeList().addAll(dycProAgrMainDTO.getViewScopeList());
            } else {
                dycProAgrMainDTO.setAgrApplicationScopeList(dycProAgrMainDTO.getViewScopeList());
            }
        }
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrApplicationScopeList())) {
            for (DycProAgrApplicationScopeDTO each : dycProAgrMainDTO.getAgrApplicationScopeList()) {
                each.setApplicationScopeId(Sequence.getInstance().nextId());
                each.setAgrObjPrimaryId(agrObjPrimaryId);
                each.setAgrId(agrId);
            }
            List scopePOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrApplicationScopeList()), AgrApplicationScopePO.class);
            this.agrApplicationScopeMapper.insertBatch((Collection)scopePOS);
        }
    }

    @Override
    public DycProAgrMainDTO getAgrDetail(DycProAgrMainQryDTO qryDTO) {
        AgrMainPO agrMainPO;
        if (qryDTO == null) {
            throw new ZTBusinessException("\u534f\u8bae\u8be6\u60c5\u67e5\u8be2 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        LambdaQueryWrapper mainQryWrapper = new LambdaQueryWrapper();
        mainQryWrapper.eq(!ObjectUtils.isEmpty((Object)qryDTO.getAgrObjPrimaryId()), AgrMainPO::getAgrObjPrimaryId, (Object)qryDTO.getAgrObjPrimaryId());
        mainQryWrapper.eq(!ObjectUtils.isEmpty((Object)qryDTO.getAgrId()), AgrMainPO::getAgrId, (Object)qryDTO.getAgrId());
        mainQryWrapper.eq(!ObjectUtils.isEmpty((Object)qryDTO.getAgrCode()), AgrMainPO::getAgrCode, (Object)qryDTO.getAgrCode());
        mainQryWrapper.eq(!ObjectUtils.isEmpty((Object)qryDTO.getAgrVersion()), AgrMainPO::getAgrVersion, (Object)qryDTO.getAgrVersion());
        if (qryDTO.getAgrId() != null && qryDTO.getAgrVersion() == null && qryDTO.getAgrObjPrimaryId() == null) {
            mainQryWrapper.ne(AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()));
        }
        if ((agrMainPO = (AgrMainPO)this.agrMainMapper.selectOne((Wrapper)mainQryWrapper)) == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u8be6\u60c5");
        }
        DycProAgrMainDTO agrDetail = (DycProAgrMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrMainPO), DycProAgrMainDTO.class);
        if (qryDTO.getQryManageCatalogFlag().booleanValue() && DycProAgrConstants.AgrBooleanFlag.YES.equals(agrDetail.getWhetherManageCatalog())) {
            LambdaQueryWrapper catalogQryWrapper = new LambdaQueryWrapper();
            catalogQryWrapper.eq(AgrCooperationCatalogPO::getAgrObjPrimaryId, (Object)agrDetail.getAgrObjPrimaryId());
            List agrCooperationCatalogPOS = this.agrCooperationCatalogMapper.selectList((Wrapper)catalogQryWrapper);
            if (!CollectionUtils.isEmpty((Collection)agrCooperationCatalogPOS)) {
                agrDetail.setAgrCooperationCatalogList(JSON.parseArray((String)JSON.toJSONString((Object)agrCooperationCatalogPOS), DycProAgrCooperationCatalogDTO.class));
            }
        }
        if (qryDTO.getQryScopeFlag().booleanValue()) {
            LambdaQueryWrapper scopePOQueryWrapper = new LambdaQueryWrapper();
            scopePOQueryWrapper.eq(AgrApplicationScopePO::getAgrObjPrimaryId, (Object)agrDetail.getAgrObjPrimaryId());
            List scopePOS = this.agrApplicationScopeMapper.selectList((Wrapper)scopePOQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)scopePOS)) {
                agrDetail.setAgrApplicationScopeList(JSON.parseArray((String)JSON.toJSONString((Object)scopePOS), DycProAgrApplicationScopeDTO.class));
                List applicationScopeDTOS = JSON.parseArray((String)JSON.toJSONString((Object)scopePOS), DycProAgrApplicationScopeDTO.class);
                agrDetail.setPurScopeList(applicationScopeDTOS.stream().filter(e -> DycProAgrConstants.AgrScopeApplicationType.PUR_SCOPE.equals(e.getApplicationType())).collect(Collectors.toList()));
                agrDetail.setViewScopeList(applicationScopeDTOS.stream().filter(e -> DycProAgrConstants.AgrScopeApplicationType.VIEW_SCOPE.equals(e.getApplicationType())).collect(Collectors.toList()));
            }
        }
        LambdaQueryWrapper fileQueryWrapper = new LambdaQueryWrapper();
        fileQueryWrapper.eq(AgrFileInfoPO::getObjId, (Object)agrDetail.getAgrObjPrimaryId());
        fileQueryWrapper.eq(AgrFileInfoPO::getObjType, (Object)DycProAgrConstants.AgrFilObjType.AGR_MAIN);
        List fileInfoPOS = this.agrFileInfoMapper.selectList((Wrapper)fileQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)fileInfoPOS)) {
            agrDetail.setAgrFileInfoList(JSON.parseArray((String)JSON.toJSONString((Object)fileInfoPOS), DycProAgrFileInfoDTO.class));
        }
        return agrDetail;
    }

    @Override
    public void updateAgrMain(DycProAgrMainDTO dycProAgrMainDTO) {
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProAgrMainDTO), AgrMainPO.class);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(AgrMainPO::getAgrObjPrimaryId, (Object)agrMainPO.getAgrObjPrimaryId());
        updateWrapper.set(AgrMainPO::getEnAgrCode, (Object)agrMainPO.getEnAgrCode());
        updateWrapper.set(AgrMainPO::getRemark, (Object)agrMainPO.getRemark());
        if (agrMainPO.getViewScopeType() == null) {
            agrMainPO.setViewScopeType(agrMainPO.getPurScopeType());
        }
        this.agrMainMapper.update((Object)agrMainPO, (Wrapper)updateWrapper);
        LambdaQueryWrapper deleteCatalogWrapper = new LambdaQueryWrapper();
        deleteCatalogWrapper.eq(AgrCooperationCatalogPO::getAgrObjPrimaryId, (Object)dycProAgrMainDTO.getAgrObjPrimaryId());
        this.agrCooperationCatalogMapper.delete((Wrapper)deleteCatalogWrapper);
        if (DycProAgrConstants.AgrBooleanFlag.YES.equals(dycProAgrMainDTO.getWhetherManageCatalog()) && !CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrCooperationCatalogList())) {
            for (DycProAgrCooperationCatalogDTO each : dycProAgrMainDTO.getAgrCooperationCatalogList()) {
                each.setAgrCooperationCatalogId(Sequence.getInstance().nextId());
                each.setAgrObjPrimaryId(dycProAgrMainDTO.getAgrObjPrimaryId());
                each.setAgrId(dycProAgrMainDTO.getAgrId());
            }
            List catalogPOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrCooperationCatalogList()), AgrCooperationCatalogPO.class);
            this.agrCooperationCatalogMapper.insertBatch((Collection)catalogPOS);
        }
        LambdaQueryWrapper deleteScopeWrapper = new LambdaQueryWrapper();
        deleteScopeWrapper.eq(AgrApplicationScopePO::getAgrObjPrimaryId, (Object)dycProAgrMainDTO.getAgrObjPrimaryId());
        this.agrApplicationScopeMapper.delete((Wrapper)deleteScopeWrapper);
        this.dealScopList(dycProAgrMainDTO, dycProAgrMainDTO.getAgrObjPrimaryId(), dycProAgrMainDTO.getAgrId(), agrMainPO);
        LambdaQueryWrapper deleteFileWrapper = new LambdaQueryWrapper();
        deleteFileWrapper.eq(AgrFileInfoPO::getObjId, (Object)dycProAgrMainDTO.getAgrObjPrimaryId());
        deleteFileWrapper.eq(AgrFileInfoPO::getObjType, (Object)DycProAgrConstants.AgrFilObjType.AGR_MAIN);
        this.agrFileInfoMapper.delete((Wrapper)deleteFileWrapper);
        if (!CollectionUtils.isEmpty(dycProAgrMainDTO.getAgrFileInfoList())) {
            for (DycProAgrFileInfoDTO each : dycProAgrMainDTO.getAgrFileInfoList()) {
                each.setAgrFileId(Sequence.getInstance().nextId());
                each.setObjId(dycProAgrMainDTO.getAgrObjPrimaryId());
                each.setObjType(DycProAgrConstants.AgrFilObjType.AGR_MAIN);
            }
            List fileInfoPOS = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTO.getAgrFileInfoList()), AgrFileInfoPO.class);
            this.agrFileInfoMapper.insertBatch((Collection)fileInfoPOS);
        }
        if (new Integer(BooleanFlag.NO.getCode()).equals(dycProAgrMainDTO.getWhetherHaveItem())) {
            this.deleteAgrItem(dycProAgrMainDTO.getAgrObjPrimaryId(), null);
        }
    }

    @Override
    public void updateAgrMainByIds(List<DycProAgrMainDTO> dycProAgrMainDTOList) {
        if (CollectionUtils.isEmpty(dycProAgrMainDTOList)) {
            throw new ZTBusinessException("\u534f\u8bae\u4e3b\u4f53\u66f4\u65b0 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        dycProAgrMainDTOList.forEach(e -> {
            if (ObjectUtils.isEmpty((Object)e.getAgrObjPrimaryId())) {
                throw new ZTBusinessException("\u534f\u8bae\u5bf9\u8c61\u552f\u4e00ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        List updateArrayList = JSON.parseArray((String)JSON.toJSONString(dycProAgrMainDTOList), AgrMainPO.class);
        this.agrMainMapper.updateBatchByIds((Collection)updateArrayList);
    }

    @Override
    public List<DycProAgrMainDTO> selectAgrMainList(DycProAgrListQryDTO agrListQryDTO) {
        List<DycProAgrMainDTO> agrMainDTOS = new ArrayList<DycProAgrMainDTO>();
        AgrMainPO qryPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)agrListQryDTO), AgrMainPO.class);
        QueryWrapper qryWrapper = new QueryWrapper((Object)qryPO);
        qryWrapper.lambda().ne(agrListQryDTO.getHistoryFlag() == false, AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()));
        qryWrapper.lambda().in(!CollectionUtils.isEmpty(agrListQryDTO.getAgrStatusList()), AgrMainPO::getAgrStatus, agrListQryDTO.getAgrStatusList());
        qryWrapper.lambda().ge(!ObjectUtils.isEmpty((Object)agrListQryDTO.getEffDateStart()), AgrMainPO::getEffDate, (Object)agrListQryDTO.getEffDateStart());
        qryWrapper.lambda().le(!ObjectUtils.isEmpty((Object)agrListQryDTO.getEffDateEnd()), AgrMainPO::getEffDate, (Object)agrListQryDTO.getEffDateEnd());
        qryWrapper.lambda().ge(!ObjectUtils.isEmpty((Object)agrListQryDTO.getExpDateStart()), AgrMainPO::getExpDate, (Object)agrListQryDTO.getExpDateStart());
        qryWrapper.lambda().le(!ObjectUtils.isEmpty((Object)agrListQryDTO.getExpDateEnd()), AgrMainPO::getExpDate, (Object)agrListQryDTO.getExpDateEnd());
        List agrMainPOS = this.agrMainMapper.selectList((Wrapper)qryWrapper);
        if (!CollectionUtils.isEmpty((Collection)agrMainPOS)) {
            agrMainDTOS = JSON.parseArray((String)JSON.toJSONString((Object)agrMainPOS), DycProAgrMainDTO.class);
        }
        return agrMainDTOS;
    }

    @Override
    public RspPage<DycProAgrMainDTO> selectAgrMainListPage(DycProAgrListQryDTO agrListQryDTO) {
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)agrListQryDTO), AgrMainPO.class);
        agrMainPO.setAgrName(null);
        agrMainPO.setAgrCode(null);
        agrMainPO.setEnAgrCode(null);
        agrMainPO.setSupplierName(null);
        Page page = new Page((long)agrListQryDTO.getPageNo().intValue(), (long)agrListQryDTO.getPageSize().intValue());
        Page result = (Page)this.agrMainMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)agrMainPO).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getAgrName()), AgrMainPO::getAgrName, (Object)agrListQryDTO.getAgrName())).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getAgrCode()), AgrMainPO::getAgrCode, (Object)agrListQryDTO.getAgrCode())).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getEnAgrCode()), AgrMainPO::getEnAgrCode, (Object)agrListQryDTO.getEnAgrCode())).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getSupplierName()), AgrMainPO::getSupplierName, (Object)agrListQryDTO.getSupplierName())).ge(!ObjectUtils.isEmpty((Object)agrListQryDTO.getEffDateStart()), AgrMainPO::getEffDate, (Object)agrListQryDTO.getEffDateStart())).le(!ObjectUtils.isEmpty((Object)agrListQryDTO.getEffDateEnd()), AgrMainPO::getEffDate, (Object)agrListQryDTO.getEffDateEnd())).ge(!ObjectUtils.isEmpty((Object)agrListQryDTO.getExpDateStart()), AgrMainPO::getExpDate, (Object)agrListQryDTO.getExpDateStart())).le(!ObjectUtils.isEmpty((Object)agrListQryDTO.getExpDateEnd()), AgrMainPO::getExpDate, (Object)agrListQryDTO.getExpDateEnd())).in(!CollectionUtils.isEmpty(agrListQryDTO.getAgrStatusList()), AgrMainPO::getAgrStatus, agrListQryDTO.getAgrStatusList())).in(!CollectionUtils.isEmpty(agrListQryDTO.getAgrObjPrimaryIdList()), AgrMainPO::getAgrObjPrimaryId, agrListQryDTO.getAgrObjPrimaryIdList())).eq(agrListQryDTO.getDelFlag() == null, AgrMainPO::getDelFlag, (Object)Integer.parseInt(DelFlag.UN_DELETE.getCode()))).ne(agrListQryDTO.getHistoryFlag() == false, AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()))).orderByDesc(AgrMainPO::getCreateTime)).orderByDesc(AgrMainPO::getAgrVersion));
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    public void saveAgrItems(List<DycProAgrItemDTO> dycProAgrItemDTOS) {
        List insertAgrItemDTOS;
        if (CollectionUtils.isEmpty(dycProAgrItemDTOS)) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u4fdd\u5b58 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        List<DycProAgrItemDTO> updateAgrItemDTOS = dycProAgrItemDTOS.stream().filter(e -> e.getAgrItemPrimaryId() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateAgrItemDTOS)) {
            this.updateAgrItemByIds(updateAgrItemDTOS);
        }
        if (!CollectionUtils.isEmpty(insertAgrItemDTOS = dycProAgrItemDTOS.stream().filter(e -> e.getAgrItemPrimaryId() == null).collect(Collectors.toList()))) {
            List insertItemPOList = JSON.parseArray((String)JSON.toJSONString(insertAgrItemDTOS), AgrItemPO.class);
            for (AgrItemPO each : insertItemPOList) {
                if (each.getAgrItemId() == null) {
                    each.setAgrItemPrimaryId(Long.valueOf(Sequence.getInstance().nextId()));
                    each.setAgrItemId(Long.valueOf(Sequence.getInstance().nextId()));
                }
                each.setInitCommFlag(DycProAgrConstants.AgrBooleanFlag.NO);
            }
            this.agrItemMapper.insertBatch((Collection)insertItemPOList);
        }
    }

    @Override
    public void updateAgrItemByIds(List<DycProAgrItemDTO> dycProAgrItemDTOS) {
        if (CollectionUtils.isEmpty(dycProAgrItemDTOS)) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u66f4\u65b0 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        List agrItemPOs = JSON.parseArray((String)JSON.toJSONString(dycProAgrItemDTOS), AgrItemPO.class);
        this.agrItemMapper.updateBatchByIds((Collection)agrItemPOs);
    }

    @Override
    public void updateAgrItem(DycProAgrItemHandleDTO handleDTO) {
        ReflectionUtils.doWithFields(handleDTO.getClass(), field -> {
            field.setAccessible(true);
            Object value = field.get(handleDTO);
            if (value instanceof String && ((String)value).isEmpty()) {
                field.set(handleDTO, null);
            }
        });
        AgrItemPO updatePO = (AgrItemPO)JSON.parseObject((String)JSON.toJSONString((Object)handleDTO), AgrItemPO.class);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.eq(handleDTO.getAgrObjPrimaryId() != null, AgrItemPO::getAgrObjPrimaryId, (Object)handleDTO.getAgrObjPrimaryId());
        if (handleDTO.getOperType() != null && handleDTO.getOperType() == 2) {
            if (!ObjectUtils.isEmpty((Object)updatePO.getCommodityName())) {
                lambdaUpdateWrapper.and(wrapper -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.isNull(AgrItemPO::getCommodityName)).or()).eq(AgrItemPO::getCommodityName, (Object)"");
                });
            }
            if (!ObjectUtils.isEmpty((Object)updatePO.getModel())) {
                lambdaUpdateWrapper.and(wrapper -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.isNull(AgrItemPO::getModel)).or()).eq(AgrItemPO::getModel, (Object)"");
                });
            }
            if (!ObjectUtils.isEmpty((Object)updatePO.getSpec())) {
                lambdaUpdateWrapper.and(wrapper -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.isNull(AgrItemPO::getSpec)).or()).eq(AgrItemPO::getSpec, (Object)"");
                });
            }
            if (!ObjectUtils.isEmpty((Object)updatePO.getMeasureName())) {
                lambdaUpdateWrapper.and(wrapper -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.isNull(AgrItemPO::getMeasureName)).or()).eq(AgrItemPO::getMeasureName, (Object)"");
                });
            }
            if (!ObjectUtils.isEmpty((Object)updatePO.getAgrItemNumber())) {
                lambdaUpdateWrapper.isNull(AgrItemPO::getAgrItemNumber);
            }
            if (!ObjectUtils.isEmpty((Object)updatePO.getSupplyPrice())) {
                lambdaUpdateWrapper.isNull(AgrItemPO::getSupplyPrice);
            }
            if (!ObjectUtils.isEmpty((Object)updatePO.getSupplyCycle())) {
                lambdaUpdateWrapper.isNull(AgrItemPO::getSupplyCycle);
            }
            if (!ObjectUtils.isEmpty((Object)updatePO.getTaxRate())) {
                lambdaUpdateWrapper.isNull(AgrItemPO::getTaxRate);
            }
        }
        this.agrItemMapper.update((Object)updatePO, (Wrapper)lambdaUpdateWrapper);
    }

    @Override
    public void deleteAgrItem(Long agrObjPrimaryId, List<Long> agrItemIds) {
        if (ObjectUtils.isEmpty((Object)agrObjPrimaryId) && CollectionUtils.isEmpty(agrItemIds)) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5220\u9664 \u57fa\u5efa\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (agrObjPrimaryId != null) {
            queryWrapper.eq(AgrItemPO::getAgrObjPrimaryId, (Object)agrObjPrimaryId);
        }
        if (!CollectionUtils.isEmpty(agrItemIds)) {
            queryWrapper.in(AgrItemPO::getAgrItemId, agrItemIds);
        }
        this.agrItemMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public void dealAgrApprove(DycProAgrMainHandleDTO handleDTO) {
        if (CollectionUtils.isEmpty(handleDTO.getAgrObjPrimaryIds())) {
            throw new ZTBusinessException("\u5ba1\u6279\u5904\u7406\u65f6\u3010\u534f\u8bae\u552f\u4e00id\u96c6\u5408\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)handleDTO.getApproveResult())) {
            throw new ZTBusinessException("\u5ba1\u6279\u5904\u7406\u65f6\u3010\u5ba1\u6279\u7ed3\u679c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List agrMainPOS = this.agrMainMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(AgrMainPO::getAgrObjPrimaryId, handleDTO.getAgrObjPrimaryIds()));
        if (CollectionUtils.isEmpty((Collection)agrMainPOS)) {
            throw new ZTBusinessException("\u5ba1\u6279\u5904\u7406\u65f6\u534f\u8bae\u67e5\u8be2\u4e3a\u7a7a");
        }
        ArrayList<AgrMainPO> updatePOS = new ArrayList<AgrMainPO>();
        Date date = new Date(System.currentTimeMillis());
        for (AgrMainPO each : agrMainPOS) {
            AgrMainPO updatePO = new AgrMainPO();
            if ("pass".equals(handleDTO.getApproveResult())) {
                if (date.compareTo(each.getEffDate()) < 0) {
                    updatePO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.PENDING_EFFECTIVE.getCode())));
                } else if (date.compareTo(each.getExpDate()) > 0) {
                    updatePO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.EXPIRED.getCode())));
                } else {
                    updatePO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.ACTIVE.getCode())));
                }
            } else if ("reject".equals(handleDTO.getApproveResult())) {
                updatePO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.REJECTED.getCode())));
            }
            updatePO.setAgrObjPrimaryId(each.getAgrObjPrimaryId());
            updatePO.setUpdateUserId(handleDTO.getUpdateUserId());
            updatePO.setUpdateUserName(handleDTO.getUpdateUserName());
            updatePO.setUpdateUserAccount(handleDTO.getUpdateUserAccount());
            updatePO.setUpdateCompanyId(handleDTO.getUpdateCompanyId());
            updatePO.setUpdateOrgId(handleDTO.getUpdateOrgId());
            updatePO.setUpdateOrgPath(handleDTO.getUpdateOrgPath());
            updatePO.setUpdateCompanyName(handleDTO.getUpdateCompanyName());
            updatePO.setUpdateOrgName(handleDTO.getUpdateOrgName());
            updatePO.setUpdateTime(handleDTO.getUpdateTime());
            updatePOS.add(updatePO);
        }
        this.agrMainMapper.updateBatchByIds(updatePOS);
    }

    @Override
    public List<DycProAgrItemDTO> selectAgrItemList(DycProAgrItemListQryDTO qryDTO) {
        AgrItemPO qryPO = (AgrItemPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), AgrItemPO.class);
        ReflectionUtils.doWithFields(qryPO.getClass(), field -> {
            field.setAccessible(true);
            Object value = field.get(qryPO);
            if (value instanceof String && ((String)value).isEmpty()) {
                field.set(qryPO, null);
            }
        });
        List<DycProAgrItemDTO> itemTDOS = new ArrayList<DycProAgrItemDTO>();
        List agrItemPOS = null;
        if (!qryDTO.getHistoryFlag().booleanValue()) {
            agrItemPOS = this.agrItemMapper.getAgrItemList(qryPO);
        } else {
            QueryWrapper itemQryWrapper = new QueryWrapper((Object)qryPO);
            itemQryWrapper.lambda().in(!CollectionUtils.isEmpty(qryDTO.getAgrItemIds()), AgrItemPO::getAgrItemId, qryDTO.getAgrItemIds());
            agrItemPOS = this.agrItemMapper.selectList((Wrapper)itemQryWrapper);
        }
        if (!CollectionUtils.isEmpty((Collection)agrItemPOS)) {
            itemTDOS = JSON.parseArray((String)JSON.toJSONString((Object)agrItemPOS), DycProAgrItemDTO.class);
            for (DycProAgrItemDTO each : itemTDOS) {
                if (each.getSupplyPrice() == null || each.getAgrItemNumber() == null) continue;
                each.setSupplyPriceTotal(each.getSupplyPrice().multiply(each.getAgrItemNumber()).setScale(2, 4));
            }
        }
        return itemTDOS;
    }

    @Override
    public RspPage<DycProAgrItemDTO> selectAgrItemListPage(DycProAgrItemListQryDTO qryDTO) {
        if (qryDTO.getAgrId() != null && qryDTO.getAgrObjPrimaryId() == null) {
            QueryWrapper mainQryWrapper = new QueryWrapper();
            mainQryWrapper.lambda().eq(AgrMainPO::getAgrId, (Object)qryDTO.getAgrId());
            mainQryWrapper.lambda().ne(AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()));
            AgrMainPO agrMainPO = (AgrMainPO)this.agrMainMapper.selectOne((Wrapper)mainQryWrapper);
            if (agrMainPO == null) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u8be6\u60c5");
            }
            qryDTO.setAgrObjPrimaryId(agrMainPO.getAgrObjPrimaryId());
        }
        AgrItemPO qryPO = (AgrItemPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), AgrItemPO.class);
        ReflectionUtils.doWithFields(qryPO.getClass(), field -> {
            field.setAccessible(true);
            Object value = field.get(qryPO);
            if (value instanceof String && ((String)value).isEmpty()) {
                field.set(qryPO, null);
            }
        });
        qryPO.setCommodityName(null);
        qryPO.setBrandName(null);
        qryPO.setSpec(null);
        qryPO.setModel(null);
        qryPO.setMaterialName(null);
        qryPO.setMaterialCode(null);
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        Page result = (Page)this.agrItemMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)qryPO).in(!CollectionUtils.isEmpty(qryDTO.getAgrItemIds()), AgrItemPO::getAgrItemId, qryDTO.getAgrItemIds())).notIn(!CollectionUtils.isEmpty(qryDTO.getIgnoreAgrItemIds()), AgrItemPO::getAgrItemId, qryDTO.getIgnoreAgrItemIds())).like(!ObjectUtils.isEmpty((Object)qryDTO.getCommodityName()), AgrItemPO::getCommodityName, (Object)qryDTO.getCommodityName())).like(!ObjectUtils.isEmpty((Object)qryDTO.getBrandName()), AgrItemPO::getBrandName, (Object)qryDTO.getBrandName())).like(!ObjectUtils.isEmpty((Object)qryDTO.getSpec()), AgrItemPO::getSpec, (Object)qryDTO.getSpec())).like(!ObjectUtils.isEmpty((Object)qryDTO.getModel()), AgrItemPO::getModel, (Object)qryDTO.getModel())).like(!ObjectUtils.isEmpty((Object)qryDTO.getMaterialName()), AgrItemPO::getMaterialName, (Object)qryDTO.getMaterialName())).like(!ObjectUtils.isEmpty((Object)qryDTO.getMaterialCode()), AgrItemPO::getMaterialCode, (Object)qryDTO.getMaterialCode())).orderByDesc(AgrItemPO::getAgrItemId));
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            List measureIds = result.getRecords().stream().map(AgrItemPO::getMeasureId).distinct().collect(Collectors.toList());
            List commMeasureInfoPOS = this.measureInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommMeasureInfoPO::getMeasureId, measureIds));
            Map<Object, Object> commMeasureMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)commMeasureInfoPOS)) {
                commMeasureMap = commMeasureInfoPOS.stream().collect(Collectors.toMap(CommMeasureInfoPO::getMeasureId, Function.identity()));
            }
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProAgrItemDTO.class));
            for (DycProAgrItemDTO each : rspPage.getRows()) {
                if (each.getSupplyPrice() != null) {
                    each.setSupplyPrice(each.getSupplyPrice().setScale(2, 4));
                }
                if (each.getSupplyPrice() != null && each.getAgrItemNumber() != null) {
                    each.setSupplyPriceTotal(each.getSupplyPrice().multiply(each.getAgrItemNumber()).setScale(2, 4));
                }
                if (each.getMeasureId() != null && commMeasureMap.containsKey(each.getMeasureId())) {
                    each.setDecimalLimit(((CommMeasureInfoPO)commMeasureMap.get(each.getMeasureId())).getDecimalLimit());
                } else {
                    each.setDecimalLimit(0);
                }
                if (each.getAgrItemNumber() == null) continue;
                each.setAgrItemNumber(each.getAgrItemNumber().setScale((int)each.getDecimalLimit(), RoundingMode.HALF_UP));
            }
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> getAgrCouldChngListPage(DycProAgrListQryDTO agrListQryDTO) {
        RspPage rspPage = new RspPage();
        AgrMainQryPO qryPO = (AgrMainQryPO)JSON.parseObject((String)JSON.toJSONString((Object)agrListQryDTO), AgrMainQryPO.class);
        qryPO.setOrderBy("a.create_time desc");
        qryPO.setDelFlag(DycProAgrConstants.AgrDelFlag.UN_DELETE);
        Page page = new Page((long)agrListQryDTO.getPageNo().intValue(), (long)agrListQryDTO.getPageSize().intValue());
        List agrCouldChngListPage = this.agrMainMapper.getAgrCouldChngListPage(qryPO, page);
        if (!CollectionUtils.isEmpty((Collection)agrCouldChngListPage)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)agrCouldChngListPage), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> qryAgrSupplierListPage(DycProAgrListQryDTO agrListQryDTO) {
        RspPage rspPage = new RspPage();
        Set<Object> agrObjPrimaryIds = new TreeSet();
        if (!CollectionUtils.isEmpty(agrListQryDTO.getManageCatalogIds())) {
            List agrCooperationCatalogPOS = this.agrCooperationCatalogMapper.selectList((Wrapper)Wrappers.query().lambda().in(AgrCooperationCatalogPO::getManageCatalogId, agrListQryDTO.getManageCatalogIds()));
            if (!CollectionUtils.isEmpty((Collection)agrCooperationCatalogPOS)) {
                agrObjPrimaryIds = agrCooperationCatalogPOS.stream().map(AgrCooperationCatalogPO::getAgrObjPrimaryId).collect(Collectors.toSet());
            } else {
                return rspPage;
            }
        }
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)agrListQryDTO), AgrMainPO.class);
        agrMainPO.setSupplierName(null);
        Page page = new Page((long)agrListQryDTO.getPageNo().intValue(), (long)agrListQryDTO.getPageSize().intValue());
        Page result = (Page)this.agrMainMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)agrMainPO).in(!CollectionUtils.isEmpty(agrObjPrimaryIds), AgrMainPO::getAgrObjPrimaryId, agrObjPrimaryIds)).eq(AgrMainPO::getDelFlag, (Object)Integer.parseInt(DelFlag.UN_DELETE.getCode()))).eq(agrListQryDTO.getAgrType() != null, AgrMainPO::getAgrType, (Object)agrListQryDTO.getAgrType())).ne(AgrMainPO::getDelFlag, (Object)Integer.parseInt(DmcAgrMainAgrStatus.HISTORY.getCode()))).like(!ObjectUtils.isEmpty((Object)agrListQryDTO.getSupplierName()), AgrMainPO::getSupplierName, (Object)agrListQryDTO.getSupplierName())).groupBy(AgrMainPO::getSupplierId));
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> qryAgrConfirmListPage(DycProAgrListQryDTO agrListQryDTO) {
        AgrMainQryPO agrMainQryPO = (AgrMainQryPO)JSON.parseObject((String)JSON.toJSONString((Object)agrListQryDTO), AgrMainQryPO.class);
        Page page = new Page((long)agrListQryDTO.getPageNo().intValue(), (long)agrListQryDTO.getPageSize().intValue());
        List agrMainPOS = this.agrMainMapper.qryAgrConfirmListPage(agrMainQryPO, page);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)agrMainPOS)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)agrMainPOS), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> queryPriceRuleToSelectAgrListPage(DycProAgrListQryDTO agrListQryDTO) {
        Page page = new Page((long)agrListQryDTO.getPageNo().intValue(), (long)agrListQryDTO.getPageSize().intValue());
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)agrListQryDTO), AgrMainPO.class);
        List agrMainPOS = this.agrMainMapper.queryPriceRuleToSelectAgrListPage(agrMainPO, page);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)agrMainPOS)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)agrMainPOS), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> queryPriceRuleToSelectSupplierListPage(DycProAgrListQryDTO agrListQryDTO) {
        Page page = new Page((long)agrListQryDTO.getPageNo().intValue(), (long)agrListQryDTO.getPageSize().intValue());
        AgrMainPO agrMainPO = (AgrMainPO)JSON.parseObject((String)JSON.toJSONString((Object)agrListQryDTO), AgrMainPO.class);
        List agrMainPOS = this.agrMainMapper.queryPriceRuleToSelectSupplierListPage(agrMainPO, page);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)agrMainPOS)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)agrMainPOS), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProAgrMainDTO> qryAgrCreateCommAgrListPage(DycProAgrListQryDTO agrListQryDTO) {
        Page page;
        RspPage rspPage = new RspPage();
        AgrMainQryPO qryPO = (AgrMainQryPO)JSON.parseObject((String)JSON.toJSONString((Object)agrListQryDTO), AgrMainQryPO.class);
        List agrCreateCommAgrList = this.agrMainMapper.qryAgrCreateCommAgrListPage(qryPO, page = new Page((long)agrListQryDTO.getPageNo().intValue(), (long)agrListQryDTO.getPageSize().intValue()));
        if (!CollectionUtils.isEmpty((Collection)agrCreateCommAgrList)) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)agrCreateCommAgrList), DycProAgrMainDTO.class));
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public DycProAgrMainQryDTO qryAgrItemImportJudgeInfoMaterialMode(DycProAgrMainQryDTO qryDTO) {
        if (CollectionUtils.isEmpty(qryDTO.getAgrItemImportJudgeList())) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6570\u636e\u6821\u9a8c\u96c6\u5408\u4e3a\u7a7a");
        }
        List materialCodes = qryDTO.getAgrItemImportJudgeList().stream().map(DycProAgrItemImportJudgeDTO::getMaterialCode).collect(Collectors.toList());
        DycProAgrMainQryDTO result = new DycProAgrMainQryDTO();
        ArrayList<DycProAgrItemImportJudgeDTO> agrItemImportJudgeList = new ArrayList<DycProAgrItemImportJudgeDTO>();
        result.setAgrItemImportJudgeList(agrItemImportJudgeList);
        List materialInfoPOS = this.materialInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommMaterialInfoPO::getMaterialCode, materialCodes)).eq(CommMaterialInfoPO::getEnableFlag, (Object)Integer.parseInt(EnableFlag.USE.getCode()))).eq(CommMaterialInfoPO::getDelFlag, (Object)Integer.parseInt(DelFlag.UN_DELETE.getCode())));
        if (!CollectionUtils.isEmpty((Collection)materialInfoPOS)) {
            List catalogNamePOS;
            List measureIds = materialInfoPOS.stream().map(CommMaterialInfoPO::getMeasureId).distinct().collect(Collectors.toList());
            List commMeasureInfoPOS = this.measureInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommMeasureInfoPO::getMeasureId, measureIds));
            Map<Object, Object> commMeasureMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)commMeasureInfoPOS)) {
                commMeasureMap = commMeasureInfoPOS.stream().collect(Collectors.toMap(CommMeasureInfoPO::getMeasureId, Function.identity()));
            }
            CommMaterialClassifyPO qryPO = new CommMaterialClassifyPO();
            qryPO.setAgrObjPrimaryId(qryDTO.getAgrObjPrimaryId());
            qryPO.setWhetherManageCatalog(qryDTO.getWhetherManageCatalog());
            List commMaterialClassifyQryAllTreePOS = this.materialClassifyMapper.qryMaterialClassifyAndManageCatalogList(qryPO);
            Map<Object, Object> materialClassifyMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)commMaterialClassifyQryAllTreePOS)) {
                commMaterialClassifyQryAllTreePOS.removeIf(e -> e.getMaterialClassifyId() == null);
                materialClassifyMap = commMaterialClassifyQryAllTreePOS.stream().collect(Collectors.toMap(CommMaterialClassifyQryAllTreePO::getMaterialClassifyId, Function.identity(), (o1, o2) -> o1));
            }
            for (Object each : materialInfoPOS) {
                if (!materialClassifyMap.containsKey(each.getMaterialClassifyId())) continue;
                DycProAgrItemImportJudgeDTO judgeDTO = (DycProAgrItemImportJudgeDTO)JSON.parseObject((String)JSON.toJSONString((Object)each), DycProAgrItemImportJudgeDTO.class);
                CommMaterialClassifyQryAllTreePO materialClassify = (CommMaterialClassifyQryAllTreePO)materialClassifyMap.get(each.getMaterialClassifyId());
                judgeDTO.setMaterialClassifyId(materialClassify.getMaterialClassifyId());
                judgeDTO.setMaterialClassifyName(materialClassify.getMaterialClassifyName());
                judgeDTO.setManageCatalogId(materialClassify.getManageCatalogId());
                judgeDTO.setManageCatalogCode(materialClassify.getManageCatalogCode());
                judgeDTO.setManageCatalogName(materialClassify.getManageCatalogName());
                judgeDTO.setManageCatalogPath(materialClassify.getManageCatalogPath());
                judgeDTO.setManageCatalogPathName(materialClassify.getManageCatalogPathName());
                if (judgeDTO.getMeasureId() != null && commMeasureMap.containsKey(judgeDTO.getMeasureId())) {
                    judgeDTO.setDecimalLimit(((CommMeasureInfoPO)commMeasureMap.get(judgeDTO.getMeasureId())).getDecimalLimit());
                } else {
                    judgeDTO.setFailReason(each.getMaterialCode() + "\u7269\u6599\u7f16\u7801\u672a\u67e5\u8be2\u5230\u8ba1\u91cf\u5355\u4f4d\u201c" + judgeDTO.getMeasureName() + "\u201d");
                }
                agrItemImportJudgeList.add(judgeDTO);
            }
            HashSet manageCatalogIds = new HashSet();
            for (DycProAgrItemImportJudgeDTO each : agrItemImportJudgeList) {
                manageCatalogIds.addAll(Arrays.stream(each.getManageCatalogPath().split("-")).map(Long::valueOf).collect(Collectors.toList()));
            }
            Map<Object, Object> commManageCatalogInfoPOMap = new HashMap();
            if (!CollectionUtils.isEmpty(manageCatalogIds) && !CollectionUtils.isEmpty((Collection)(catalogNamePOS = this.commManageCatalogInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().in(CommManageCatalogInfoPO::getManageCatalogId, manageCatalogIds))))) {
                commManageCatalogInfoPOMap = catalogNamePOS.stream().collect(Collectors.groupingBy(CommManageCatalogInfoPO::getManageCatalogId));
                log.debug("\u76ee\u5f55\u4fe1\u606fMap\uff1a{}", (Object)catalogNamePOS);
            }
            for (DycProAgrItemImportJudgeDTO each : agrItemImportJudgeList) {
                if (ObjectUtils.isEmpty((Object)each.getManageCatalogPath())) continue;
                String[] split = each.getManageCatalogPath().split("-");
                ArrayList<String> catalogInfoNames = new ArrayList<String>();
                for (String s : split) {
                    List commManageCatalogInfoPOS1 = (List)commManageCatalogInfoPOMap.get(Long.valueOf(s));
                    if (CollectionUtils.isEmpty((Collection)commManageCatalogInfoPOS1)) continue;
                    catalogInfoNames.add(((CommManageCatalogInfoPO)commManageCatalogInfoPOS1.get(0)).getManageCatalogName());
                }
                String manageCatalogPathName = String.join((CharSequence)"/", catalogInfoNames);
                log.debug("\u76ee\u5f55\u8def\u5f84\u540d\u79f0\uff1a{}", (Object)manageCatalogPathName);
                each.setManageCatalogPathName(manageCatalogPathName);
            }
        }
        return result;
    }

    @Override
    public DycProAgrMainQryDTO qryAgrItemImportJudgeInfoCommodityMode(DycProAgrMainQryDTO qryDTO) {
        if (CollectionUtils.isEmpty(qryDTO.getAgrItemImportJudgeList())) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6570\u636e\u6821\u9a8c\u96c6\u5408\u4e3a\u7a7a");
        }
        List manageCatalogCodes = qryDTO.getAgrItemImportJudgeList().stream().map(DycProAgrItemImportJudgeDTO::getManageCatalogCode).collect(Collectors.toList());
        DycProAgrMainQryDTO result = new DycProAgrMainQryDTO();
        result.setAgrItemImportJudgeList(qryDTO.getAgrItemImportJudgeList());
        List commManageCatalogInfoPOS = this.commManageCatalogInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommManageCatalogInfoPO::getManageCatalogCode, manageCatalogCodes)).eq(CommManageCatalogInfoPO::getEnableFlag, (Object)Integer.parseInt(EnableFlag.USE.getCode()))).eq(CommManageCatalogInfoPO::getDelFlag, (Object)Integer.parseInt(DelFlag.UN_DELETE.getCode())));
        if (!CollectionUtils.isEmpty((Collection)commManageCatalogInfoPOS)) {
            List<Object> passManageCatalogIds = new ArrayList();
            if (Integer.valueOf(BooleanFlag.YES.getCode()).equals(qryDTO.getWhetherManageCatalog()) && qryDTO.getAgrObjPrimaryId() != null) {
                List manageCatalogIds = commManageCatalogInfoPOS.stream().map(CommManageCatalogInfoPO::getManageCatalogId).collect(Collectors.toList());
                List agrCooperationCatalogPOS = this.agrCooperationCatalogMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(AgrCooperationCatalogPO::getManageCatalogId, manageCatalogIds)).eq(AgrCooperationCatalogPO::getAgrObjPrimaryId, (Object)qryDTO.getAgrObjPrimaryId()));
                if (!CollectionUtils.isEmpty((Collection)agrCooperationCatalogPOS)) {
                    passManageCatalogIds = agrCooperationCatalogPOS.stream().map(AgrCooperationCatalogPO::getManageCatalogId).collect(Collectors.toList());
                }
            } else {
                passManageCatalogIds = commManageCatalogInfoPOS.stream().map(CommManageCatalogInfoPO::getManageCatalogId).collect(Collectors.toList());
            }
            Map manageCatalogMap = commManageCatalogInfoPOS.stream().collect(Collectors.toMap(CommManageCatalogInfoPO::getManageCatalogCode, Function.identity(), (o1, o2) -> o1));
            HashSet manageCatalogIds = new HashSet();
            for (CommManageCatalogInfoPO each : commManageCatalogInfoPOS) {
                manageCatalogIds.addAll(Arrays.stream(each.getManageCatalogPath().split("-")).map(Long::valueOf).collect(Collectors.toList()));
            }
            Map<Object, Object> commManageCatalogInfoPOMap = new HashMap();
            List catalogNamePOS = this.commManageCatalogInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().in(CommManageCatalogInfoPO::getManageCatalogId, manageCatalogIds));
            if (!CollectionUtils.isEmpty((Collection)catalogNamePOS)) {
                commManageCatalogInfoPOMap = catalogNamePOS.stream().collect(Collectors.groupingBy(CommManageCatalogInfoPO::getManageCatalogId));
                log.debug("\u76ee\u5f55\u4fe1\u606fMap\uff1a{}", (Object)catalogNamePOS);
            }
            List measureNames = qryDTO.getAgrItemImportJudgeList().stream().map(DycProAgrItemImportJudgeDTO::getMeasureName).distinct().collect(Collectors.toList());
            List commMeasureInfoPOS = this.measureInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommMeasureInfoPO::getMeasureName, measureNames));
            Map<Object, Object> commMeasureNameMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)commMeasureInfoPOS)) {
                commMeasureNameMap = commMeasureInfoPOS.stream().collect(Collectors.toMap(CommMeasureInfoPO::getMeasureName, Function.identity(), (o1, o2) -> o1));
            }
            for (DycProAgrItemImportJudgeDTO each : qryDTO.getAgrItemImportJudgeList()) {
                if (!manageCatalogMap.containsKey(each.getManageCatalogCode())) {
                    each.setFailReason("\u3010\u540e\u53f0\u7ba1\u7406\u7c7b\u76ee\u7f16\u7801\u3011\u672a\u67e5\u8be2\u5230");
                    continue;
                }
                each.setManageCatalogId(((CommManageCatalogInfoPO)manageCatalogMap.get(each.getManageCatalogCode())).getManageCatalogId());
                each.setManageCatalogCode(((CommManageCatalogInfoPO)manageCatalogMap.get(each.getManageCatalogCode())).getManageCatalogCode());
                each.setManageCatalogName(((CommManageCatalogInfoPO)manageCatalogMap.get(each.getManageCatalogCode())).getManageCatalogName());
                each.setManageCatalogPath(((CommManageCatalogInfoPO)manageCatalogMap.get(each.getManageCatalogCode())).getManageCatalogPath());
                if (!passManageCatalogIds.contains(each.getManageCatalogId())) {
                    each.setFailReason("\u3010\u540e\u53f0\u7ba1\u7406\u7c7b\u76ee\u7f16\u7801\u3011\u4e0d\u5728\u5408\u4f5c\u7c7b\u76ee\u7ba1\u7406\u8303\u56f4\u5185");
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)each.getManageCatalogPath())) {
                    String[] split = each.getManageCatalogPath().split("-");
                    ArrayList<String> catalogInfoNames = new ArrayList<String>();
                    for (String s : split) {
                        List commManageCatalogInfoPOS1 = (List)commManageCatalogInfoPOMap.get(Long.valueOf(s));
                        if (CollectionUtils.isEmpty((Collection)commManageCatalogInfoPOS1)) continue;
                        catalogInfoNames.add(((CommManageCatalogInfoPO)commManageCatalogInfoPOS1.get(0)).getManageCatalogName());
                    }
                    String manageCatalogPathName = String.join((CharSequence)"/", catalogInfoNames);
                    log.debug("\u76ee\u5f55\u8def\u5f84\u540d\u79f0\uff1a{}", (Object)manageCatalogPathName);
                    each.setManageCatalogPathName(manageCatalogPathName);
                }
                if (!ObjectUtils.isEmpty((Object)each.getMeasureName()) && commMeasureNameMap.containsKey(each.getMeasureName())) {
                    each.setMeasureId(((CommMeasureInfoPO)commMeasureNameMap.get(each.getMeasureName())).getMeasureId());
                    each.setDecimalLimit(((CommMeasureInfoPO)commMeasureNameMap.get(each.getMeasureName())).getDecimalLimit());
                    continue;
                }
                each.setFailReason("\u672a\u67e5\u8be2\u5230\u8ba1\u91cf\u5355\u4f4d");
            }
        }
        return result;
    }

    @Override
    public DycProAgrListQryDTO qryAgrObjPrimaryIdByAgrScope(DycProAgrListQryDTO qryDTO) {
        if (ObjectUtils.isEmpty((Object)qryDTO)) {
            throw new ZTBusinessException("dto\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgrMainQryPO qryPO = new AgrMainQryPO();
        qryPO.setCompanyId(qryDTO.getCompanyId());
        qryPO.setOrgIdList(qryDTO.getOrgIdList());
        List agrMainPOS = this.agrMainMapper.qryAgrObjPrimaryIdByAgrScope(qryPO);
        if (!CollectionUtils.isEmpty((Collection)agrMainPOS)) {
            qryDTO.setAgrObjPrimaryIdList(agrMainPOS.stream().map(AgrMainPO::getAgrObjPrimaryId).collect(Collectors.toList()));
        }
        return qryDTO;
    }

    @Override
    public DycProAgrMainDTO qryCommBansRecordByAgr(DycProAgrListQryDTO qryDTO) {
        DycProAgrMainDTO result = (DycProAgrMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), DycProAgrMainDTO.class);
        List commSkuInfoPOS = this.commSkuInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommSkuInfoPO::getAgrId, new Object[]{qryDTO.getAgrId()}));
        Map<Long, List<DycProAgrBansRecordInfoDTO>> recordSkuMap = new HashMap<Long, List<DycProAgrBansRecordInfoDTO>>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(CommBansRecordPO::getSkuId, (Collection)commSkuInfoPOS.stream().map(CommSkuInfoPO::getSkuId).collect(Collectors.toList()));
        queryWrapper.ge(CommBansRecordPO::getBansEndDate, (Object)new Date());
        List recordPOS = this.commBansRecordMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)recordPOS)) {
            List dycProAgrBansRecordInfoDTOS = JSON.parseArray((String)JSON.toJSONString((Object)recordPOS), DycProAgrBansRecordInfoDTO.class);
            recordSkuMap = dycProAgrBansRecordInfoDTOS.stream().collect(Collectors.groupingBy(DycProAgrBansRecordInfoDTO::getSkuId));
        }
        result.setBansRecordInfoMap(recordSkuMap);
        return result;
    }

    @Override
    public DycProAgrMainDTO qrySkuByAgr(DycProAgrListQryDTO qryDTO) {
        DycProAgrMainDTO result = (DycProAgrMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), DycProAgrMainDTO.class);
        List commSkuInfoPOS = this.commSkuInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommSkuInfoPO::getAgrId, qryDTO.getAgrIds()));
        result.setAgrSkuList(JSON.parseArray((String)JSON.toJSONString((Object)commSkuInfoPOS), DycProAgrSkuDTO.class));
        return result;
    }
}

