/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordOperateResultEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuInfoApprovalStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuInfoSkuStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPackageInfoDTO;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.api.DycProCommBansRecordRepository;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.api.DycProCommSensitiveWordInfoRepository;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.dto.DycProCommSensitiveWordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrSkuUpdateService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuUpdateReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuUpdateRspBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuPicApiBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrSkuUpdateService"})
public class DycProCommAgrSkuUpdateServiceImpl
implements DycProCommAgrSkuUpdateService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;
    @Autowired
    private DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private DycProCommSensitiveWordInfoRepository dycProCommSensitiveWordInfoRepository;
    @Autowired
    private DycProCommBansRecordRepository dycProCommBansRecordRepository;
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;

    @PostMapping(value={"updateAgrSku"})
    public DycProCommAgrSkuUpdateRspBO updateAgrSku(@RequestBody DycProCommAgrSkuUpdateReqBO reqBO) {
        this.judge(reqBO);
        DycProCommAuditPakageObjDTO auditPakageObjDTO = this.updateAgrSkuInfo(reqBO);
        DycProCommAgrSkuUpdateRspBO rspBO = new DycProCommAgrSkuUpdateRspBO();
        rspBO.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
        rspBO.setBusiType(reqBO.getBusiType());
        if (reqBO.getOperType() == 1 && !StringUtils.isEmpty((Object)reqBO.getBusiType())) {
            Long auditPackageId = Sequence.getInstance().nextId();
            rspBO.setAuditPackageId(auditPackageId);
            this.insertAuditPackage(auditPackageId, auditPakageObjDTO);
        }
        return rspBO;
    }

    private DycProCommAuditPakageObjDTO updateAgrSkuInfo(DycProCommAgrSkuUpdateReqBO reqBO) {
        List sensitiveWordInfoDTOS = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(reqBO.getUpdateSkuInfo().getSkuName());
        if (!CollectionUtils.isEmpty((Collection)sensitiveWordInfoDTOS)) {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : sensitiveWordInfoDTOS) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("],");
            }
            throw new ZTBusinessException("sku\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
        }
        DycProCommSkuDTO skuDTO = (DycProCommSkuDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getUpdateSkuInfo()), DycProCommSkuDTO.class);
        DycProCommAuditPakageObjDTO auditPakageObjDTO = new DycProCommAuditPakageObjDTO();
        DycProCommSkuDTO qryDTO = new DycProCommSkuDTO();
        qryDTO.setSkuId(reqBO.getUpdateSkuInfo().getSkuId());
        DycProCommSkuHandleDTO skuDetails = this.dycProCommSkuRepository.getSkuDetails(qryDTO);
        skuDTO.setAgrId(skuDetails.getAgrId());
        skuDTO.setAgrItemId(skuDetails.getAgrItemId());
        if (Integer.valueOf(DmcAgrMainTradeMode.MY.getCode()).equals(skuDetails.getTradeMode())) {
            if (skuDTO.getPriceInfo().getSupplierPrice() != null) {
                this.computeSkuPrice(skuDTO, skuDetails);
            }
        } else {
            skuDTO.getPriceInfo().setSalePrice(skuDTO.getPriceInfo().getSupplierPrice());
        }
        DycProCommPropertyTemplateInfoDTO queryPropertyTemplateInfoDTO = new DycProCommPropertyTemplateInfoDTO();
        queryPropertyTemplateInfoDTO.setManageCatalogId(reqBO.getUpdateSkuInfo().getManageCatalogId());
        DycProCommPropertyTemplateInfoDTO propertyTemplateInfoDTO = this.dycProCommManageCatalogRepository.queryPropertyTemplateOneByCondition(queryPropertyTemplateInfoDTO);
        if (null == propertyTemplateInfoDTO || propertyTemplateInfoDTO.getPropertyTemplateId() == null) {
            throw new ZTBusinessException(reqBO.getUpdateSkuInfo().getManageCatalogId() + "\uff0c\u8be5\u7ba1\u7406\u7c7b\u76eeid\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027\u6a21\u677f");
        }
        skuDTO.setPropertyTemplateId(propertyTemplateInfoDTO.getPropertyTemplateId());
        if (reqBO.getUpdateSkuInfo().getStockInfo() != null && reqBO.getUpdateSkuInfo().getStockInfo().getOriginNum() != null) {
            DycProCommSkuStockInfoDTO stockInfo = new DycProCommSkuStockInfoDTO();
            stockInfo.setOriginNum(reqBO.getUpdateSkuInfo().getStockInfo().getOriginNum());
            stockInfo.setTotalNum(reqBO.getUpdateSkuInfo().getStockInfo().getOriginNum());
            stockInfo.setUnsaleNum(reqBO.getUpdateSkuInfo().getStockInfo().getOriginNum());
            stockInfo.setSaledNum(BigDecimal.ZERO);
            stockInfo.setSkuName(reqBO.getUpdateSkuInfo().getSkuName());
            stockInfo.setSaleMeasureId(reqBO.getUpdateSkuInfo().getSaleMeasureId());
            stockInfo.setSaleMeasureName(reqBO.getUpdateSkuInfo().getSaleMeasureName());
            stockInfo.setCreateUserId(reqBO.getUserId());
            stockInfo.setCreateUserName(reqBO.getName());
            stockInfo.setCreateUserAccount(reqBO.getUserName());
            stockInfo.setCreateCompanyId(reqBO.getCompanyId());
            stockInfo.setCreateOrgId(reqBO.getOrgId());
            stockInfo.setCreateCompanyName(reqBO.getCompanyName());
            stockInfo.setCreateOrgName(reqBO.getOrgName());
            stockInfo.setCreateTime(new Date(System.currentTimeMillis()));
            skuDTO.setStockInfo(stockInfo);
        }
        skuDTO.setUpdateUserId(reqBO.getUserId());
        skuDTO.setUpdateUserName(reqBO.getName());
        skuDTO.setUpdateCompanyId(reqBO.getCompanyId());
        skuDTO.setUpdateOrgId(reqBO.getOrgId());
        skuDTO.setUpdateOrgPath(reqBO.getOrgPath());
        skuDTO.setUpdateCompanyName(reqBO.getCompanyName());
        skuDTO.setUpdateOrgName(reqBO.getOrgName());
        skuDTO.setUpdateTime(new Date(System.currentTimeMillis()));
        skuDTO.setSkuSource(DycProCommConstants.SkuSource.AGR_SKU);
        if (Integer.valueOf(DmcCommSkuInfoSkuStatus.ON_SHELVES.getCode()).equals(skuDetails.getSkuStatus()) && reqBO.getUccApproveEditAgreementSwitch().booleanValue()) {
            auditPakageObjDTO = this.dycProCommSkuRepository.dealSkuCompleteEditInfo(skuDTO);
            if (reqBO.getOperType() == 1) {
                DycProCommSkuHandleDTO reqDto = new DycProCommSkuHandleDTO();
                reqDto.setSkuIdList(Arrays.asList(reqBO.getUpdateSkuInfo().getSkuId()));
                reqDto.setApprovalStatus(Integer.valueOf(Integer.parseInt(DmcCommSkuInfoApprovalStatus.EDIT_TODO.getCode())));
                this.dycProCommSkuRepository.updateSkuInfoNullByIdsAndSyncNoSql(reqDto, null);
                reqBO.setBusiType(PublicProcInstBusiType.AGR_SKU_EDIT_APPROVE.getCode());
            }
        } else {
            boolean operateRecordFlag = false;
            if (reqBO.getOperType() == 1) {
                ArrayList<Long> skuIds = new ArrayList<Long>();
                skuIds.add(reqBO.getUpdateSkuInfo().getSkuId());
                this.checkFilterBans(skuIds);
                if (reqBO.getUpdateSkuInfo().getOnShelveWay().equals(DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE) && CollectionUtils.isEmpty(skuIds)) {
                    throw new ZTBusinessException("\u8be5\u5546\u54c1\u7981\u552e\uff0c\u4e0d\u80fd\u7acb\u5373\u4e0a\u67b6");
                }
                if (reqBO.getUpdateSkuInfo().getOnShelveWay().equals(DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE) && !CollectionUtils.isEmpty(skuIds)) {
                    if (reqBO.getUccApproveOnShelveAgreementSwitch().booleanValue()) {
                        if (skuDetails.getSkuStatus().equals(Integer.parseInt(DmcCommSkuInfoSkuStatus.DRAFT.getCode()))) {
                            skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
                        }
                        skuDTO.setApprovalStatus(DycProCommConstants.ApprovalStatus.ON_SHELVE_IN_APPROVAL);
                        reqBO.setBusiType(PublicProcInstBusiType.AGR_SKU_ON_SHELVES_APPROVE.getCode());
                    } else {
                        operateRecordFlag = true;
                        skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                        skuDTO.setOnShelveTime(new Date(System.currentTimeMillis()));
                    }
                } else if (skuDetails.getSkuStatus().equals(Integer.parseInt(DmcCommSkuInfoSkuStatus.DRAFT.getCode()))) {
                    skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
                }
            }
            DycProEsIndexMappingSkuBO dycProEsIndexMappingSkuBO = this.dycProCommSkuRepository.updateSkuCompleteInfoAndSyncNosql(skuDTO);
            auditPakageObjDTO = (DycProCommAuditPakageObjDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProEsIndexMappingSkuBO), DycProCommAuditPakageObjDTO.class);
            if (operateRecordFlag) {
                this.insertOperateRecord(skuDetails, reqBO);
            }
        }
        return auditPakageObjDTO;
    }

    private void computeSkuPrice(DycProCommSkuDTO skuDTO, DycProCommSkuHandleDTO skuDetails) {
        DycProCommSkuPriceInfoHandleDTO handleDTO = new DycProCommSkuPriceInfoHandleDTO();
        handleDTO.setSupplierPrice(skuDTO.getPriceInfo().getSupplierPrice());
        handleDTO.setMarketPrice(skuDTO.getPriceInfo().getMarketPrice());
        handleDTO.setSupplierId(skuDetails.getSupplierId());
        handleDTO.setAgrId(skuDTO.getAgrId());
        handleDTO.setSkuId(skuDTO.getSkuId());
        handleDTO.setManageCatalogPath(skuDTO.getManageCatalogPath());
        handleDTO.setManageCatalogId(skuDTO.getManageCatalogId());
        handleDTO.setPriceRuleType(DycProCommConstants.PriceRuleType.AGR);
        DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO = this.dycProCommPriceRuleInfoRepository.computeSkuPrice(handleDTO);
        skuDTO.getPriceInfo().setLadderPriceRule(dycProCommSkuPriceInfoDTO.getLadderPriceRule());
        skuDTO.getPriceInfo().setPriceRiseRate(dycProCommSkuPriceInfoDTO.getPriceRiseRate());
        skuDTO.getPriceInfo().setPriceRiseType(dycProCommSkuPriceInfoDTO.getPriceRiseType());
        skuDTO.getPriceInfo().setPriceRuleId(dycProCommSkuPriceInfoDTO.getPriceRuleId());
        skuDTO.getPriceInfo().setPriority(dycProCommSkuPriceInfoDTO.getPriority());
        skuDTO.getPriceInfo().setSalePrice(dycProCommSkuPriceInfoDTO.getSalePrice());
    }

    private void insertAuditPackage(Long auditPackageId, DycProCommAuditPakageObjDTO auditPakageObjDTO) {
        DycProCommAuditPackageInfoDTO dycProCommAuditPackageInfoDTO = new DycProCommAuditPackageInfoDTO();
        dycProCommAuditPackageInfoDTO.setAuditPackageId(auditPackageId);
        ArrayList<DycProCommAuditPakageObjDTO> auditPackageObjDTOList = new ArrayList<DycProCommAuditPakageObjDTO>();
        auditPackageObjDTOList.add(auditPakageObjDTO);
        for (DycProCommAuditPakageObjDTO commAuditPackageObjDTO : auditPackageObjDTOList) {
            commAuditPackageObjDTO.setCreateTime(new Date(System.currentTimeMillis()));
            commAuditPackageObjDTO.setAuditPackageId(auditPackageId);
            commAuditPackageObjDTO.setDelTag(DycProCommConstants.DelFlag.NO);
        }
        dycProCommAuditPackageInfoDTO.setAuditPakageObjDTOList(auditPackageObjDTOList);
        this.dycProCommPublicProcTaskInstRepository.addAuditPackageBatch(dycProCommAuditPackageInfoDTO);
    }

    private void insertOperateRecord(DycProCommSkuHandleDTO skuDTO, DycProCommAgrSkuUpdateReqBO reqBO) {
        ArrayList<DycProCommOperateRecordDTO> operateRecordPOList = new ArrayList<DycProCommOperateRecordDTO>();
        DycProCommOperateRecordDTO commOperateRecordPO = new DycProCommOperateRecordDTO();
        commOperateRecordPO.setObjId(skuDTO.getSkuId());
        commOperateRecordPO.setObjCode(skuDTO.getSkuCode());
        commOperateRecordPO.setObjType(DycProCommConstants.OperateRecordObjType.SKU);
        commOperateRecordPO.setOperateTime(new Date(System.currentTimeMillis()));
        commOperateRecordPO.setOperateUserId(reqBO.getUserId());
        commOperateRecordPO.setOperateUserAccount(reqBO.getUserName());
        commOperateRecordPO.setOperateUserName(reqBO.getName());
        commOperateRecordPO.setOperateUserType(DycProCommConstants.OperateUserType.USER);
        commOperateRecordPO.setOperateReason("\u521b\u5efa\u5546\u54c1\u65f6\u9009\u62e9\u4e86\u7acb\u5373\u4e0a\u67b6\uff0c\u4e14\u4e0d\u9700\u8981\u4e0a\u67b6\u5ba1\u6279");
        commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getCode())));
        commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getValue());
        commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getCode())));
        commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getValue());
        operateRecordPOList.add(commOperateRecordPO);
        this.dycProCommOperateRecordRepository.addOperateRecordBatch(operateRecordPOList);
    }

    private void checkFilterBans(List<Long> skuIds) {
        DycProCommBansRecordInfoHandleDTO dycProCommBansRecordInfoHandleDTO = new DycProCommBansRecordInfoHandleDTO();
        dycProCommBansRecordInfoHandleDTO.setSkuIdList(skuIds);
        Date now = new Date();
        dycProCommBansRecordInfoHandleDTO.setBansEndDate(now);
        dycProCommBansRecordInfoHandleDTO.setBansStartDate(now);
        List dycProCommBansRecordInfoHandleDTOS = this.dycProCommBansRecordRepository.qrySkuBansCount(dycProCommBansRecordInfoHandleDTO);
        if (!CollectionUtils.isEmpty((Collection)dycProCommBansRecordInfoHandleDTOS)) {
            for (DycProCommBansRecordInfoHandleDTO proCommBansRecordInfoHandleDTO : dycProCommBansRecordInfoHandleDTOS) {
                if (proCommBansRecordInfoHandleDTO.getCount() <= 0L) continue;
                skuIds.remove(proCommBansRecordInfoHandleDTO.getSkuId());
            }
        }
    }

    private void judge(DycProCommAgrSkuUpdateReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new ZTBusinessException("\u3010\u64cd\u4f5c\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getMiniFlag())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u6781\u7b80\u6807\u8bc6\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUccApproveOnShelveAgreementSwitch())) {
            throw new ZTBusinessException("\u3010\u4e0a\u67b6\u5ba1\u6279\u5f00\u5173\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUccApproveEditAgreementSwitch())) {
            throw new ZTBusinessException("\u3010\u7f16\u8f91\u5ba1\u6279\u5f00\u5173\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUpdateSkuInfo())) {
            throw new ZTBusinessException("\u3010sku\u4fee\u6539\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProCommAgrSkuBO updateSkuInfo = reqBO.getUpdateSkuInfo();
        if (ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuId())) {
            throw new ZTBusinessException("\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperType() == 1) {
            if (ObjectUtils.isEmpty((Object)updateSkuInfo.getOnShelveWay())) {
                throw new ZTBusinessException("\u3010\u4e0a\u67b6\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)updateSkuInfo.getManageCatalogId())) {
                throw new ZTBusinessException("\u3010\u5c5e\u6027\u6a21\u7248id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getPriceInfo()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getPriceInfo().getPriceId())) {
                throw new ZTBusinessException("\u3010\u4ef7\u683cID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo())) {
                if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && DycProCommConstants.IsAllowAfterSale.YES.equals(updateSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getReturnTimeLimit())) {
                    throw new ZTBusinessException("\u3010\u9000\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && DycProCommConstants.IsAllowAfterSale.YES.equals(updateSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getReturnTimeLimit())) {
                    throw new ZTBusinessException("\u3010\u9000\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getIsAllowChange()) && DycProCommConstants.IsAllowAfterSale.YES.equals(updateSkuInfo.getSkuAfterSaleInfo().getIsAllowChange()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getChangeTimeLimit())) {
                    throw new ZTBusinessException("\u3010\u6362\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getIsAllowMaintain()) && DycProCommConstants.IsAllowAfterSale.YES.equals(updateSkuInfo.getSkuAfterSaleInfo().getIsAllowMaintain()) && ObjectUtils.isEmpty((Object)updateSkuInfo.getSkuAfterSaleInfo().getMaintainTimeLimit())) {
                    throw new ZTBusinessException("\u3010\u7ef4\u4fee\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)updateSkuInfo.getSkuPicInfoList())) {
                for (DycProCommSkuPicApiBO each : updateSkuInfo.getSkuPicInfoList()) {
                    if (ObjectUtils.isEmpty((Object)each.getPicType())) {
                        throw new ZTBusinessException("\u3010\u56fe\u7247\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (ObjectUtils.isEmpty((Object)each.getPicUrl())) {
                        throw new ZTBusinessException("\u3010\u56fe\u7247url\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!ObjectUtils.isEmpty((Object)each.getShowOrder())) continue;
                    throw new ZTBusinessException("\u3010\u56fe\u7247\u5c55\u793a\u987a\u5e8f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }
}

