/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.managecatalog.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommManageCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommQryManageCatalogQryDTO;
import com.tydic.dyc.pro.dmc.service.managecatalog.api.DycProCommEditManageCatalogService;
import com.tydic.dyc.pro.dmc.service.managecatalog.bo.DycProCommEditManageCatalogReqBO;
import com.tydic.dyc.pro.dmc.service.managecatalog.bo.DycProCommEditManageCatalogRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.managecatalog.api.DycProCommEditManageCatalogService"})
public class DycProCommEditManageCatalogServiceImpl
implements DycProCommEditManageCatalogService {
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;

    @Override
    @PostMapping(value={"editManageCatalog"})
    public DycProCommEditManageCatalogRspBO editManageCatalog(@RequestBody DycProCommEditManageCatalogReqBO reqBO) {
        DycProCommEditManageCatalogRspBO rspBO = new DycProCommEditManageCatalogRspBO();
        this.validateParam(reqBO);
        DycProCommManageCatalogDTO dycProCommManageCatalogQryDTO = new DycProCommManageCatalogDTO();
        dycProCommManageCatalogQryDTO.setManageCatalogId(reqBO.getManageCatalogId());
        DycProCommManageCatalogDTO detail = this.dycProCommManageCatalogRepository.qryManageCatalogDetail(dycProCommManageCatalogQryDTO);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getManageCatalogName()) && !reqBO.getManageCatalogName().equals(detail.getManageCatalogName())) {
            DycProCommQryManageCatalogQryDTO sameLevelDTO = new DycProCommQryManageCatalogQryDTO();
            sameLevelDTO.setManageCatalogParentId(detail.getManageCatalogParentId());
            List sameLevelList = this.dycProCommManageCatalogRepository.qryManageCatalogListByCondition(sameLevelDTO);
            if (!CollectionUtils.isEmpty((Collection)sameLevelList)) {
                for (DycProCommManageCatalogDTO sameLevel : sameLevelList) {
                    if (!sameLevel.getManageCatalogName().equals(reqBO.getManageCatalogName())) continue;
                    throw new ZTBusinessException("\u540c\u7ea7\u5b50\u7c7b\u76ee\u4e0d\u5141\u8bb8\u5b58\u5728\u540c\u540d");
                }
            }
        }
        DycProCommManageCatalogDTO editManageCatalogDTO = new DycProCommManageCatalogDTO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)editManageCatalogDTO);
        if (null != reqBO.getEnableFlag() && reqBO.getEnableFlag().equals(DycProCommConstants.ManageCatalogEnableFlag.DISABLE)) {
            int relPoolNum;
            int relChannelNum;
            int relGoodsNum = this.dycProCommManageCatalogRepository.qryManageCatalogRelGoodsNum(editManageCatalogDTO);
            if (relGoodsNum > 0) {
                rspBO.setIsRelatedComm(true);
            }
            if ((relChannelNum = this.dycProCommManageCatalogRepository.qryManageCatalogRelChannelNum(editManageCatalogDTO)) > 0) {
                rspBO.setIsRelatedChannel(true);
            }
            if ((relPoolNum = this.dycProCommManageCatalogRepository.qryManageCatalogRelPoolNum(editManageCatalogDTO)) > 0) {
                rspBO.setIsRelatedPool(true);
            }
        }
        if (rspBO.getIsRelatedComm().booleanValue() || rspBO.getIsRelatedChannel().booleanValue() || rspBO.getIsRelatedPool().booleanValue()) {
            return rspBO;
        }
        editManageCatalogDTO.setUpdateUserId(reqBO.getUserId());
        editManageCatalogDTO.setUpdateUserName(reqBO.getName());
        editManageCatalogDTO.setUpdateUserAccount(reqBO.getUserName());
        editManageCatalogDTO.setUpdateOrgId(reqBO.getOrgId());
        editManageCatalogDTO.setUpdateOrgName(reqBO.getOrgName());
        editManageCatalogDTO.setUpdateOrgPath(reqBO.getOrgPath());
        editManageCatalogDTO.setUpdateCompanyId(reqBO.getCompanyId());
        editManageCatalogDTO.setUpdateCompanyName(reqBO.getCompanyName());
        editManageCatalogDTO.setUpdateTime(new Date());
        this.dycProCommManageCatalogRepository.editManageCatalog(editManageCatalogDTO);
        return rspBO;
    }

    private void validateParam(DycProCommEditManageCatalogReqBO reqBO) {
        if (null == reqBO.getManageCatalogId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010manageCatalogId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

