/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.managecatalog.impl;

import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommManageCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommQryManageCatalogQryDTO;
import com.tydic.dyc.pro.dmc.service.managecatalog.api.DycProCommMoveManageCatalogService;
import com.tydic.dyc.pro.dmc.service.managecatalog.bo.DycProCommMoveManageCatalogReqBO;
import com.tydic.dyc.pro.dmc.service.managecatalog.bo.DycProCommMoveManageCatalogRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.managecatalog.api.DycProCommMoveManageCatalogService"})
public class DycProCommMoveManageCatalogServiceImpl
implements DycProCommMoveManageCatalogService {
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @PostMapping(value={"moveManageCatalog"})
    public DycProCommMoveManageCatalogRspBO moveManageCatalog(@RequestBody DycProCommMoveManageCatalogReqBO reqBO) {
        DycProCommMoveManageCatalogRspBO rspBO = new DycProCommMoveManageCatalogRspBO();
        this.validateParam(reqBO);
        DycProCommQryManageCatalogQryDTO qrySelectManageCatalogDTO = new DycProCommQryManageCatalogQryDTO();
        qrySelectManageCatalogDTO.setManageCatalogId(reqBO.getSelectManageCatalogId());
        DycProCommManageCatalogDTO selectedCatalog = this.dycProCommManageCatalogRepository.qryManageCatalogDetail((DycProCommManageCatalogDTO)qrySelectManageCatalogDTO);
        if (selectedCatalog == null) {
            throw new ZTBusinessException("\u672a\u627e\u5230\u9009\u4e2d\u7684\u76ee\u5f55\u4fe1\u606f");
        }
        DycProCommQryManageCatalogQryDTO sameLevelDTO = new DycProCommQryManageCatalogQryDTO();
        sameLevelDTO.setManageCatalogParentId(selectedCatalog.getManageCatalogParentId());
        List sameLevelList = this.dycProCommManageCatalogRepository.qryManageCatalogListByCondition(sameLevelDTO);
        if (CollectionUtils.isEmpty((Collection)sameLevelList) || sameLevelList.size() < 2) {
            throw new ZTBusinessException("\u6ca1\u6709\u53ef\u79fb\u52a8\u7684\u540c\u7ea7\u76ee\u5f55");
        }
        sameLevelList.sort(Comparator.comparing(DycProCommManageCatalogDTO::getManageCatalogOrder));
        int selectedIndex = -1;
        for (int i = 0; i < sameLevelList.size(); ++i) {
            if (!reqBO.getSelectManageCatalogId().equals(((DycProCommManageCatalogDTO)sameLevelList.get(i)).getManageCatalogId())) continue;
            selectedIndex = i;
            break;
        }
        if (selectedIndex == -1) {
            throw new ZTBusinessException("\u9009\u4e2d\u76ee\u5f55\u4e0d\u5728\u540c\u7ea7\u5217\u8868\u4e2d");
        }
        DycProCommManageCatalogDTO targetNode = null;
        if (DycProCommConstants.MobileFlag.UP.equals(reqBO.getMobileFlag())) {
            if (selectedIndex <= 0) throw new ZTBusinessException("\u5df2\u7ecf\u662f\u7b2c\u4e00\u4e2a\u7c7b\u76ee\uff0c\u65e0\u6cd5\u4e0a\u79fb");
            targetNode = (DycProCommManageCatalogDTO)sameLevelList.get(selectedIndex - 1);
        } else {
            if (!DycProCommConstants.MobileFlag.DOWN.equals(reqBO.getMobileFlag())) throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u79fb\u52a8\u65b9\u5411");
            if (selectedIndex >= sameLevelList.size() - 1) throw new ZTBusinessException("\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a\u7c7b\u76ee\uff0c\u65e0\u6cd5\u4e0b\u79fb");
            targetNode = (DycProCommManageCatalogDTO)sameLevelList.get(selectedIndex + 1);
        }
        Integer tempOrder = selectedCatalog.getManageCatalogOrder();
        selectedCatalog.setManageCatalogOrder(targetNode.getManageCatalogOrder());
        targetNode.setManageCatalogOrder(tempOrder);
        ArrayList<DycProCommManageCatalogDTO> updateList = new ArrayList<DycProCommManageCatalogDTO>();
        updateList.add(selectedCatalog);
        updateList.add(targetNode);
        this.dycProCommManageCatalogRepository.updateBatchManageCatalogBy(updateList);
        return rspBO;
    }

    private void validateParam(DycProCommMoveManageCatalogReqBO reqBO) {
        if (null == reqBO.getSelectManageCatalogId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010selectManageCatalogId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getSelectManageCatalogOrder()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010selectManageCatalogOrder\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getMobileFlag()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010mobileFlag\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

