/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.pricerule.impl;

import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommManageCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommQryManageCatalogQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleSkuRangeInfoDTO;
import com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommQueryPriceRuleCatalogTreeService;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommPriceRuleCatalogTreeBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommQueryPriceRuleCatalogTreeReqBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommQueryPriceRuleCatalogTreeRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommQueryPriceRuleCatalogTreeService"})
public class DycProCommQueryPriceRuleCatalogTreeServiceImpl
implements DycProCommQueryPriceRuleCatalogTreeService {
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;

    @Override
    @PostMapping(value={"queryPriceRuleCatalogTree"})
    public DycProCommQueryPriceRuleCatalogTreeRspBO queryPriceRuleCatalogTree(@RequestBody DycProCommQueryPriceRuleCatalogTreeReqBO reqBO) {
        DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO;
        List<Object> catalogBOS = new ArrayList();
        if (reqBO.getAgrId() == null) {
            catalogBOS = this.getAllCatalog();
        } else {
            dycProCommPriceRuleInfoQryDTO = new DycProCommPriceRuleInfoQryDTO();
            dycProCommPriceRuleInfoQryDTO.setAgrId(reqBO.getAgrId());
            List agrCatalogDTOList = this.dycProCommPriceRuleInfoRepository.queryAgrCatalog(dycProCommPriceRuleInfoQryDTO);
            catalogBOS = CollectionUtils.isEmpty((Collection)agrCatalogDTOList) ? this.getAllCatalog() : JSONArray.parseArray((String)JSONArray.toJSONString((Object)agrCatalogDTOList), DycProCommPriceRuleCatalogTreeBO.class);
        }
        if (reqBO.getPriceRuleId() != null) {
            dycProCommPriceRuleInfoQryDTO = new DycProCommPriceRuleInfoQryDTO();
            dycProCommPriceRuleInfoQryDTO.setPriceRuleId(reqBO.getPriceRuleId());
            dycProCommPriceRuleInfoQryDTO.setValueShiwFlag(DycProCommConstants.ValueShowFlag.SHOW);
            List dto = this.dycProCommPriceRuleInfoRepository.queryPriceRuleSkuRangeList(dycProCommPriceRuleInfoQryDTO);
            Map map = dto.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getCatalogId, Function.identity()));
            catalogBOS.forEach(dycProCommPriceRuleCatalogBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO temp = (DycProCommPriceRuleSkuRangeInfoDTO)map.get(dycProCommPriceRuleCatalogBO.getCatalogId());
                if (temp != null) {
                    dycProCommPriceRuleCatalogBO.setPriceRiseType(temp.getPriceRiseType());
                    dycProCommPriceRuleCatalogBO.setPriceRiseRate(temp.getPriceRiseRate());
                    dycProCommPriceRuleCatalogBO.setLadderPriceRule(temp.getLadderPriceRule());
                }
            });
        }
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        for (Object row : catalogBOS) {
            map.put(((DycProCommPriceRuleCatalogTreeBO)row).getCatalogId(), row);
        }
        ArrayList<DycProCommPriceRuleCatalogTreeBO> tree = new ArrayList<DycProCommPriceRuleCatalogTreeBO>();
        for (DycProCommPriceRuleCatalogTreeBO dycProCommPriceRuleCatalogTreeBO : catalogBOS) {
            Long parentId = dycProCommPriceRuleCatalogTreeBO.getParentCatalogId();
            if (parentId == null || !map.containsKey(parentId)) {
                tree.add(dycProCommPriceRuleCatalogTreeBO);
                continue;
            }
            DycProCommPriceRuleCatalogTreeBO parent = (DycProCommPriceRuleCatalogTreeBO)map.get(parentId);
            if (parent.getChildren() == null) {
                parent.setChildren(new ArrayList<DycProCommPriceRuleCatalogTreeBO>());
                parent.setLastLevelFlag(0);
            }
            parent.getChildren().add(dycProCommPriceRuleCatalogTreeBO);
        }
        DycProCommQueryPriceRuleCatalogTreeRspBO rspBO = new DycProCommQueryPriceRuleCatalogTreeRspBO();
        rspBO.setRows(tree);
        return rspBO;
    }

    private List<DycProCommPriceRuleCatalogTreeBO> getAllCatalog() {
        ArrayList<DycProCommPriceRuleCatalogTreeBO> catalogBOS = new ArrayList<DycProCommPriceRuleCatalogTreeBO>();
        DycProCommQryManageCatalogQryDTO qryDTO = new DycProCommQryManageCatalogQryDTO();
        List dycProCommManageCatalogDTOList = this.dycProCommManageCatalogRepository.qryManageCatalogListByCondition(qryDTO);
        for (DycProCommManageCatalogDTO dto : dycProCommManageCatalogDTOList) {
            DycProCommPriceRuleCatalogTreeBO dycProCommPriceRuleCatalogBO = new DycProCommPriceRuleCatalogTreeBO();
            dycProCommPriceRuleCatalogBO.setCatalogId(dto.getManageCatalogId());
            dycProCommPriceRuleCatalogBO.setCatalogName(dto.getManageCatalogName());
            dycProCommPriceRuleCatalogBO.setParentCatalogId(dto.getManageCatalogParentId());
            dycProCommPriceRuleCatalogBO.setLastLevelFlag(dto.getLastLevelFlag());
            catalogBOS.add(dycProCommPriceRuleCatalogBO);
        }
        return catalogBOS;
    }
}

