/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.pricerule.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceChngRecordDTO;
import com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommQuerySkuPriceChngRecordListService;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommLadderPriceRuleBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommQuerySkuPriceChngRecordListReqBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommQuerySkuPriceChngRecordListRspBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommSkuPriceChngRecordBO;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommQuerySkuPriceChngRecordListService"})
public class DycProCommQuerySkuPriceChngRecordListServiceImpl
implements DycProCommQuerySkuPriceChngRecordListService {
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;

    @Override
    @PostMapping(value={"querySkuPriceChngRecordList"})
    public DycProCommQuerySkuPriceChngRecordListRspBO querySkuPriceChngRecordList(@RequestBody DycProCommQuerySkuPriceChngRecordListReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getSkuId())) {
            throw new ZTBusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DycProCommQuerySkuPriceChngRecordListRspBO rspBO = new DycProCommQuerySkuPriceChngRecordListRspBO();
        DycProCommSkuPriceChngRecordDTO qryChngRecordDTO = new DycProCommSkuPriceChngRecordDTO();
        qryChngRecordDTO.setSkuId(reqBO.getSkuId());
        qryChngRecordDTO.setChngStartTime(reqBO.getChngStartTime());
        qryChngRecordDTO.setChngEndTime(reqBO.getChngEndTime());
        List chngRecordList = this.dycProCommPriceRuleInfoRepository.getSkuPriceChngRecordList(qryChngRecordDTO);
        if (!ObjectUtils.isEmpty((Object)chngRecordList)) {
            List rows = JSON.parseArray((String)JSON.toJSONString((Object)chngRecordList), DycProCommSkuPriceChngRecordBO.class);
            if (reqBO.getLatestRecordsByDateFlag().booleanValue()) {
                this.deduplicateByDate(rows);
            }
            rows.forEach(item -> {
                item.setSkuCode(reqBO.getSkuCode());
                item.setSkuName(reqBO.getSkuName());
                item.setSupplierName(reqBO.getSupplierName());
                item.setManageCatalogPathName(reqBO.getManageCatalogPathName());
                item.setSkuSource(reqBO.getSkuSource());
                if (DycProCommConstants.PriceRiseType.RATE.equals(item.getPriceRiseType())) {
                    item.setPriceRiseRate(item.getPriceRiseRate());
                } else {
                    item.setPriceRiseValue(item.getPriceRiseRate());
                    item.setPriceRiseRate(null);
                }
                if (!ObjectUtils.isEmpty((Object)item.getLadderPriceRule())) {
                    item.setLadderPriceRuleBOList(JSON.parseArray((String)item.getLadderPriceRule(), DycProCommLadderPriceRuleBO.class));
                    item.getLadderPriceRuleBOList().forEach(ladderPrice -> {
                        if (null != ladderPrice.getLeftValue() && null != ladderPrice.getRightValue()) {
                            ladderPrice.setShowValue(ladderPrice.getLeftValue() + "-" + ladderPrice.getRightValue() + ladderPrice.getMeasureName() + ":\u00a5" + ladderPrice.getPrice());
                        }
                        if (null != ladderPrice.getLeftValue() && null == ladderPrice.getRightValue()) {
                            ladderPrice.setShowValue(">=" + ladderPrice.getLeftValue() + ladderPrice.getMeasureName() + ":\u00a5" + ladderPrice.getPrice());
                        }
                    });
                }
            });
            DycProCommSkuPriceChngRecordBO maxRecord = rows.stream().max(Comparator.comparing(DycProCommSkuPriceChngRecordBO::getChngTime)).get();
            if (rows.size() == 1 || !DycProCommQuerySkuPriceChngRecordListServiceImpl.isSameDay(maxRecord.getChngTime(), new Date())) {
                DycProCommSkuPriceChngRecordBO mockRecord = new DycProCommSkuPriceChngRecordBO();
                BeanUtils.copyProperties((Object)maxRecord, (Object)mockRecord);
                mockRecord.setIsMockRecord(true);
                mockRecord.setChngTime(new Date());
                rows.add(mockRecord);
            }
            rspBO.setRows(rows);
        }
        return rspBO;
    }

    private void deduplicateByDate(List<DycProCommSkuPriceChngRecordBO> records) {
        Map<LocalDate, DycProCommSkuPriceChngRecordBO> latestRecordsByDate = records.stream().collect(Collectors.toMap(this::getLocalDate, record -> record, (existing, replacement) -> existing.getChngTime().after(replacement.getChngTime()) ? existing : replacement));
        ArrayList<DycProCommSkuPriceChngRecordBO> result = new ArrayList<DycProCommSkuPriceChngRecordBO>(latestRecordsByDate.values());
        result.sort(Comparator.comparing(DycProCommSkuPriceChngRecordBO::getChngTime));
    }

    private LocalDate getLocalDate(DycProCommSkuPriceChngRecordBO record) {
        return record.getChngTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        LocalDate localDate1 = date1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate1.isEqual(localDate2);
    }
}

