/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.base.bo.DycProBaseManagePageRspBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingBansRuleBO;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuQryDTO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommLadderPriceRuleBO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuListPageQryEsService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuDetailsInfoBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuListPageQryEsBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuListPageQryEsReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuListPageQryEsRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommSkuListPageQryEsService"})
public class DycProCommSkuListPageQryEsServiceImpl
implements DycProCommSkuListPageQryEsService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommSkuListPageQryEsServiceImpl.class);
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;

    @Override
    @PostMapping(value={"qryEsSkuListPage"})
    public DycProCommSkuListPageQryEsRspBO qryEsSkuListPage(@RequestBody DycProCommSkuListPageQryEsReqBO reqBO) {
        DycProCommSkuQryDTO reqDto = (DycProCommSkuQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProCommSkuQryDTO.class);
        DycProBaseManagePageRspBO baseManagePageRspBO = this.dycProCommSkuRepository.qryEsSkuListPage(reqDto);
        DycProCommSkuListPageQryEsRspBO dycProCommSkuListPageQryEsRspBO = (DycProCommSkuListPageQryEsRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)baseManagePageRspBO), DycProCommSkuListPageQryEsRspBO.class));
        if (!CollectionUtils.isEmpty((Collection)dycProCommSkuListPageQryEsRspBO.getRows())) {
            Map<Object, Object> skuDetailMap = new HashMap();
            DycProCommSkuQryDTO dycProCommSkuQryDTO = new DycProCommSkuQryDTO();
            dycProCommSkuQryDTO.setSkuIds(dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsBO::getSkuId).collect(Collectors.toList()));
            List detailList = this.dycProCommSkuRepository.getDetailList(dycProCommSkuQryDTO);
            if (!CollectionUtils.isEmpty((Collection)detailList)) {
                skuDetailMap = detailList.stream().collect(Collectors.toMap(DycProCommSkuDetailsInfoDTO::getSkuId, o -> o, (o1, o2) -> o1));
            }
            for (DycProCommSkuListPageQryEsBO bo : dycProCommSkuListPageQryEsRspBO.getRows()) {
                DycProCommSkuDetailsInfoDTO dycProCommSkuDetailsInfoDTO;
                if (null != bo.getSkuStatus()) {
                    bo.setSkuStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoSkuStatus", (String)bo.getSkuStatus().toString()));
                }
                if (null != bo.getApprovalStatus()) {
                    bo.setApprovalStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoApprovalStatus", (String)bo.getApprovalStatus().toString()));
                }
                if (null != bo.getExamineStatus()) {
                    bo.setExamineStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoExamineStatus", (String)bo.getExamineStatus().toString()));
                }
                if (DycProCommConstants.PriceRiseType.RATE.equals(bo.getPriceRiseType())) {
                    bo.setPriceRiseRate(bo.getPriceRiseRate());
                } else {
                    bo.setPriceRiseValue(bo.getPriceRiseRate());
                    bo.setPriceRiseRate(null);
                }
                if (!ObjectUtils.isEmpty((Object)bo.getLadderPriceRule())) {
                    bo.setLadderPriceRuleBOList(JSON.parseArray((String)bo.getLadderPriceRule(), DycProCommLadderPriceRuleBO.class));
                    bo.getLadderPriceRuleBOList().forEach(ladderPrice -> {
                        if (null != ladderPrice.getLeftValue() && null != ladderPrice.getRightValue()) {
                            ladderPrice.setShowValue(ladderPrice.getLeftValue() + "-" + ladderPrice.getRightValue() + ladderPrice.getMeasureName() + ":\u00a5" + ladderPrice.getPrice());
                        }
                        if (null != ladderPrice.getLeftValue() && null == ladderPrice.getRightValue()) {
                            ladderPrice.setShowValue(">=" + ladderPrice.getLeftValue() + ladderPrice.getMeasureName() + ":\u00a5" + ladderPrice.getPrice());
                        }
                    });
                }
                if (!CollectionUtils.isEmpty(bo.getBansRuleList())) {
                    List<DycProEsIndexMappingBansRuleBO> usefulBansRuleList = bo.getBansRuleList().stream().filter(rule -> rule.getBansStartDate().before(new Date()) && rule.getBansEndDate().after(new Date())).collect(Collectors.toList());
                    bo.setBansRuleList(usefulBansRuleList);
                    if (!CollectionUtils.isEmpty(usefulBansRuleList)) {
                        StringJoiner bansReasonStr = new StringJoiner(",");
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        usefulBansRuleList.forEach(bansRule -> {
                            if (DycProCommConstants.BansType.BANS_RULE.equals(bansRule.getBansType())) {
                                bansReasonStr.add(bansRule.getBansReason() + " " + formatter.format(bansRule.getBansStartDate()) + "\uff5e" + formatter.format(bansRule.getBansEndDate()));
                            } else {
                                bansReasonStr.add(bansRule.getBansReason() + " " + formatter.format(bansRule.getBansStartDate()));
                            }
                        });
                        bo.setBansReason(bansReasonStr.toString());
                        bo.setBansFlag(DycProCommConstants.BansFlag.YES);
                        bo.setBansFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoBansFlag", (String)bo.getBansFlag().toString()));
                    } else {
                        bo.setBansFlag(DycProCommConstants.BansFlag.NO);
                        bo.setBansFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoBansFlag", (String)bo.getBansFlag().toString()));
                    }
                } else {
                    bo.setBansFlag(DycProCommConstants.BansFlag.NO);
                    bo.setBansFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommSkuInfoBansFlag", (String)bo.getBansFlag().toString()));
                }
                if (skuDetailMap.containsKey(bo.getSkuId()) && null != (dycProCommSkuDetailsInfoDTO = (DycProCommSkuDetailsInfoDTO)skuDetailMap.get(bo.getSkuId()))) {
                    bo.setDetailInfo((DycProCommSkuDetailsInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommSkuDetailsInfoDTO), DycProCommSkuDetailsInfoBO.class));
                }
                if (null != bo.getSalePrice()) {
                    bo.setSalePrice(bo.getSalePrice().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getSupplierPrice()) {
                    bo.setSupplierPrice(bo.getSupplierPrice().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getMarketPrice()) {
                    bo.setMarketPrice(bo.getMarketPrice().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getDiscountRate()) {
                    bo.setDiscountRate(bo.getDiscountRate().setScale(2, RoundingMode.DOWN));
                }
                if (null != bo.getGuidedPrice()) {
                    bo.setGuidedPrice(bo.getGuidedPrice().setScale(2, RoundingMode.DOWN));
                }
                if (null == bo.getThirdReferPrice()) continue;
                bo.setThirdReferPrice(bo.getThirdReferPrice().setScale(2, RoundingMode.DOWN));
            }
            dycProCommSkuListPageQryEsRspBO.setSalePriceRange("\u00a5" + dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsBO::getSalePrice).filter(Objects::nonNull).min(BigDecimal::compareTo).get() + "\uff5e" + dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsBO::getSalePrice).filter(Objects::nonNull).max(BigDecimal::compareTo).get());
            dycProCommSkuListPageQryEsRspBO.setSupplierPriceRange("\u00a5" + dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsBO::getSupplierPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).get() + "\uff5e" + dycProCommSkuListPageQryEsRspBO.getRows().stream().map(DycProCommSkuListPageQryEsBO::getSupplierPrice).filter(Objects::nonNull).max(BigDecimal::compareTo).get());
        }
        return dycProCommSkuListPageQryEsRspBO;
    }
}

