/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommExtSkuMessageRecordsMapper;
import com.tydic.dyc.pro.dmc.po.CommExtSkuMessageRecordsPO;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.api.DycProCommExtSkuMessageRecordsRepository;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.dto.DycProCommExtSkuMessageRecordsDTO;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.dto.DycProCommExtSkuMessageRecordsQueryDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProCommExtSkuMessageRecordsRepositoryImpl
implements DycProCommExtSkuMessageRecordsRepository {
    @Autowired
    private CommExtSkuMessageRecordsMapper commExtSkuMessageRecordsMapper;

    @Override
    public void addExtSkuMessageRecords(List<DycProCommExtSkuMessageRecordsDTO> recordsList) {
        ArrayList<CommExtSkuMessageRecordsPO> addExtSkuMessageRecordsList = new ArrayList<CommExtSkuMessageRecordsPO>();
        for (DycProCommExtSkuMessageRecordsDTO dycProCommExtSkuMessageRecordsDTO : recordsList) {
            CommExtSkuMessageRecordsPO commExtSkuMessageRecordsPO = new CommExtSkuMessageRecordsPO();
            BeanUtils.copyProperties((Object)dycProCommExtSkuMessageRecordsDTO, (Object)commExtSkuMessageRecordsPO);
            commExtSkuMessageRecordsPO.setRecordId(Long.valueOf(Sequence.getInstance().nextId()));
            commExtSkuMessageRecordsPO.setMessageReceiveTime(new Date());
            commExtSkuMessageRecordsPO.setMessageStatus(DycProCommConstants.ExtSkuMsgStatus.PENDING);
            commExtSkuMessageRecordsPO.setSupplierName(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommExtSkuMessageRecordsSupplierHsn", (String)dycProCommExtSkuMessageRecordsDTO.getSupplierHsn()));
            commExtSkuMessageRecordsPO.setCurrentTurn(Integer.valueOf(0));
            addExtSkuMessageRecordsList.add(commExtSkuMessageRecordsPO);
        }
        this.commExtSkuMessageRecordsMapper.insertBatch(addExtSkuMessageRecordsList);
    }

    @Override
    public DycProCommExtSkuMessageRecordsDTO selectUndealMsgForTimeTask(DycProCommExtSkuMessageRecordsQueryDTO queryDTO) {
        CommExtSkuMessageRecordsPO recordsPO = new CommExtSkuMessageRecordsPO();
        recordsPO.setSupplierHsn(queryDTO.getDycProCommExtSkuMessageRecordsDTO().getSupplierHsn());
        CommExtSkuMessageRecordsPO commExtSkuMessageRecordsPO = this.commExtSkuMessageRecordsMapper.selectUndealMsgForTimeTask(recordsPO, queryDTO.getTotalThread(), queryDTO.getMod(), queryDTO.getDealMsgMaxCount());
        if (null == commExtSkuMessageRecordsPO) {
            return null;
        }
        DycProCommExtSkuMessageRecordsDTO recordsDTO = new DycProCommExtSkuMessageRecordsDTO();
        BeanUtils.copyProperties((Object)commExtSkuMessageRecordsPO, (Object)recordsDTO);
        return recordsDTO;
    }

    @Override
    public void updateMessageRecordsByCondition(DycProCommExtSkuMessageRecordsDTO recordsDTO) {
        CommExtSkuMessageRecordsPO updateRecordsPO = new CommExtSkuMessageRecordsPO();
        BeanUtils.copyProperties((Object)recordsDTO, (Object)updateRecordsPO);
        this.commExtSkuMessageRecordsMapper.update((Object)updateRecordsPO, (Wrapper)Wrappers.lambdaQuery().eq(CommExtSkuMessageRecordsPO::getExtSkuId, (Object)recordsDTO.getExtSkuId()));
    }

    @Override
    public int preUndealMsgByCondition(DycProCommExtSkuMessageRecordsDTO recordsDTO) {
        CommExtSkuMessageRecordsPO updateRecordsPO = new CommExtSkuMessageRecordsPO();
        BeanUtils.copyProperties((Object)recordsDTO, (Object)updateRecordsPO);
        return this.commExtSkuMessageRecordsMapper.update((Object)updateRecordsPO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((String)recordsDTO.getExtSkuId()), CommExtSkuMessageRecordsPO::getExtSkuId, (Object)recordsDTO.getExtSkuId())).eq(CommExtSkuMessageRecordsPO::getMessageStatus, (Object)0)).eq(StringUtils.isNotBlank((String)recordsDTO.getSupplierHsn()), CommExtSkuMessageRecordsPO::getSupplierHsn, (Object)recordsDTO.getSupplierHsn()));
    }

    @Override
    public List<DycProCommExtSkuMessageRecordsDTO> selectMessageRecordsByCondition(DycProCommExtSkuMessageRecordsQueryDTO recordsDTO) {
        List commExtSkuMessageRecordsPOS = this.commExtSkuMessageRecordsMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtils.isNotBlank((String)recordsDTO.getExtSkuId()), CommExtSkuMessageRecordsPO::getExtSkuId, (Object)recordsDTO.getExtSkuId())).in(!CollectionUtils.isEmpty(recordsDTO.getExtSkuIdList()), CommExtSkuMessageRecordsPO::getExtSkuId, recordsDTO.getExtSkuIdList())).eq(null != recordsDTO.getMessageStatus(), CommExtSkuMessageRecordsPO::getMessageStatus, (Object)recordsDTO.getMessageStatus())).eq(StringUtils.isNotBlank((String)recordsDTO.getSupplierHsn()), CommExtSkuMessageRecordsPO::getSupplierHsn, (Object)recordsDTO.getSupplierHsn())).orderByAsc(CommExtSkuMessageRecordsPO::getPushTime));
        if (!CollectionUtils.isEmpty((Collection)commExtSkuMessageRecordsPOS)) {
            return JSONArray.parseArray((String)JSON.toJSONString((Object)commExtSkuMessageRecordsPOS)).toJavaList(DycProCommExtSkuMessageRecordsDTO.class);
        }
        return new ArrayList<DycProCommExtSkuMessageRecordsDTO>();
    }

    @Override
    public void batchUpdateMessageRecordsByIds(List<DycProCommExtSkuMessageRecordsDTO> recordsList) {
        if (!CollectionUtils.isEmpty(recordsList)) {
            List recordsPOS = JSONArray.parseArray((String)JSON.toJSONString(recordsList)).toJavaList(CommExtSkuMessageRecordsPO.class);
            this.commExtSkuMessageRecordsMapper.updateBatchByIds((Collection)recordsPOS);
        }
    }

    @Override
    public RspPage<DycProCommExtSkuMessageRecordsDTO> selectListPage(DycProCommExtSkuMessageRecordsQueryDTO queryDTO) {
        Page page = new Page((long)queryDTO.getPageNo().intValue(), (long)queryDTO.getPageSize().intValue());
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.likeIfPresent(CommExtSkuMessageRecordsPO::getExtSkuId, queryDTO.getDycProCommExtSkuMessageRecordsDTO().getExtSkuId());
        queryWrapper.eqIfPresent(CommExtSkuMessageRecordsPO::getSupplierName, (Object)queryDTO.getDycProCommExtSkuMessageRecordsDTO().getSupplierName());
        queryWrapper.eqIfPresent(CommExtSkuMessageRecordsPO::getMessageType, (Object)queryDTO.getDycProCommExtSkuMessageRecordsDTO().getMessageType());
        queryWrapper.eqIfPresent(CommExtSkuMessageRecordsPO::getMessageStatus, (Object)queryDTO.getDycProCommExtSkuMessageRecordsDTO().getMessageStatus());
        queryWrapper.betweenIfPresent(CommExtSkuMessageRecordsPO::getPushTime, (Object)queryDTO.getPushTimeStart(), (Object)queryDTO.getPushTimeEnd());
        queryWrapper.betweenIfPresent(CommExtSkuMessageRecordsPO::getMessageDealTime, (Object)queryDTO.getMessageDealTimeStart(), (Object)queryDTO.getMessageDealTimeEnd());
        queryWrapper.inIfPresent(CommExtSkuMessageRecordsPO::getMessageStatus, queryDTO.getMessageStatuss());
        queryWrapper.orderByDesc(CommExtSkuMessageRecordsPO::getMessageDealTime);
        Page pageResult = (Page)this.commExtSkuMessageRecordsMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)pageResult.getRecords()), DycProCommExtSkuMessageRecordsDTO.class));
        }
        rspPage.setPageNo((int)pageResult.getCurrent());
        rspPage.setTotal((int)pageResult.getPages());
        rspPage.setRecordsTotal((int)pageResult.getTotal());
        return rspPage;
    }
}

