/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.stock.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.dmc.dao.CommSkuStockInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuStockInfoRecordsMapper;
import com.tydic.dyc.pro.dmc.po.CommSkuStockInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuStockInfoRecordsPO;
import com.tydic.dyc.pro.dmc.repository.stock.api.DycProCommSkuStockInfoRepository;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoRecordsDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommSkuStockInfoRepositoryImpl
implements DycProCommSkuStockInfoRepository {
    @Autowired
    private CommSkuStockInfoRecordsMapper commSkuStockInfoRecordsMapper;
    @Autowired
    private CommSkuStockInfoMapper commSkuStockInfoMapper;

    @Override
    public RspPage<DycProCommSkuStockInfoDTO> getStockListPage(DycProCommSkuStockInfoDTO reqBO) {
        RspPage rspPage = new RspPage();
        Page pg = new Page((long)reqBO.getPageNo(), (long)reqBO.getPageSize());
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.likeIfPresent(CommSkuStockInfoPO::getSkuCode, reqBO.getSkuCode());
        queryWrapper.likeIfPresent(CommSkuStockInfoPO::getSkuName, reqBO.getSkuName());
        queryWrapper.eqIfPresent(CommSkuStockInfoPO::getSupplierId, (Object)reqBO.getSupplierId());
        Page result = (Page)this.commSkuStockInfoMapper.selectPage((IPage)pg, (Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProCommSkuStockInfoDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    @Override
    public List<DycProCommSkuStockInfoDTO> getStockList(DycProCommSkuStockInfoQryDTO reqBO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.in(CommSkuStockInfoPO::getSkuId, reqBO.getSkuIdList());
        List result = this.commSkuStockInfoMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ArrayList<DycProCommSkuStockInfoDTO>();
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)result), DycProCommSkuStockInfoDTO.class);
    }

    @Override
    public void updateSkuStock(DycProCommSkuStockInfoDTO reqBO) {
        this.updateStockMethod(reqBO);
        this.addStockRecordMethod(reqBO);
    }

    @Override
    public DycProCommSkuStockInfoDTO getStockInfoById(Long stockId) {
        CommSkuStockInfoPO stockInfo = (CommSkuStockInfoPO)this.commSkuStockInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CommSkuStockInfoPO::getStockId, (Object)stockId));
        if (null == stockInfo) {
            throw new ZTBusinessException("\u67e5\u8be2\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        DycProCommSkuStockInfoDTO dycProCommSkuStockInfoDTO = new DycProCommSkuStockInfoDTO();
        BeanUtils.copyProperties((Object)stockInfo, (Object)((Object)dycProCommSkuStockInfoDTO));
        return dycProCommSkuStockInfoDTO;
    }

    @Override
    public DycProCommSkuStockInfoDTO getStockInfoById(DycProCommSkuStockInfoDTO reqDto) {
        CommSkuStockInfoPO stockInfo = (CommSkuStockInfoPO)this.commSkuStockInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CommSkuStockInfoPO::getSkuId, (Object)reqDto.getSkuId()));
        if (null == stockInfo) {
            return null;
        }
        DycProCommSkuStockInfoDTO dycProCommSkuStockInfoDTO = new DycProCommSkuStockInfoDTO();
        BeanUtils.copyProperties((Object)stockInfo, (Object)((Object)dycProCommSkuStockInfoDTO));
        return dycProCommSkuStockInfoDTO;
    }

    private void addStockRecordMethod(DycProCommSkuStockInfoDTO reqBO) {
        DycProCommSkuStockInfoRecordsDTO dycProCommSkuStockInfoRecordsDTO = reqBO.getSkuStockInfoRecordsList().get(0);
        CommSkuStockInfoRecordsPO updateSkuStockInfoRecordsPO = new CommSkuStockInfoRecordsPO();
        updateSkuStockInfoRecordsPO.setStockId(reqBO.getStockId());
        updateSkuStockInfoRecordsPO.setChangeNum(dycProCommSkuStockInfoRecordsDTO.getChangeNum());
        updateSkuStockInfoRecordsPO.setChangeType(dycProCommSkuStockInfoRecordsDTO.getChangeType());
        updateSkuStockInfoRecordsPO.setBeforeTotalNum(dycProCommSkuStockInfoRecordsDTO.getBeforeTotalNum());
        updateSkuStockInfoRecordsPO.setAfterTotalNum(dycProCommSkuStockInfoRecordsDTO.getAfterTotalNum());
        updateSkuStockInfoRecordsPO.setBeforeUnsaleNum(dycProCommSkuStockInfoRecordsDTO.getBeforeUnsaleNum());
        updateSkuStockInfoRecordsPO.setAfterUnsaleNum(dycProCommSkuStockInfoRecordsDTO.getAfterUnsaleNum());
        updateSkuStockInfoRecordsPO.setCreateUserId(reqBO.getUserId());
        updateSkuStockInfoRecordsPO.setCreateUserName(reqBO.getName());
        updateSkuStockInfoRecordsPO.setCreateTime(new Date());
        updateSkuStockInfoRecordsPO.setCreateUserAccount(reqBO.getUserName());
        updateSkuStockInfoRecordsPO.setCreateOrgId(reqBO.getOrgId());
        updateSkuStockInfoRecordsPO.setCreateOrgName(reqBO.getOrgName());
        updateSkuStockInfoRecordsPO.setCreateCompanyId(reqBO.getCompanyId());
        updateSkuStockInfoRecordsPO.setCreateCompanyName(reqBO.getCompanyName());
        this.commSkuStockInfoRecordsMapper.insert((Object)updateSkuStockInfoRecordsPO);
    }

    private void updateStockMethod(DycProCommSkuStockInfoDTO reqBO) {
        CommSkuStockInfoPO updateSkuStockInfoPO = new CommSkuStockInfoPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateSkuStockInfoPO);
        updateSkuStockInfoPO.setUpdateUserId(reqBO.getUserId());
        updateSkuStockInfoPO.setUpdateUserName(reqBO.getName());
        updateSkuStockInfoPO.setUpdateUserAccount(reqBO.getUserName());
        updateSkuStockInfoPO.setUpdateOrgId(reqBO.getOrgId());
        updateSkuStockInfoPO.setUpdateOrgName(reqBO.getOrgName());
        updateSkuStockInfoPO.setUpdateOrgPath(reqBO.getOrgPath());
        updateSkuStockInfoPO.setUpdateCompanyId(reqBO.getCompanyId());
        updateSkuStockInfoPO.setUpdateCompanyName(reqBO.getCompanyName());
        updateSkuStockInfoPO.setUpdateTime(new Date());
        this.commSkuStockInfoMapper.updateById((Object)updateSkuStockInfoPO);
    }
}

