/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.upc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsindexMappingUpcBO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommUpcDetailsInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommUpcInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommUpcPicInfoMapper;
import com.tydic.dyc.pro.dmc.po.CommUpcDetailsInfoPO;
import com.tydic.dyc.pro.dmc.po.CommUpcInfoPO;
import com.tydic.dyc.pro.dmc.po.CommUpcPicInfoPO;
import com.tydic.dyc.pro.dmc.repository.upc.api.DycProCommUpcRepository;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcInfoDTO;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcPicInfoDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycProCommUpcRepositoryImpl
implements DycProCommUpcRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProCommUpcRepositoryImpl.class);
    @Autowired
    private NosqlClient nosqlClient;
    @Value(value="${ucc.es.upc.index}")
    private String upcIndexName;
    @Autowired
    private CommUpcInfoMapper commUpcInfoMapper;
    @Autowired
    private CommUpcDetailsInfoMapper commUpcDetailsInfoMapper;
    @Autowired
    private CommUpcPicInfoMapper commUpcPicInfoMapper;

    @Override
    public DycProCommUpcInfoDTO getUpcMainInfoOneByCondition(DycProCommUpcInfoDTO upcInfoDto) {
        CommUpcInfoPO commUpcInfoPO = (CommUpcInfoPO)this.commUpcInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != upcInfoDto.getExtUpcId(), CommUpcInfoPO::getExtUpcId, (Object)upcInfoDto.getExtUpcId()));
        if (null == commUpcInfoPO) {
            return null;
        }
        DycProCommUpcInfoDTO dycProCommUpcInfoDTO = new DycProCommUpcInfoDTO();
        BeanUtils.copyProperties((Object)commUpcInfoPO, (Object)dycProCommUpcInfoDTO);
        return dycProCommUpcInfoDTO;
    }

    @Override
    public Long addUpcAllInfo(DycProCommUpcInfoDTO upcInfoDto) {
        Long upcId = Sequence.getInstance().nextId();
        CommUpcInfoPO addUpcInfoPO = new CommUpcInfoPO();
        BeanUtils.copyProperties((Object)upcInfoDto, (Object)addUpcInfoPO);
        addUpcInfoPO.setUpcId(upcId);
        addUpcInfoPO.setDelFlag(DycProCommConstants.DelFlag.NO);
        addUpcInfoPO.setCreateTime(new Date());
        this.commUpcInfoMapper.insert((Object)addUpcInfoPO);
        if (null != upcInfoDto.getUpcDetails()) {
            CommUpcDetailsInfoPO addUpcDetailsInfoPO = new CommUpcDetailsInfoPO();
            BeanUtils.copyProperties((Object)upcInfoDto.getUpcDetails(), (Object)addUpcDetailsInfoPO);
            addUpcDetailsInfoPO.setDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            addUpcDetailsInfoPO.setUpcId(upcId);
            this.commUpcDetailsInfoMapper.insert((Object)addUpcDetailsInfoPO);
        }
        if (!CollectionUtils.isEmpty(upcInfoDto.getUpcPicInfoList())) {
            ArrayList<CommUpcPicInfoPO> addUpcPicPoList = new ArrayList<CommUpcPicInfoPO>();
            for (DycProCommUpcPicInfoDTO upcPicInfoDTO : upcInfoDto.getUpcPicInfoList()) {
                CommUpcPicInfoPO upcPicInfoPO = new CommUpcPicInfoPO();
                BeanUtils.copyProperties((Object)upcPicInfoDTO, (Object)upcPicInfoPO);
                upcPicInfoPO.setUpcId(upcId);
                upcPicInfoPO.setPicId(Long.valueOf(Sequence.getInstance().nextId()));
                addUpcPicPoList.add(upcPicInfoPO);
            }
            this.commUpcPicInfoMapper.insertBatch(addUpcPicPoList);
        }
        DycProEsindexMappingUpcBO dycProEsindexMappingUpcBO = (DycProEsindexMappingUpcBO)JSON.parseObject((String)JSON.toJSONString((Object)addUpcInfoPO), DycProEsindexMappingUpcBO.class);
        this.sysnAddUpcInfo(dycProEsindexMappingUpcBO);
        return upcId;
    }

    public void sysnAddUpcInfo(DycProEsindexMappingUpcBO mappingUpcBO) {
        NosqlAddSingleReqBO nosqlAddSingleReqBO = new NosqlAddSingleReqBO();
        nosqlAddSingleReqBO.setIndex(this.upcIndexName);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(mappingUpcBO.getUpcId()));
        nosqlBO.setObject((Object)mappingUpcBO);
        nosqlAddSingleReqBO.setNosqlBO(nosqlBO);
        log.debug("upcEs\u540c\u6b65\u65b0\u589e\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)nosqlAddSingleReqBO));
        NosqlAddSingleRsqBO nosqlAddSingleRsqBO = this.nosqlClient.addSingle(nosqlAddSingleReqBO);
        log.debug("upcEs\u540c\u6b65\u65b0\u589e\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)nosqlAddSingleRsqBO));
        if (!"0000".equals(nosqlAddSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("upcEs\u540c\u6b65\u65b0\u589e\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddSingleRsqBO.getRespDesc());
        }
    }

    @Override
    public DycProCommUpcInfoDTO getUpcDetails(DycProCommUpcInfoDTO upcInfoDto) {
        List resultUpcPicInfo;
        DycProCommUpcInfoDTO upcInfoDTO = new DycProCommUpcInfoDTO();
        CommUpcInfoPO resultUpcInfo = (CommUpcInfoPO)this.commUpcInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CommUpcInfoPO::getUpcId, (Object)upcInfoDto.getUpcId()));
        BeanUtils.copyProperties((Object)resultUpcInfo, (Object)upcInfoDTO);
        CommUpcDetailsInfoPO resultUpcDetailsInfo = (CommUpcDetailsInfoPO)this.commUpcDetailsInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CommUpcDetailsInfoPO::getUpcId, (Object)upcInfoDto.getUpcId()));
        if (!ObjectUtils.isEmpty((Object)resultUpcDetailsInfo)) {
            upcInfoDTO.setUpcDetails((DycProCommUpcDetailsInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)resultUpcDetailsInfo), DycProCommUpcDetailsInfoDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)(resultUpcPicInfo = this.commUpcPicInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(CommUpcPicInfoPO::getUpcId, (Object)upcInfoDto.getUpcId()))))) {
            upcInfoDTO.setUpcPicInfoList(JSON.parseArray((String)JSON.toJSONString((Object)resultUpcPicInfo), DycProCommUpcPicInfoDTO.class));
        }
        return upcInfoDTO;
    }
}

