/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQueryConsultListPageService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscConsultInfoBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQueryConsultListPageReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQueryConsultListPageRspBO;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQueryConsultListPageService"})
public class DycProSscQueryConsultListPageServiceImpl
implements DycProSscQueryConsultListPageService {
    private static final Logger log = LoggerFactory.getLogger(DycProSscQueryConsultListPageServiceImpl.class);
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;

    @Override
    @PostMapping(value={"queryConsultListPage"})
    public DycProSscQueryConsultListPageRspBO queryConsultListPage(@RequestBody DycProSscQueryConsultListPageReqBO reqBO) {
        LocalDateTime yesterday = LocalDateTime.now().minusDays(1L);
        Date now = Date.from(yesterday.atZone(ZoneId.systemDefault()).toInstant());
        this.paramVerify(reqBO);
        DycProSscConsultQryDTO qryDTO = (DycProSscConsultQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSscConsultQryDTO.class);
        List<Integer> statusList = this.transTabIdToStatusList(reqBO.getTabId());
        if (!CollectionUtils.isEmpty(statusList)) {
            qryDTO.setStatusList(statusList);
        }
        if ("1002".equals(reqBO.getTabId()) || "1005".equals(reqBO.getTabId())) {
            qryDTO.setSortChoose("QUOTE_ENT_TIME");
        }
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(reqBO.getConsultType()) && null != reqBO.getSupplierId()) {
            qryDTO.setSupplierId(reqBO.getSupplierId());
        } else {
            qryDTO.setCreateUserId(reqBO.getUserId());
        }
        RspPage dycProSscConsultDTORspPage = this.dycProSscConsultRepository.queryConsultListPageByCondition(qryDTO);
        DycProSscQueryConsultListPageRspBO dycProSscQueryConsultListPageRspBO = (DycProSscQueryConsultListPageRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)dycProSscConsultDTORspPage), DycProSscQueryConsultListPageRspBO.class));
        if (!CollectionUtils.isEmpty((Collection)dycProSscQueryConsultListPageRspBO.getRows())) {
            for (DycProSscConsultInfoBO row : dycProSscQueryConsultListPageRspBO.getRows()) {
                if (null != row.getConsultStatus()) {
                    row.setConsultStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultStatus", (String)String.valueOf(row.getConsultStatus())));
                    if (reqBO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
                        row.setConsultStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultStatusJJ", (String)String.valueOf(row.getConsultStatus())));
                    } else if (reqBO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_YJ)) {
                        row.setConsultStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultStatusYJ", (String)String.valueOf(row.getConsultStatus())));
                    }
                }
                if (null != row.getCurrentQuoteTurn()) {
                    if (row.getCurrentQuoteTurn() < 7) {
                        row.setCurrentQuoteTurnStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultQuoteTurn", (String)String.valueOf(row.getCurrentQuoteTurn())));
                    } else {
                        int currentQuoteTurn = row.getCurrentQuoteTurn();
                        String chineseQuoteTurn = this.numberToChinese(currentQuoteTurn);
                        row.setCurrentQuoteTurnStr("\u7b2c" + chineseQuoteTurn + "\u8f6e");
                    }
                }
                if (null != row.getCreateTime()) {
                    row.setCreateTimeStr(this.timeToStr(row.getCreateTime()));
                }
                if (null != row.getPriceExpiryDate()) {
                    row.setIsEffDate(row.getPriceExpiryDate().before(now));
                }
                if (!reqBO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_YJ)) continue;
                row.setCreateUserName(row.getCreateUserName() + "(" + row.getCreateUserAccount() + ")");
            }
        }
        if (!reqBO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
            if (reqBO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_YJ)) {
                dycProSscQueryConsultListPageRspBO.setQuoteCount(this.qryQuoteCount(qryDTO));
                dycProSscQueryConsultListPageRspBO.setQuotedCount(this.qryQuotedCount(qryDTO));
                dycProSscQueryConsultListPageRspBO.setQuoteStopCount(this.qryQuoteStopCount(qryDTO));
                dycProSscQueryConsultListPageRspBO.setQuoteOrderCount(this.qryQuoteOrderCount(qryDTO));
            } else {
                dycProSscQueryConsultListPageRspBO.setToBePublishCount(this.qryToBePublishCount(qryDTO));
                dycProSscQueryConsultListPageRspBO.setDoingCount(this.qryDoingCount(qryDTO));
            }
        }
        return dycProSscQueryConsultListPageRspBO;
    }

    private String timeToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private Integer qryToBePublishCount(DycProSscConsultQryDTO qryDTO) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(DycProSscConstants.ConsultStatus.DRAFT);
        statusList.add(DycProSscConstants.ConsultStatus.UNDER_APPROVAL);
        statusList.add(DycProSscConstants.ConsultStatus.APPROVAL_REJECTED);
        statusList.add(DycProSscConstants.ConsultStatus.TO_BE_PUBLISHED);
        qryDTO.setStatusList(statusList);
        return this.dycProSscConsultRepository.queryConsultCountByCondition(qryDTO);
    }

    private Integer qryDoingCount(DycProSscConsultQryDTO qryDTO) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(DycProSscConstants.ConsultStatus.NOT_STARTED);
        statusList.add(DycProSscConstants.ConsultStatus.QUOTING);
        statusList.add(DycProSscConstants.ConsultStatus.AWAITING_RESULT_CONFIRMATION);
        statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_APPROVAL_PROCESSING);
        statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_APPROVAL_REJECTED);
        statusList.add(DycProSscConstants.ConsultStatus.RESULT_PENDING_PUBLICATION);
        statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_DEADLINE);
        qryDTO.setStatusList(statusList);
        return this.dycProSscConsultRepository.queryConsultCountByCondition(qryDTO);
    }

    private Integer qryQuoteCount(DycProSscConsultQryDTO qryDTO) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(DycProSscConstants.ConsultStatus.QUOTING);
        qryDTO.setStatusList(statusList);
        return this.dycProSscConsultRepository.queryConsultCountByCondition(qryDTO);
    }

    private Integer qryQuotedCount(DycProSscConsultQryDTO qryDTO) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(DycProSscConstants.ConsultStatus.AWAITING_RESULT_CONFIRMATION);
        qryDTO.setStatusList(statusList);
        return this.dycProSscConsultRepository.queryConsultCountByCondition(qryDTO);
    }

    private Integer qryQuoteStopCount(DycProSscConsultQryDTO qryDTO) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_TERMINATED);
        qryDTO.setStatusList(statusList);
        return this.dycProSscConsultRepository.queryConsultCountByCondition(qryDTO);
    }

    private Integer qryQuoteOrderCount(DycProSscConsultQryDTO qryDTO) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(DycProSscConstants.ConsultStatus.COMPLETED);
        qryDTO.setStatusList(statusList);
        return this.dycProSscConsultRepository.queryConsultCountByCondition(qryDTO);
    }

    private void paramVerify(DycProSscQueryConsultListPageReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getTabId())) {
            throw new ZTBusinessException("\u9875\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<Integer> transTabIdToStatusList(String tabId) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        if (!"1000".equals(tabId)) {
            if ("1001".equals(tabId)) {
                statusList.add(DycProSscConstants.ConsultStatus.DRAFT);
                statusList.add(DycProSscConstants.ConsultStatus.UNDER_APPROVAL);
                statusList.add(DycProSscConstants.ConsultStatus.APPROVAL_REJECTED);
                statusList.add(DycProSscConstants.ConsultStatus.TO_BE_PUBLISHED);
            } else if ("1002".equals(tabId)) {
                statusList.add(DycProSscConstants.ConsultStatus.NOT_STARTED);
                statusList.add(DycProSscConstants.ConsultStatus.QUOTING);
                statusList.add(DycProSscConstants.ConsultStatus.AWAITING_RESULT_CONFIRMATION);
                statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_APPROVAL_PROCESSING);
                statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_APPROVAL_REJECTED);
                statusList.add(DycProSscConstants.ConsultStatus.RESULT_PENDING_PUBLICATION);
                statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_DEADLINE);
            } else if ("1003".equals(tabId)) {
                statusList.add(DycProSscConstants.ConsultStatus.COMPLETED);
            } else if ("1004".equals(tabId)) {
                statusList.add(DycProSscConstants.ConsultStatus.DRAFT);
                statusList.add(DycProSscConstants.ConsultStatus.UNDER_APPROVAL);
                statusList.add(DycProSscConstants.ConsultStatus.APPROVAL_REJECTED);
            } else if ("1005".equals(tabId)) {
                statusList.add(DycProSscConstants.ConsultStatus.NOT_STARTED);
                statusList.add(DycProSscConstants.ConsultStatus.QUOTING);
                statusList.add(DycProSscConstants.ConsultStatus.AWAITING_RESULT_CONFIRMATION);
                statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_APPROVAL_PROCESSING);
                statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_APPROVAL_REJECTED);
                statusList.add(DycProSscConstants.ConsultStatus.RESULT_PENDING_PUBLICATION);
            } else if ("1006".equals(tabId)) {
                statusList.add(DycProSscConstants.ConsultStatus.COMPLETED);
            } else if (!"1007".equals(tabId)) {
                if ("1008".equals(tabId)) {
                    statusList.add(DycProSscConstants.ConsultStatus.QUOTING);
                } else if ("1009".equals(tabId)) {
                    statusList.add(DycProSscConstants.ConsultStatus.AWAITING_RESULT_CONFIRMATION);
                } else if ("1010".equals(tabId)) {
                    statusList.add(DycProSscConstants.ConsultStatus.QUOTATION_TERMINATED);
                } else if ("1011".equals(tabId)) {
                    statusList.add(DycProSscConstants.ConsultStatus.COMPLETED);
                } else if (!"1012".equals(tabId)) {
                    throw new ZTBusinessException("\u5165\u53c2\u9875\u7b7eID\u4f20\u503c\u6709\u8bef");
                }
            }
        }
        return statusList;
    }

    private String numberToChinese(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("\u6570\u5b57\u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570");
        }
        String[] chineseNumbers = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] units = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341\u4e07", "\u767e\u4e07", "\u5343\u4e07", "\u4ebf"};
        if (number == 0) {
            return chineseNumbers[0];
        }
        StringBuilder result = new StringBuilder();
        int unitIndex = 0;
        while (number > 0) {
            int digit = number % 10;
            if (digit != 0) {
                result.insert(0, units[unitIndex]);
                result.insert(0, chineseNumbers[digit]);
            }
            number /= 10;
            ++unitIndex;
        }
        if (result.toString().startsWith("\u4e00\u5341")) {
            result = new StringBuilder(result.toString().replaceFirst("\u4e00\u5341", "\u5341"));
        }
        if (result.toString().endsWith("\u96f6")) {
            result = new StringBuilder(result.toString().replaceAll("\u96f6+$", ""));
        }
        return result.toString();
    }
}

