/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.config;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/consultWs")
@Component
public class WsServerEndpont {
    private static final Logger log = LoggerFactory.getLogger(WsServerEndpont.class);
    static Map<String, Session> sessionMap = new ConcurrentHashMap<String, Session>();

    @OnOpen
    public void onOpen(Session session) {
        sessionMap.put(session.getId(), session);
        log.info("websocket is open");
    }

    @OnMessage
    public String onMessage(String text) {
        log.info("\u6536\u5230\u4e86\u4e00\u6761\u6d88\u606f\uff1a" + text);
        return "\u5df2\u6536\u5230\u4f60\u7684\u6d88\u606f";
    }

    @OnClose
    public void onClose(Session session) {
        sessionMap.remove(session.getId());
        log.info("websocket is close");
    }

    public static void sendMsg(String text) {
        try {
            log.info("sessionMap\uff1a" + sessionMap.toString());
            for (String key : sessionMap.keySet()) {
                sessionMap.get(key).getBasicRemote().sendText(text);
                log.info("\u62a5\u4ef7\u6d88\u8d39\u6d88\u606f:" + sessionMap.get(key).toString());
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }
}

