/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.core.approve.repository.api.ApproveRepository;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskInfoDo;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskQryDo;
import com.tydic.fsc.bill.ability.api.FscUnifyTodoQryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscUnifyTodoQryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscUnifyTodoQryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.UocAuditOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.UocAuditOrderPo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscUnifyTodoQryAbilityService"})
public class FscUnifyTodoQryAbilityServiceImpl
implements FscUnifyTodoQryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;
    @Autowired
    private ApproveRepository approveRepository;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @PostMapping(value={"qryTodoInfo"})
    public FscUnifyTodoQryAbilityRspBO qryTodoInfo(@RequestBody FscUnifyTodoQryAbilityReqBO reqBO) {
        this.validParam(reqBO);
        FscUnifyTodoQryAbilityRspBO rspBO = new FscUnifyTodoQryAbilityRspBO();
        JSONObject jsonStr = new JSONObject();
        if (reqBO.getObjType() == 1) {
            Integer objType;
            UocAuditOrderPo uocAuditOrderPo = new UocAuditOrderPo();
            uocAuditOrderPo.setAuditOrderId(reqBO.getObjId());
            uocAuditOrderPo = this.uocAuditOrderMapper.getModelBy(uocAuditOrderPo);
            if (uocAuditOrderPo == null) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5ba1\u6279\u5355\u6570\u636e");
            }
            FlowTaskQryDo uocOrderProcInstPo = new FlowTaskQryDo();
            uocOrderProcInstPo.setObjId(uocAuditOrderPo.getOrderId());
            uocOrderProcInstPo.setCenterCode("FSC");
            List uocOrderProcInstPos = this.approveRepository.queryFlowTask(uocOrderProcInstPo);
            if (!CollectionUtils.isEmpty((Collection)uocOrderProcInstPos) && (FscConstants.AuditObjType.PAY_APPLY_ORDER.equals(objType = ((FlowTaskInfoDo)uocOrderProcInstPos.get(0)).getObjType()) || FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL.equals(objType) || FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL.equals(objType))) {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(((FlowTaskInfoDo)uocOrderProcInstPos.get(0)).getObjId());
                FscOrderPO fscOrderResult = this.fscOrderMapper.getModelBy(fscOrderPO);
                if (fscOrderResult == null) {
                    throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u6570\u636e");
                }
                rspBO.setObjCreateUserId(fscOrderResult.getCreateOperId());
                jsonStr.put("fscOrderNo", (Object)fscOrderResult.getOrderNo());
                if (FscConstants.AuditObjType.PAY_APPLY_ORDER.equals(objType)) {
                    jsonStr.put("auditObjType", (Object)FscConstants.AuditObjType.PAY_APPLY_ORDER);
                    jsonStr.put("proOrgId", (Object)fscOrderResult.getPayerId());
                } else if (FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL.equals(objType)) {
                    jsonStr.put("auditObjType", (Object)FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
                    jsonStr.put("supOrgId", (Object)fscOrderResult.getSupplierId());
                } else {
                    jsonStr.put("auditObjType", (Object)FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
                    jsonStr.put("supOrgId", (Object)fscOrderResult.getSupplierId());
                }
            }
        } else if (reqBO.getObjType() == 2) {
            Integer objType;
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getObjId());
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            if (fscOrderPO == null) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u6570\u636e");
            }
            rspBO.setObjCreateUserId(fscOrderPO.getCreateOperId());
            rspBO.setProOrgId(fscOrderPO.getProOrgId());
            rspBO.setPurOrgId(fscOrderPO.getPurchaserId());
            rspBO.setSupOrgId(fscOrderPO.getSupplierId());
            jsonStr.put("fscOrderNo", (Object)fscOrderPO.getOrderNo());
            jsonStr.put("makeType", (Object)fscOrderPO.getMakeType());
            jsonStr.put("receiveType", (Object)fscOrderPO.getReceiveType());
            if (fscOrderPO.getOrderSource() != null) {
                jsonStr.put("orderSource", (Object)fscOrderPO.getOrderSource());
            }
            jsonStr.put("orderFlow", (Object)fscOrderPO.getOrderFlow());
            if (fscOrderPO.getCreditAmount() != null && fscOrderPO.getCreditAmount().compareTo(new BigDecimal(0)) != 0) {
                jsonStr.put("creditAmount", (Object)fscOrderPO.getCreditAmount());
            }
            if (StringUtils.isNotBlank((String)fscOrderPO.getCreditConfirmDueDay())) {
                jsonStr.put("timeLimit", (Object)fscOrderPO.getCreditConfirmDueDay());
            }
            FlowTaskQryDo uocOrderProcInstPo = new FlowTaskQryDo();
            uocOrderProcInstPo.setObjId(reqBO.getObjId());
            uocOrderProcInstPo.setCenterCode("FSC");
            List uocOrderProcInstPos = this.approveRepository.queryFlowTask(uocOrderProcInstPo);
            if (!CollectionUtils.isEmpty((Collection)uocOrderProcInstPos) && (FscConstants.AuditObjType.PAY_APPLY_ORDER.equals(objType = ((FlowTaskInfoDo)uocOrderProcInstPos.get(0)).getObjType()) || FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL.equals(objType) || FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL.equals(objType))) {
                rspBO.setObjCreateUserId(fscOrderPO.getCreateOperId());
                jsonStr.put("fscOrderNo", (Object)fscOrderPO.getOrderNo());
                UocAuditOrderPo uocAuditOrderPo = new UocAuditOrderPo();
                uocAuditOrderPo.setOrderId(((FlowTaskInfoDo)uocOrderProcInstPos.get(0)).getObjId());
                uocAuditOrderPo = this.uocAuditOrderMapper.getModelBy(uocAuditOrderPo);
                if (null != uocAuditOrderPo) {
                    jsonStr.put("auditOrderId", (Object)uocAuditOrderPo.getAuditOrderId());
                }
                if (FscConstants.AuditObjType.PAY_APPLY_ORDER.equals(objType)) {
                    jsonStr.put("auditObjType", (Object)FscConstants.AuditObjType.PAY_APPLY_ORDER);
                    jsonStr.put("proOrgId", (Object)fscOrderPO.getPayerId());
                } else if (FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL.equals(objType)) {
                    jsonStr.put("auditObjType", (Object)FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
                    jsonStr.put("supOrgId", (Object)fscOrderPO.getSupplierId());
                } else {
                    jsonStr.put("auditObjType", (Object)FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
                    jsonStr.put("supOrgId", (Object)fscOrderPO.getSupplierId());
                }
            }
        } else if (reqBO.getObjType() == 3) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayId(reqBO.getObjId());
            fscShouldPayPO = this.fscShouldPayMapper.getModelBy(fscShouldPayPO);
            if (fscShouldPayPO != null) {
                rspBO.setObjCreateUserId(fscShouldPayPO.getCreateId());
                jsonStr.put("shouldPayNo", (Object)fscShouldPayPO.getShouldPayNo());
                rspBO.setSupOrgId(fscShouldPayPO.getPayerId());
                rspBO.setProOrgId(fscShouldPayPO.getPayerId());
                rspBO.setPurOrgId(fscShouldPayPO.getPayerId());
            }
        }
        rspBO.setParamJson(jsonStr.toJSONString());
        return rspBO;
    }

    private void validParam(FscUnifyTodoQryAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (reqBO.getObjId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636eID\u4e3a\u7a7a");
        }
        if (reqBO.getObjType() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a");
        }
    }
}

