/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscTodoBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderExtFieldMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderExtFieldPo;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderCreateBusiServiceImpl
implements FscBillOrderCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscOrderExtFieldMapper fscOrderExtFieldMapper;
    @Value(value="${fscOrderCreate.invoiceAttachmentRequiredFlag:true}")
    private Boolean invoiceAttachmentRequiredFlag;

    @Override
    public FscBillOrderCreateBusiRspBO dealCreate(FscBillOrderCreateBusiReqBO reqBO) {
        ArrayList<FscOrderPO> fscOrderPOS = new ArrayList<FscOrderPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList fscOrderItemPOS = new ArrayList();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        ArrayList<FscOrderExtFieldPo> fscOrderExtFieldPos = new ArrayList<FscOrderExtFieldPo>();
        int num = 0;
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            fscOrderPo.setSupplierName(splitOrderBO.getSupplierName());
            fscOrderPo.setSupplierId(splitOrderBO.getSupplierId());
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderPo.setCreateTime(new Date());
            fscOrderPo.setCreateOperId(reqBO.getUserId());
            if ("0".equals(reqBO.getIsprofess()) && FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                fscOrderPo.setCreateOperName(StrUtil.format((CharSequence)"{}\uff08{}\uff09", (Object[])new Object[]{reqBO.getName(), "\u8fd0\u8425\u5355\u4f4d"}));
            } else {
                fscOrderPo.setCreateOperName(reqBO.getName());
            }
            fscOrderPo.setCreateOrgId(reqBO.getOrgId());
            fscOrderPo.setCreateOrgName(reqBO.getOrgName());
            fscOrderPo.setCreateCompanyId(reqBO.getCompanyId());
            fscOrderPo.setCreateCompanyName(reqBO.getCompanyName());
            fscOrderPo.setTotalCharge(splitOrderBO.getAmount());
            fscOrderPo.setOrderNo(reqBO.getOrderNos().get(num));
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            fscOrderPo.setParentOrderId(reqBO.getOperSn());
            if (null != reqBO.getBuildAction()) {
                fscOrderPo.setBuildAction(reqBO.getBuildAction());
            }
            ++num;
            FscOrderExtFieldPo fscOrderExtFieldPo = (FscOrderExtFieldPo)JSONObject.parseObject((String)JSON.toJSONString((Object)splitOrderBO), FscOrderExtFieldPo.class);
            fscOrderExtFieldPo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderExtFieldPos.add(fscOrderExtFieldPo);
            fscOrderPOS.add(fscOrderPo);
            fscOrderIds.add(fscOrderPo.getFscOrderId());
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderRelationPOS.add(fscOrderRelationPO);
                fscOrderInfoBO.getFscOrderItemBOS().forEach(fscOrderItemBO -> fscOrderItemBO.setFscOrderId(fscOrderPo.getFscOrderId()));
                fscOrderItemPOS.addAll(JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class));
            }
            FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)splitOrderBO.getFscOrderInvoiceBO()), FscOrderInvoicePO.class);
            fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
            fscOrderInvoicePo.setBillOperName(reqBO.getName());
            fscOrderInvoicePo.setBillTime(new Date());
            fscOrderInvoicePo.setBillTimeStart(new Date());
            fscOrderInvoicePo.setMemo(reqBO.getInvoiceMemo());
            fscOrderInvoicePOS.add(fscOrderInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
            fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
            fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
            Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
            if (this.invoiceAttachmentRequiredFlag.booleanValue()) {
                elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
            } else if (FscConstants.FscInvoiceCategory.ELEC.equals(fscOrderInvoicePo.getInvoiceCategory()) || FscConstants.FscInvoiceCategory.ALL_ELEC.equals(fscOrderInvoicePo.getInvoiceCategory())) {
                elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
            }
            fscInvoiceRulePO.setElecFlag(elecFlag);
            fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePOS.add(fscInvoiceRulePO);
        }
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        List fscOrderItemPOList = fscOrderItemPOS.stream().filter(e -> e.getNum().compareTo(BigDecimal.ZERO) > 0).peek(fscOrderItemPO -> fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()))).collect(Collectors.toList());
        this.fscOrderMapper.insertBatch(fscOrderPOS);
        this.fscOrderExtFieldMapper.insertBatch(fscOrderExtFieldPos);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOList);
        this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
        this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
        ArrayList<FscTodoBO> fscTodoBOS = new ArrayList<FscTodoBO>();
        for (Long fscOrderId : fscOrderIds) {
            fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
            FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
            if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
            }
            FscTodoBO fscTodoBO = new FscTodoBO();
            fscTodoBO.setFscOrderId(fscOrderId);
            fscTodoBO.setNewStatus(fscOrderStatusStartAtomRspBO.getNewStatus());
            fscTodoBOS.add(fscTodoBO);
        }
        this.syncOrderStatus(fscOrderIds);
        FscBillOrderCreateBusiRspBO rspBO = new FscBillOrderCreateBusiRspBO();
        rspBO.setFscOrderIds(fscOrderIds);
        rspBO.setFscTodoBOS(fscTodoBOS);
        return rspBO;
    }

    private void syncOrderStatus(List<Long> fscOrderIds) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }
}

