/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FscEsBillCheckServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscEsBillCheckServiceConsumer.class);
    @Autowired
    private FscBillEcomCheckAbilityService fscBillEcomCheckAbilityService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Value(value="${qry.pageSize:1000}")
    private Integer pageSize;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            FscBillEcomCheckAbilityReqBO applyAbilityReqBO = (FscBillEcomCheckAbilityReqBO)JSON.parseObject((String)proxyMessage.getContent(), FscBillEcomCheckAbilityReqBO.class);
            if (log.isDebugEnabled()) {
                log.debug("mq\u7535\u5546\u5bf9\u8d26\u6d88\u8d39\u8005\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)applyAbilityReqBO));
            }
            if (ObjectUtil.isNotEmpty((Object)applyAbilityReqBO.getOperSn())) {
                int pageNo = 1;
                int totalPage = 1;
                do {
                    Page page = new Page();
                    page.setPageNo(pageNo);
                    page.setPageSize(this.pageSize.intValue());
                    FscCheckResultPO fscCheckResultWhere = new FscCheckResultPO();
                    fscCheckResultWhere.setOperSn(applyAbilityReqBO.getOperSn());
                    List checkResultListPage = this.fscCheckResultMapper.getListPage(fscCheckResultWhere, page);
                    totalPage = page.getTotalPages();
                    log.info("\u5168\u91cf\u5bf9\u8d26\u7533\u8bf7mq\u53d1\u9001\u8005\u6d41\u6c34\u53f7={}, \u603b\u9875\u6570={}, \u5f53\u524d\u9875\u6570\u4e3a={}", new Object[]{applyAbilityReqBO.getOperSn(), totalPage, ++pageNo});
                    applyAbilityReqBO.setRelOrderList(JUtil.jsl((List)checkResultListPage, RelOrderBO.class));
                    FscBillEcomCheckAbilityRspBO abilityRspBO = this.fscBillEcomCheckAbilityService.dealEcomCheck(applyAbilityReqBO);
                    if (!"0000".equals(abilityRspBO.getRespCode())) {
                        this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), JSON.toJSONString((Object)abilityRspBO), new Date(), abilityRspBO.getRespDesc());
                        throw new FscBusinessException("190000", abilityRspBO.getRespDesc());
                    }
                    this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, proxyMessage.getContent(), JSON.toJSONString((Object)abilityRspBO), new Date(), null);
                } while (totalPage > 1 && pageNo <= totalPage);
            } else {
                FscBillEcomCheckAbilityRspBO abilityRspBO = this.fscBillEcomCheckAbilityService.dealEcomCheck(applyAbilityReqBO);
                if (!"0000".equals(abilityRspBO.getRespCode())) {
                    this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), JSON.toJSONString((Object)abilityRspBO), new Date(), abilityRspBO.getRespDesc());
                    throw new FscBusinessException("190000", abilityRspBO.getRespDesc());
                }
                this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, proxyMessage.getContent(), JSON.toJSONString((Object)abilityRspBO), new Date(), null);
            }
        }
        catch (Exception e) {
            this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), null, new Date(), ExceptionUtil.stacktraceToString((Throwable)e));
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void systemBusiLog(Integer logFlag, String reqStr, String rspStr, Date createTime, String failureReason) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.INNER);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(logFlag);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.ECOM_BILL_CHICK);
        logBusiServiceReqBo.setCallService("FscBillEcomCheckAbilityService");
        logBusiServiceReqBo.setSendService("FscBillEcomCheckApplyAbilityService");
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        logBusiServiceReqBo.setCreateTime(createTime);
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }
}

