/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingInspInvoiceBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingInspOrderItemBO;
import com.tydic.dyc.pro.egc.service.insporder.api.DycProOrderQryInspOrderListPageForFscService;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderInspOrderEsApiBO;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderQryInspOrderListPageForFscReqBO;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderQryInspOrderListPageForFscRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.TaxUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAcceptOrderListQueryAtomServiceImpl
implements FscAcceptOrderListQueryAtomService {
    @Autowired
    private DycProOrderQryInspOrderListPageForFscService dycProOrderQryInspOrderListPageForFscService;

    @Override
    public FscAcceptOrderListQueryAtomRspBO query(FscAcceptOrderListQueryAtomReqBO reqBO) {
        FscAcceptOrderListQueryAtomRspBO rspBO = new FscAcceptOrderListQueryAtomRspBO();
        rspBO.setFscOrderInfoBoMap(this.packOrderInfo(reqBO));
        return rspBO;
    }

    private Map<Long, FscOrderInfoBO> packOrderInfo(FscAcceptOrderListQueryAtomReqBO reqBO) {
        DycProOrderQryInspOrderListPageForFscReqBO dycProOrderQryInspOrderListPageForFscReqBO = new DycProOrderQryInspOrderListPageForFscReqBO();
        if (!CollectionUtils.isEmpty(reqBO.getInspOrderIdList())) {
            dycProOrderQryInspOrderListPageForFscReqBO.setInspOrderIds(reqBO.getInspOrderIdList().stream().map(Object::toString).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getRelId())) {
            dycProOrderQryInspOrderListPageForFscReqBO.setFscOrderId(Long.valueOf(reqBO.getRelId()));
        }
        dycProOrderQryInspOrderListPageForFscReqBO.setPageSize(2000);
        DycProOrderQryInspOrderListPageForFscRspBO dycProOrderQryInspOrderListPageForFscRspBO = this.dycProOrderQryInspOrderListPageForFscService.qryInspOrderListPageForFsc(dycProOrderQryInspOrderListPageForFscReqBO);
        if (!"0".equals(dycProOrderQryInspOrderListPageForFscRspBO.getBusiCode())) {
            throw new FscBusinessException("194301", dycProOrderQryInspOrderListPageForFscRspBO.getBusiCode());
        }
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap<Long, FscOrderInfoBO>();
        for (DycProOrderInspOrderEsApiBO row : dycProOrderQryInspOrderListPageForFscRspBO.getRows()) {
            BigDecimal taxRate;
            FscOrderItemBO fscOrderItemBO;
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)row), FscOrderInfoBO.class);
            ArrayList<FscOrderItemBO> fscOrderItemBOS = new ArrayList<FscOrderItemBO>();
            Map<Long, List<DycProEsIndexMappingInspOrderItemBO>> inspOrderItemBOMap = row.getInspItemList().stream().collect(Collectors.groupingBy(DycProEsIndexMappingInspOrderItemBO::getSaleOrderItemId));
            if ("2".equals(row.getOrderSource().toString())) {
                for (Map.Entry<Long, List<Object>> entry : inspOrderItemBOMap.entrySet()) {
                    fscOrderItemBO = (FscOrderItemBO)JSONObject.parseObject((String)JSON.toJSONString((Object)entry.getValue().get(0)), FscOrderItemBO.class);
                    fscOrderItemBO.setAcceptOrderId(row.getInspOrderId());
                    fscOrderItemBO.setNum(entry.getValue().stream().map(DycProEsIndexMappingInspOrderItemBO::getInspCount).reduce(BigDecimal.ZERO, BigDecimal::add));
                    fscOrderItemBO.setSkuIdExt(((DycProEsIndexMappingInspOrderItemBO)entry.getValue().get(0)).getSkuExtSkuId());
                    taxRate = ((DycProEsIndexMappingInspOrderItemBO)entry.getValue().get(0)).getTax().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
                    fscOrderItemBO.setTaxRate(taxRate);
                    fscOrderItemBO.setUnit(((DycProEsIndexMappingInspOrderItemBO)entry.getValue().get(0)).getUnitName());
                    if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                        fscOrderItemBO.setAmt(entry.getValue().stream().map(DycProEsIndexMappingInspOrderItemBO::getInspTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add));
                        fscOrderItemBO.setPrice(((DycProEsIndexMappingInspOrderItemBO)entry.getValue().get(0)).getSalePrice());
                    }
                    if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                        fscOrderItemBO.setAmt(entry.getValue().stream().map(DycProEsIndexMappingInspOrderItemBO::getInspTotalPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add));
                        fscOrderItemBO.setPrice(((DycProEsIndexMappingInspOrderItemBO)entry.getValue().get(0)).getPurchasePrice());
                    }
                    if (null != fscOrderItemBO.getAmt()) {
                        fscOrderItemBO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                        fscOrderItemBO.setUntaxAmt(fscOrderItemBO.getAmt().subtract(fscOrderItemBO.getTaxAmt()));
                    }
                    fscOrderItemBO.setSaleAmt(entry.getValue().stream().map(DycProEsIndexMappingInspOrderItemBO::getInspTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add));
                    fscOrderItemBO.setSalePrice(((DycProEsIndexMappingInspOrderItemBO)entry.getValue().get(0)).getSalePrice());
                    fscOrderItemBO.setSaleTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getSaleAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setSaleUntaxAmt(fscOrderItemBO.getSaleAmt().subtract(fscOrderItemBO.getSaleTaxAmt()));
                    fscOrderItemBO.setPurchaseAmt(entry.getValue().stream().map(DycProEsIndexMappingInspOrderItemBO::getInspTotalPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add));
                    fscOrderItemBO.setPurchasePrice(((DycProEsIndexMappingInspOrderItemBO)entry.getValue().get(0)).getPurchasePrice());
                    fscOrderItemBO.setPurchaseTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getPurchaseAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setPurchaseUntaxAmt(fscOrderItemBO.getPurchaseAmt().subtract(fscOrderItemBO.getPurchaseTaxAmt()));
                    fscOrderItemBO.setOrderItemId(entry.getKey());
                    fscOrderItemBO.setOrderId(row.getSaleOrderId());
                    fscOrderItemBO.setSkuNo(((DycProEsIndexMappingInspOrderItemBO)entry.getValue().get(0)).getSkuCode());
                    fscOrderItemBOS.add(fscOrderItemBO);
                }
            } else {
                for (DycProEsIndexMappingInspOrderItemBO dycProEsIndexMappingInspOrderItemBO : row.getInspItemList()) {
                    fscOrderItemBO = (FscOrderItemBO)JSONObject.parseObject((String)JSON.toJSONString((Object)dycProEsIndexMappingInspOrderItemBO), FscOrderItemBO.class);
                    fscOrderItemBO.setAcceptOrderId(row.getInspOrderId());
                    fscOrderItemBO.setNum(dycProEsIndexMappingInspOrderItemBO.getInspCount());
                    fscOrderItemBO.setSkuIdExt(dycProEsIndexMappingInspOrderItemBO.getSkuExtSkuId());
                    taxRate = dycProEsIndexMappingInspOrderItemBO.getTax().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
                    fscOrderItemBO.setTaxRate(dycProEsIndexMappingInspOrderItemBO.getTax());
                    fscOrderItemBO.setUnit(dycProEsIndexMappingInspOrderItemBO.getUnitName());
                    if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                        fscOrderItemBO.setAmt(dycProEsIndexMappingInspOrderItemBO.getInspTotalSaleFee());
                        fscOrderItemBO.setPrice(dycProEsIndexMappingInspOrderItemBO.getSalePrice());
                    }
                    if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                        fscOrderItemBO.setAmt(dycProEsIndexMappingInspOrderItemBO.getInspTotalPurchaseFee());
                        fscOrderItemBO.setPrice(dycProEsIndexMappingInspOrderItemBO.getPurchasePrice());
                    }
                    if (null != fscOrderItemBO.getAmt()) {
                        fscOrderItemBO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                        fscOrderItemBO.setUntaxAmt(fscOrderItemBO.getAmt().subtract(fscOrderItemBO.getTaxAmt()));
                    }
                    fscOrderItemBO.setSaleAmt(dycProEsIndexMappingInspOrderItemBO.getInspTotalSaleFee());
                    fscOrderItemBO.setSalePrice(dycProEsIndexMappingInspOrderItemBO.getSalePrice());
                    fscOrderItemBO.setSaleTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getSaleAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setSaleUntaxAmt(fscOrderItemBO.getSaleAmt().subtract(fscOrderItemBO.getSaleTaxAmt()));
                    fscOrderItemBO.setPurchaseAmt(dycProEsIndexMappingInspOrderItemBO.getInspTotalPurchaseFee());
                    fscOrderItemBO.setPurchasePrice(dycProEsIndexMappingInspOrderItemBO.getPurchasePrice());
                    fscOrderItemBO.setPurchaseTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getPurchaseAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setPurchaseUntaxAmt(fscOrderItemBO.getPurchaseAmt().subtract(fscOrderItemBO.getPurchaseTaxAmt()));
                    fscOrderItemBO.setOrderItemId(dycProEsIndexMappingInspOrderItemBO.getInspOrderItemId());
                    fscOrderItemBO.setOrderId(row.getSaleOrderId());
                    fscOrderItemBO.setSkuNo(dycProEsIndexMappingInspOrderItemBO.getSkuCode());
                    fscOrderItemBOS.add(fscOrderItemBO);
                }
            }
            fscOrderInfoBO.setAcceptOrderId(row.getInspOrderId());
            fscOrderInfoBO.setOrderId(row.getSaleOrderId());
            fscOrderInfoBO.setAcceptOrderNo(row.getInspOrderNo());
            fscOrderInfoBO.setExtOrderNo(row.getSaleOrderNoExt());
            fscOrderInfoBO.setSupplierName(row.getSaleStakeholder().getSupName());
            fscOrderInfoBO.setSupplierId(row.getSaleStakeholder().getSupId());
            fscOrderInfoBO.setProOrgName(row.getSaleStakeholder().getProName());
            fscOrderInfoBO.setProOrgId(Convert.toStr((Object)row.getSaleStakeholder().getProId()));
            fscOrderInfoBO.setPurchaserName(row.getSaleStakeholder().getPurName());
            fscOrderInfoBO.setPurchaserId(Convert.toStr((Object)row.getSaleStakeholder().getPurOrgId()));
            fscOrderInfoBO.setOrderNo(row.getSaleOrderNo());
            fscOrderInfoBO.setBusiMode(row.getModelSettle());
            fscOrderInfoBO.setSaleOrderNo(row.getSaleOrderNo());
            fscOrderInfoBO.setInspTotalPurchaseMoney(row.getInspTotalPurchaseFee());
            fscOrderInfoBO.setInspTotalSaleMoney(row.getInspTotalSaleFee());
            fscOrderInfoBO.setInspectionOper(row.getInspOper());
            fscOrderInfoBO.setCompanyId(Long.valueOf(row.getSaleStakeholder().getPurCompanyId()));
            fscOrderInfoBO.setCompanyName(row.getSaleStakeholder().getPurCompanyName());
            fscOrderInfoBO.setInspectionTime(row.getCreateTime());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                fscOrderInfoBO.setOrderNo(row.getSaleOrderNo());
                fscOrderInfoBO.setInspTotalMoney(row.getInspTotalSaleFee());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscOrderInfoBO.setOrderNo(row.getSaleOrderNo());
                fscOrderInfoBO.setInspTotalMoney(row.getInspTotalPurchaseFee());
            }
            if (null != row.getInspInvoice()) {
                DycProEsIndexMappingInspInvoiceBO invoice = row.getInspInvoice();
                fscOrderInfoBO.setBuyName(invoice.getBuyerName());
                fscOrderInfoBO.setTaxNo(invoice.getInvoiceNo());
                if (null != invoice.getInvoiceType()) {
                    fscOrderInfoBO.setInvoiceType("0" + Convert.toStr((Object)invoice.getInvoiceType()));
                }
                fscOrderInfoBO.setInvoiceCategory(Convert.toInt((Object)invoice.getInvoceCategory()));
                fscOrderInfoBO.setBank(invoice.getDepositBank());
                fscOrderInfoBO.setAccount(invoice.getBankAccount());
                fscOrderInfoBO.setAddress(invoice.getCompanyAddress());
                fscOrderInfoBO.setPhone(invoice.getRelaPhone());
                fscOrderInfoBO.setEmail(invoice.getRelaEmail());
                fscOrderInfoBO.setFixPhone(invoice.getFixPhone());
            }
            fscOrderInfoBO.setFscOrderItemBOS(fscOrderItemBOS);
            fscOrderInfoBO.setPurchasePath(row.getSaleStakeholder().getPurOrgPath());
            fscOrderInfoBO.setProPath(row.getSaleStakeholder().getProOrgPath());
            fscOrderInfoBO.setSupplierPath(row.getSaleStakeholder().getSupOrgPath());
            fscOrderInfoBoMap.put(fscOrderInfoBO.getAcceptOrderId(), fscOrderInfoBO);
        }
        return fscOrderInfoBoMap;
    }
}

